/*
 * Decompiled with CFR 0.152.
 */
package com.mrbelieve.mvw.items.tool;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ToolItem2
extends TieredItem
implements IVanishable {
    private final Set<Block> effectiveBlocks;
    protected final float efficiency;
    public final float attackDamage;
    public final float scytheRadius;
    private final Multimap<Attribute, AttributeModifier> toolAttributes;

    public ToolItem2(float attackDamageIn, float attackSpeedIn, float scytheRadiusIn, IItemTier tier, Set<Block> effectiveBlocksIn, Item.Properties builderIn) {
        super(tier, builderIn);
        this.effectiveBlocks = effectiveBlocksIn;
        this.efficiency = tier.func_200928_b();
        this.attackDamage = attackDamageIn + tier.func_200929_c();
        this.scytheRadius = scytheRadiusIn;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)attackSpeedIn, AttributeModifier.Operation.ADDITION));
        this.toolAttributes = builder.build();
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        if (this.getToolTypes(stack).stream().anyMatch(e -> state.isToolEffective(e))) {
            return this.efficiency;
        }
        return this.effectiveBlocks.contains(state.func_177230_c()) ? this.efficiency : 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(2, attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.field_72995_K && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(1, entityLiving, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return equipmentSlot == EquipmentSlotType.MAINHAND ? this.toolAttributes : super.func_111205_h(equipmentSlot);
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    protected void onEntityHit(EntityRayTraceResult p_213868_1_) {
    }
}

