/*
 * Decompiled with CFR 0.152.
 */
package com.mrbelieve.mvw.items.spears;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mrbelieve.mvw.entities.DiamondSpearEntity;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.TieredItem;
import net.minecraft.item.UseAction;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class DiamondSpearItem
extends TieredItem {
    private final float damage;
    private final float speed;
    private final String tierName;

    public DiamondSpearItem(IItemTier tier, float damage, float speed, Item.Properties itemGroup, String tierName) {
        super(tier, itemGroup);
        this.tierName = tierName;
        this.damage = damage;
        this.speed = speed;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y.func_77557_a(Items.field_203184_eO);
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.SPEAR;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entity, int time) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        int time2 = this.func_77626_a(stack) - time;
        if (time2 < 10) {
            return;
        }
        int riptide = EnchantmentHelper.func_203190_g((ItemStack)stack);
        if (riptide > 0 && !player.func_70026_G()) {
            return;
        }
        if (!worldIn.field_72995_K) {
            stack.func_222118_a(1, (LivingEntity)player, PlayerEntity2 -> player.func_213334_d(entity.func_184600_cs()));
            if (riptide == 0) {
                DiamondSpearEntity tridentEntity2 = new DiamondSpearEntity(worldIn, (LivingEntity)player, stack, this.damage, this.tierName);
                tridentEntity2.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 2.5f + (float)riptide * 0.5f, 1.0f);
                if (player.field_71075_bZ.field_75098_d) {
                    tridentEntity2.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                }
                worldIn.func_217376_c((Entity)tridentEntity2);
                worldIn.func_217384_a(null, (Entity)tridentEntity2, SoundEvents.field_203274_ip, SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_184437_d(stack);
                }
            }
        }
        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        if (riptide > 0) {
            float rotationY = player.field_70177_z;
            float rotationX = player.field_70125_A;
            float math1 = -MathHelper.func_76126_a((float)(rotationY * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationX * ((float)Math.PI / 180)));
            float math2 = -MathHelper.func_76126_a((float)(rotationX * ((float)Math.PI / 180)));
            float math3 = MathHelper.func_76134_b((float)(rotationY * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationX * ((float)Math.PI / 180)));
            float math4 = MathHelper.func_76129_c((float)(math1 * math1 + math2 * math2 + math3 * math3));
            float math5 = 3.0f * ((1.0f + (float)riptide) / 4.0f);
            player.func_70024_g((double)(math1 *= math5 / math4), (double)(math2 *= math5 / math4), (double)(math3 *= math5 / math4));
            player.func_204803_n(20);
            if (!player.field_70160_al) {
                float math6 = 1.1999999f;
                player.func_213315_a(MoverType.SELF, new Vector3d(0.0, 1.1999999284744263, 0.0));
            }
            SoundEvent soundEvent = riptide >= 3 ? SoundEvents.field_203273_io : (riptide == 2 ? SoundEvents.field_203272_in : SoundEvents.field_203271_im);
            worldIn.func_217384_a(null, (Entity)player, soundEvent, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77952_i() >= stack.func_77958_k() - 1) {
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        if (EnchantmentHelper.func_203190_g((ItemStack)stack) > 0 && !player.func_70026_G()) {
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity entity) {
        stack.func_222118_a(1, entity, LivingEntity2 -> LivingEntity2.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos position, LivingEntity entity) {
        if ((double)state.func_185887_b((IBlockReader)worldIn, position) != 0.0) {
            stack.func_222118_a(2, entity, LivingEntity2 -> LivingEntity2.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType eqSlot) {
        HashMultimap multimap = HashMultimap.create();
        if (eqSlot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.damage, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.speed, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }
}

