/*
 * Decompiled with CFR 0.152.
 */
package com.mrbelieve.mvw.items;

import Config.Config;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.ToolItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.ForgeEventFactory;

public class ScytheItem
extends ToolItem {
    private static final Set<Block> EFFECTIVE_ON_BLOCKS = ImmutableSet.of((Object)Blocks.field_189878_dg, (Object)Blocks.field_235374_mn_, (Object)Blocks.field_150407_cf, (Object)Blocks.field_203216_jz, (Object)Blocks.field_235396_nb_, (Object)Blocks.field_235383_mw_, (Object[])new Block[]{Blocks.field_150360_v, Blocks.field_196577_ad, Blocks.field_196648_Z, Blocks.field_196642_W, Blocks.field_196645_X, Blocks.field_196574_ab, Blocks.field_196572_aa, Blocks.field_196647_Y});
    protected static final Map<Block, BlockState> HOE_LOOKUP = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.field_196658_i, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_185774_da, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_150346_d, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_196660_k, (Object)Blocks.field_150346_d.func_176223_P()));
    private final float attackDamage;
    private final float tierDamage;
    public static final float HIT_RADIUS = 3.2f;

    public ScytheItem(IItemTier itemTier, float attackDamage, float attackSpeed, Item.Properties properties) {
        super((float)((int)attackDamage), attackSpeed, itemTier, EFFECTIVE_ON_BLOCKS, properties.addToolType(ToolType.HOE, itemTier.func_200925_d()));
        this.attackDamage = attackDamage + itemTier.func_200929_c();
        this.tierDamage = itemTier.func_200929_c();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y.func_77557_a(Items.field_151036_c);
    }

    @Nullable
    public static BlockState getHoeTillingState(BlockState originalState) {
        return HOE_LOOKUP.get(originalState.func_177230_c());
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        World world = target.field_70170_p;
        if (!world.field_72995_K) {
            List effects = PotionUtils.func_185189_a((ItemStack)stack);
            AxisAlignedBB aabb = new AxisAlignedBB(target.func_213303_ch().func_72441_c((double)-3.2f, (double)-3.2f, (double)-3.2f), target.func_213303_ch().func_72441_c((double)3.2f, (double)3.2f, (double)3.2f));
            for (LivingEntity entity : world.func_217357_a(LivingEntity.class, aabb)) {
                if (entity.equals((Object)attacker) || !(entity.func_70032_d((Entity)target) <= 3.2f)) continue;
                entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)attacker), Config.ScytheBaseDamage + this.tierDamage + 1.0f);
                for (EffectInstance effectInstance : effects) {
                    if (!effectInstance.func_188419_a().func_76403_b()) continue;
                    effectInstance.func_188419_a().func_180793_a((Entity)attacker, (Entity)attacker, entity, effectInstance.func_76458_c(), 1.0);
                }
            }
        }
        stack.func_222118_a(1, attacker, p_220045_0_ -> p_220045_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.all_scythe").func_240699_a_(TextFormatting.GREEN));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockState blockstate;
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        int hook = ForgeEventFactory.onHoeUse((ItemUseContext)context);
        if (hook != 0) {
            return hook > 0 ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        if (context.func_196000_l() != Direction.DOWN && world.func_175623_d(blockpos.func_177984_a()) && (blockstate = world.func_180495_p(blockpos).getToolModifiedState(world, blockpos, context.func_195999_j(), context.func_195996_i(), ToolType.HOE)) != null) {
            PlayerEntity playerentity = context.func_195999_j();
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, blockstate, 11);
                if (playerentity != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, player -> player.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }
}

