/*
 * Decompiled with CFR 0.152.
 */
package com.mrbelieve.mvw.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mrbelieve.mvw.init.AttributeRegistry;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.TieredItem;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RapierItem
extends TieredItem
implements IVanishable {
    private final float attackDamage;
    private final float attackSpeed;
    private Multimap<Attribute, AttributeModifier> attributeModifiers;
    private static final UUID ATTACK_REACH_MODIFIER = UUID.fromString("63d316c1-7d6d-41be-81c3-41fc1a216c27");

    public RapierItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builderIn) {
        super(tier, builderIn);
        this.attackDamage = attackDamageIn + tier.func_200929_c();
        this.attackSpeed = attackSpeedIn;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)attackSpeedIn, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public static void setAttributeModifierMultimap(RapierItem ThisItem) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)ThisItem.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)ThisItem.attackSpeed, AttributeModifier.Operation.ADDITION));
        builder.put((Object)AttributeRegistry.ATTACK_REACH.get(), (Object)new AttributeModifier(ATTACK_REACH_MODIFIER, "Weapon modifier", 0.5, AttributeModifier.Operation.ADDITION));
        ThisItem.attributeModifiers = builder.build();
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        if (state.func_203425_a(Blocks.field_196553_aF)) {
            return 15.0f;
        }
        Material material = state.func_185904_a();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && !state.func_235714_a_((ITag)BlockTags.field_206952_E) && material != Material.field_151572_C ? 1.0f : 1.5f;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(2, entityLiving, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y.func_77557_a(Items.field_151040_l) && enchantment != Enchantments.field_191530_r;
    }

    public boolean func_150897_b(BlockState blockIn) {
        return blockIn.func_203425_a(Blocks.field_196553_aF);
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return equipmentSlot == EquipmentSlotType.MAINHAND ? this.attributeModifiers : super.func_111205_h(equipmentSlot);
    }
}

