/*
 * Decompiled with CFR 0.152.
 */
package com.mrbelieve.mvw.entities;

import com.mrbelieve.mvw.EntityRegistryHandler;
import com.mrbelieve.mvw.Registry.ModItems;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class StoneSpearEntity
extends AbstractArrowEntity {
    private static DataParameter<Byte> LVL_LOYALTY = EntityDataManager.func_187226_a(StoneSpearEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static DataParameter<Boolean> LVL_FOIL = EntityDataManager.func_187226_a(StoneSpearEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private ItemStack tridentItem;
    private boolean dealtDamage;
    public int returningTicks;
    private float damage;

    public StoneSpearEntity(EntityType<? extends StoneSpearEntity> entityType, World worldIn) {
        super(entityType, worldIn);
        this.tridentItem = new ItemStack((IItemProvider)ModItems.STONE_SPEAR.get());
    }

    public StoneSpearEntity(World worldIn, LivingEntity entity, ItemStack stack, float damage, String tierName) {
        super(EntityRegistryHandler.STONE_SPEAR, entity, worldIn);
        this.damage = damage + 6.0f;
        this.tridentItem = new ItemStack((IItemProvider)ModItems.STONE_SPEAR.get());
        this.tridentItem = stack.func_77946_l();
        this.field_70180_af.func_187227_b(LVL_LOYALTY, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)stack)));
        this.field_70180_af.func_187227_b(LVL_FOIL, (Object)stack.func_77962_s());
    }

    public StoneSpearEntity(World worldIn, double x, double y, double z) {
        super(EntityRegistryHandler.STONE_SPEAR, x, y, z, worldIn);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LVL_LOYALTY, (Object)0);
        this.field_70180_af.func_187214_a(LVL_FOIL, (Object)false);
    }

    public void func_70071_h_() {
        if (this.field_184552_b > 4) {
            this.dealtDamage = true;
        }
        Entity owner = this.func_234616_v_();
        if ((this.dealtDamage || this.func_203047_q()) && owner != null) {
            byte loyalty = (Byte)this.field_70180_af.func_187225_a(LVL_LOYALTY);
            if (loyalty > 0 && !this.shouldReturnToThrower()) {
                if (!this.field_70170_p.field_72995_K && this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            } else if (loyalty > 0) {
                this.func_203045_n(true);
                Vector3d vec = new Vector3d(owner.func_226277_ct_() - this.func_226277_ct_(), owner.func_226280_cw_() - this.func_226278_cu_(), owner.func_226281_cx_() - this.func_226281_cx_());
                this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() + vec.field_72448_b * 0.015 * (double)loyalty, this.func_226281_cx_());
                if (this.field_70170_p.field_72995_K) {
                    this.field_70137_T = this.func_226278_cu_();
                }
                double loyaltyMult = 0.05 * (double)loyalty;
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.95).func_178787_e(vec.func_72432_b().func_186678_a(loyaltyMult)));
                if (this.returningTicks == 0) {
                    this.func_184185_a(SoundEvents.field_203270_il, 10.0f, 1.0f);
                }
                ++this.returningTicks;
            }
        }
        super.func_70071_h_();
    }

    private boolean shouldReturnToThrower() {
        Entity owner = this.func_234616_v_();
        return owner != null && owner.func_70089_S() && (!(owner instanceof ServerPlayerEntity) || !owner.func_175149_v());
    }

    protected ItemStack func_184550_j() {
        return this.tridentItem.func_77946_l();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil() {
        return (Boolean)this.field_70180_af.func_187225_a(LVL_FOIL);
    }

    @Nullable
    protected EntityRayTraceResult func_213866_a(Vector3d startVec, Vector3d endVec) {
        if (this.dealtDamage) {
            return null;
        }
        return super.func_213866_a(startVec, endVec);
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        BlockPos position;
        Entity owner;
        Entity entity1 = result.func_216348_a();
        float thrownDamage = this.damage / 2.0f;
        if (entity1 instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity1;
            thrownDamage += EnchantmentHelper.func_152377_a((ItemStack)this.tridentItem, (CreatureAttribute)entity2.func_70668_bt());
        }
        DamageSource source = DamageSource.func_203096_a((Entity)this, (Entity)((owner = this.func_234616_v_()) == null ? this : owner));
        this.dealtDamage = true;
        SoundEvent soundEvent = SoundEvents.field_203268_ij;
        if (entity1.func_70097_a(source, thrownDamage)) {
            if (entity1.func_200600_R() == EntityType.field_200803_q) {
                return;
            }
            if (entity1 instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity1;
                if (owner instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)entity2, (Entity)owner);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)owner), (Entity)entity2);
                }
                this.func_184548_a(entity2);
            }
        }
        this.func_213317_d(this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01));
        float vol = 1.0f;
        if (this.field_70170_p instanceof ServerWorld && this.field_70170_p.func_72911_I() && EnchantmentHelper.func_203192_h((ItemStack)this.tridentItem) && this.field_70170_p.func_226660_f_(position = entity1.func_233580_cy_())) {
            LightningBoltEntity lightning = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(this.field_70170_p);
            lightning.func_233576_c_(Vector3d.func_237491_b_((Vector3i)position));
            lightning.func_204809_d(owner instanceof ServerPlayerEntity ? (ServerPlayerEntity)owner : null);
            this.field_70170_p.func_217376_c((Entity)lightning);
            soundEvent = SoundEvents.field_203275_iq;
            vol = 5.0f;
        }
        this.func_184185_a(soundEvent, vol, 1.0f);
    }

    protected SoundEvent func_213867_k() {
        return SoundEvents.field_203269_ik;
    }

    public void func_70100_b_(PlayerEntity player) {
        Entity owner = this.func_234616_v_();
        if (owner != null && owner.func_110124_au() != player.func_110124_au()) {
            return;
        }
        super.func_70100_b_(player);
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("Trident", 10)) {
            this.tridentItem = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Trident"));
        }
        this.dealtDamage = nbt.func_74767_n("DealtDamage");
        this.field_70180_af.func_187227_b(LVL_LOYALTY, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)this.tridentItem)));
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_218657_a("Trident", (INBT)this.tridentItem.func_77955_b(new CompoundNBT()));
        nbt.func_74757_a("DealtDamage", this.dealtDamage);
    }

    public void func_225516_i_() {
        byte loyalty = (Byte)this.field_70180_af.func_187225_a(LVL_LOYALTY);
        if (this.field_70251_a != AbstractArrowEntity.PickupStatus.ALLOWED || loyalty <= 0) {
            super.func_225516_i_();
        }
    }

    protected float func_203044_p() {
        return 0.99f;
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }
}

