/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.LWJGLMemoryUntracker;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.optifine.Config;
import net.optifine.GlErrors;
import net.optifine.util.ArrayUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TimedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageARBCallback;
import org.lwjgl.opengl.GLDebugMessageARBCallbackI;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.opengl.KHRDebug;

/*
 * Exception performing whole class analysis ignored.
 */
public class GlDebugTextUtils {
    private static final Logger field_209253_d = LogManager.getLogger();
    protected static final ByteBuffer field_209250_a = GLAllocation.func_74524_c((int)64);
    protected static final FloatBuffer field_209251_b = field_209250_a.asFloatBuffer();
    protected static final IntBuffer field_209252_c = field_209250_a.asIntBuffer();
    private static final Joiner field_209254_e = Joiner.on((char)'\n');
    private static final Joiner field_209255_f = Joiner.on((String)"; ");
    private static final Map<Integer, String> field_209256_g = Maps.newHashMap();
    private static final List<Integer> field_209257_h = ImmutableList.of((Object)37190, (Object)37191, (Object)37192, (Object)33387);
    private static final List<Integer> field_209258_i = ImmutableList.of((Object)37190, (Object)37191, (Object)37192);
    private static final Map<String, List<String>> field_209259_j = Maps.newHashMap();
    private static int[] ignoredErrors = GlDebugTextUtils.makeIgnoredErrors();

    private static int[] makeIgnoredErrors() {
        String prop = System.getProperty("gl.ignore.errors");
        if (prop == null) {
            return new int[0];
        }
        String[] parts = Config.tokenize(prop, ",");
        int[] ids = new int[]{};
        for (int i2 = 0; i2 < parts.length; ++i2) {
            int id;
            String part = parts[i2].trim();
            int n2 = id = part.startsWith("0x") ? Config.parseHexInt(part, -1) : Config.parseInt(part, -1);
            if (id < 0) {
                Config.warn("Invalid error id: " + part);
                continue;
            }
            Config.log("Ignore OpenGL error: " + id);
            ids = ArrayUtils.addIntToArray(ids, id);
        }
        return ids;
    }

    private static String func_209245_c(int p_209245_0_) {
        return "Unknown (0x" + Integer.toHexString(p_209245_0_).toUpperCase() + ")";
    }

    private static String func_209242_d(int p_209242_0_) {
        switch (p_209242_0_) {
            case 33350: {
                return "API";
            }
            case 33351: {
                return "WINDOW SYSTEM";
            }
            case 33352: {
                return "SHADER COMPILER";
            }
            case 33353: {
                return "THIRD PARTY";
            }
            case 33354: {
                return "APPLICATION";
            }
            case 33355: {
                return "OTHER";
            }
        }
        return GlDebugTextUtils.func_209245_c((int)p_209242_0_);
    }

    private static String func_209248_e(int p_209248_0_) {
        switch (p_209248_0_) {
            case 33356: {
                return "ERROR";
            }
            case 33357: {
                return "DEPRECATED BEHAVIOR";
            }
            case 33358: {
                return "UNDEFINED BEHAVIOR";
            }
            case 33359: {
                return "PORTABILITY";
            }
            case 33360: {
                return "PERFORMANCE";
            }
            case 33361: {
                return "OTHER";
            }
            case 33384: {
                return "MARKER";
            }
        }
        return GlDebugTextUtils.func_209245_c((int)p_209248_0_);
    }

    private static String func_209246_f(int p_209246_0_) {
        switch (p_209246_0_) {
            case 33387: {
                return "NOTIFICATION";
            }
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
        }
        return GlDebugTextUtils.func_209245_c((int)p_209246_0_);
    }

    private static void func_209244_a(int source, int type, int id, int severity, int messageLength, long message, long p_209244_7_) {
        if (type == 33385 || type == 33386) {
            return;
        }
        if (ArrayUtils.contains(ignoredErrors, id)) {
            return;
        }
        if (Config.isShaders() && source == 33352) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc != null && mc.func_228018_at_() != null && mc.func_228018_at_().isClosed()) {
            return;
        }
        if (!GlErrors.isEnabled(id)) {
            return;
        }
        String sourceStr = GlDebugTextUtils.func_209242_d((int)source);
        String typeStr = GlDebugTextUtils.func_209248_e((int)type);
        String severityStr = GlDebugTextUtils.func_209246_f((int)severity);
        String messageStr = GLDebugMessageCallback.getMessage((int)messageLength, (long)message);
        messageStr = StrUtils.trim(messageStr, " \n\r\t");
        String log = String.format("OpenGL %s %s: %s (%s)", sourceStr, typeStr, id, messageStr);
        Exception exc = new Exception("Stack trace");
        StackTraceElement[] stes = exc.getStackTrace();
        StackTraceElement[] stes2 = stes.length > 2 ? Arrays.copyOfRange(stes, 2, stes.length) : stes;
        exc.setStackTrace(stes2);
        if (type == 33356) {
            field_209253_d.error(log, (Throwable)exc);
        } else {
            field_209253_d.info(log, (Throwable)exc);
        }
        if (Config.isShowGlErrors() && TimedEvent.isActive("ShowGlErrorDebug", 10000L)) {
            String errorText = Config.getGlErrorString(id);
            if (id == 0 || Config.equals(errorText, "Unknown")) {
                errorText = messageStr;
            }
            String messageChat = I18n.func_135052_a((String)"of.message.openglError", (Object[])new Object[]{id, errorText});
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new StringTextComponent(messageChat));
        }
    }

    private static void func_209243_a(int value, String name) {
        field_209256_g.merge(value, name, (p_209249_0_, p_209249_1_) -> p_209249_0_ + "/" + p_209249_1_);
    }

    public static void func_209247_b(int debugVerbosity, boolean synchronous) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        if (debugVerbosity > 0) {
            GLCapabilities glcapabilities = GL.getCapabilities();
            if (glcapabilities.GL_KHR_debug) {
                GL11.glEnable((int)37600);
                if (synchronous) {
                    GL11.glEnable((int)33346);
                }
                for (int i2 = 0; i2 < field_209257_h.size(); ++i2) {
                    boolean flag = i2 < debugVerbosity;
                    KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)((Integer)field_209257_h.get(i2)), (int[])null, (boolean)flag);
                }
                KHRDebug.glDebugMessageCallback((GLDebugMessageCallbackI)((GLDebugMessageCallbackI)GLX.make(GLDebugMessageCallback.create(GlDebugTextUtils::func_209244_a), LWJGLMemoryUntracker::func_211545_a)), (long)0L);
            } else if (glcapabilities.GL_ARB_debug_output) {
                if (synchronous) {
                    GL11.glEnable((int)33346);
                }
                for (int j2 = 0; j2 < field_209258_i.size(); ++j2) {
                    boolean flag1 = j2 < debugVerbosity;
                    ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)((Integer)field_209258_i.get(j2)), (int[])null, (boolean)flag1);
                }
                ARBDebugOutput.glDebugMessageCallbackARB((GLDebugMessageARBCallbackI)((GLDebugMessageARBCallbackI)GLX.make(GLDebugMessageARBCallback.create(GlDebugTextUtils::func_209244_a), LWJGLMemoryUntracker::func_211545_a)), (long)0L);
            }
        }
    }

    static {
        GlDebugTextUtils.func_209243_a((int)256, (String)"GL11.GL_ACCUM");
        GlDebugTextUtils.func_209243_a((int)257, (String)"GL11.GL_LOAD");
        GlDebugTextUtils.func_209243_a((int)258, (String)"GL11.GL_RETURN");
        GlDebugTextUtils.func_209243_a((int)259, (String)"GL11.GL_MULT");
        GlDebugTextUtils.func_209243_a((int)260, (String)"GL11.GL_ADD");
        GlDebugTextUtils.func_209243_a((int)512, (String)"GL11.GL_NEVER");
        GlDebugTextUtils.func_209243_a((int)513, (String)"GL11.GL_LESS");
        GlDebugTextUtils.func_209243_a((int)514, (String)"GL11.GL_EQUAL");
        GlDebugTextUtils.func_209243_a((int)515, (String)"GL11.GL_LEQUAL");
        GlDebugTextUtils.func_209243_a((int)516, (String)"GL11.GL_GREATER");
        GlDebugTextUtils.func_209243_a((int)517, (String)"GL11.GL_NOTEQUAL");
        GlDebugTextUtils.func_209243_a((int)518, (String)"GL11.GL_GEQUAL");
        GlDebugTextUtils.func_209243_a((int)519, (String)"GL11.GL_ALWAYS");
        GlDebugTextUtils.func_209243_a((int)0, (String)"GL11.GL_POINTS");
        GlDebugTextUtils.func_209243_a((int)1, (String)"GL11.GL_LINES");
        GlDebugTextUtils.func_209243_a((int)2, (String)"GL11.GL_LINE_LOOP");
        GlDebugTextUtils.func_209243_a((int)3, (String)"GL11.GL_LINE_STRIP");
        GlDebugTextUtils.func_209243_a((int)4, (String)"GL11.GL_TRIANGLES");
        GlDebugTextUtils.func_209243_a((int)5, (String)"GL11.GL_TRIANGLE_STRIP");
        GlDebugTextUtils.func_209243_a((int)6, (String)"GL11.GL_TRIANGLE_FAN");
        GlDebugTextUtils.func_209243_a((int)7, (String)"GL11.GL_QUADS");
        GlDebugTextUtils.func_209243_a((int)8, (String)"GL11.GL_QUAD_STRIP");
        GlDebugTextUtils.func_209243_a((int)9, (String)"GL11.GL_POLYGON");
        GlDebugTextUtils.func_209243_a((int)0, (String)"GL11.GL_ZERO");
        GlDebugTextUtils.func_209243_a((int)1, (String)"GL11.GL_ONE");
        GlDebugTextUtils.func_209243_a((int)768, (String)"GL11.GL_SRC_COLOR");
        GlDebugTextUtils.func_209243_a((int)769, (String)"GL11.GL_ONE_MINUS_SRC_COLOR");
        GlDebugTextUtils.func_209243_a((int)770, (String)"GL11.GL_SRC_ALPHA");
        GlDebugTextUtils.func_209243_a((int)771, (String)"GL11.GL_ONE_MINUS_SRC_ALPHA");
        GlDebugTextUtils.func_209243_a((int)772, (String)"GL11.GL_DST_ALPHA");
        GlDebugTextUtils.func_209243_a((int)773, (String)"GL11.GL_ONE_MINUS_DST_ALPHA");
        GlDebugTextUtils.func_209243_a((int)774, (String)"GL11.GL_DST_COLOR");
        GlDebugTextUtils.func_209243_a((int)775, (String)"GL11.GL_ONE_MINUS_DST_COLOR");
        GlDebugTextUtils.func_209243_a((int)776, (String)"GL11.GL_SRC_ALPHA_SATURATE");
        GlDebugTextUtils.func_209243_a((int)32769, (String)"GL14.GL_CONSTANT_COLOR");
        GlDebugTextUtils.func_209243_a((int)32770, (String)"GL14.GL_ONE_MINUS_CONSTANT_COLOR");
        GlDebugTextUtils.func_209243_a((int)32771, (String)"GL14.GL_CONSTANT_ALPHA");
        GlDebugTextUtils.func_209243_a((int)32772, (String)"GL14.GL_ONE_MINUS_CONSTANT_ALPHA");
        GlDebugTextUtils.func_209243_a((int)1, (String)"GL11.GL_TRUE");
        GlDebugTextUtils.func_209243_a((int)0, (String)"GL11.GL_FALSE");
        GlDebugTextUtils.func_209243_a((int)12288, (String)"GL11.GL_CLIP_PLANE0");
        GlDebugTextUtils.func_209243_a((int)12289, (String)"GL11.GL_CLIP_PLANE1");
        GlDebugTextUtils.func_209243_a((int)12290, (String)"GL11.GL_CLIP_PLANE2");
        GlDebugTextUtils.func_209243_a((int)12291, (String)"GL11.GL_CLIP_PLANE3");
        GlDebugTextUtils.func_209243_a((int)12292, (String)"GL11.GL_CLIP_PLANE4");
        GlDebugTextUtils.func_209243_a((int)12293, (String)"GL11.GL_CLIP_PLANE5");
        GlDebugTextUtils.func_209243_a((int)5120, (String)"GL11.GL_BYTE");
        GlDebugTextUtils.func_209243_a((int)5121, (String)"GL11.GL_UNSIGNED_BYTE");
        GlDebugTextUtils.func_209243_a((int)5122, (String)"GL11.GL_SHORT");
        GlDebugTextUtils.func_209243_a((int)5123, (String)"GL11.GL_UNSIGNED_SHORT");
        GlDebugTextUtils.func_209243_a((int)5124, (String)"GL11.GL_INT");
        GlDebugTextUtils.func_209243_a((int)5125, (String)"GL11.GL_UNSIGNED_INT");
        GlDebugTextUtils.func_209243_a((int)5126, (String)"GL11.GL_FLOAT");
        GlDebugTextUtils.func_209243_a((int)5127, (String)"GL11.GL_2_BYTES");
        GlDebugTextUtils.func_209243_a((int)5128, (String)"GL11.GL_3_BYTES");
        GlDebugTextUtils.func_209243_a((int)5129, (String)"GL11.GL_4_BYTES");
        GlDebugTextUtils.func_209243_a((int)5130, (String)"GL11.GL_DOUBLE");
        GlDebugTextUtils.func_209243_a((int)0, (String)"GL11.GL_NONE");
        GlDebugTextUtils.func_209243_a((int)1024, (String)"GL11.GL_FRONT_LEFT");
        GlDebugTextUtils.func_209243_a((int)1025, (String)"GL11.GL_FRONT_RIGHT");
        GlDebugTextUtils.func_209243_a((int)1026, (String)"GL11.GL_BACK_LEFT");
        GlDebugTextUtils.func_209243_a((int)1027, (String)"GL11.GL_BACK_RIGHT");
        GlDebugTextUtils.func_209243_a((int)1028, (String)"GL11.GL_FRONT");
        GlDebugTextUtils.func_209243_a((int)1029, (String)"GL11.GL_BACK");
        GlDebugTextUtils.func_209243_a((int)1030, (String)"GL11.GL_LEFT");
        GlDebugTextUtils.func_209243_a((int)1031, (String)"GL11.GL_RIGHT");
        GlDebugTextUtils.func_209243_a((int)1032, (String)"GL11.GL_FRONT_AND_BACK");
        GlDebugTextUtils.func_209243_a((int)1033, (String)"GL11.GL_AUX0");
        GlDebugTextUtils.func_209243_a((int)1034, (String)"GL11.GL_AUX1");
        GlDebugTextUtils.func_209243_a((int)1035, (String)"GL11.GL_AUX2");
        GlDebugTextUtils.func_209243_a((int)1036, (String)"GL11.GL_AUX3");
        GlDebugTextUtils.func_209243_a((int)0, (String)"GL11.GL_NO_ERROR");
        GlDebugTextUtils.func_209243_a((int)1280, (String)"GL11.GL_INVALID_ENUM");
        GlDebugTextUtils.func_209243_a((int)1281, (String)"GL11.GL_INVALID_VALUE");
        GlDebugTextUtils.func_209243_a((int)1282, (String)"GL11.GL_INVALID_OPERATION");
        GlDebugTextUtils.func_209243_a((int)1283, (String)"GL11.GL_STACK_OVERFLOW");
        GlDebugTextUtils.func_209243_a((int)1284, (String)"GL11.GL_STACK_UNDERFLOW");
        GlDebugTextUtils.func_209243_a((int)1285, (String)"GL11.GL_OUT_OF_MEMORY");
        GlDebugTextUtils.func_209243_a((int)1536, (String)"GL11.GL_2D");
        GlDebugTextUtils.func_209243_a((int)1537, (String)"GL11.GL_3D");
        GlDebugTextUtils.func_209243_a((int)1538, (String)"GL11.GL_3D_COLOR");
        GlDebugTextUtils.func_209243_a((int)1539, (String)"GL11.GL_3D_COLOR_TEXTURE");
        GlDebugTextUtils.func_209243_a((int)1540, (String)"GL11.GL_4D_COLOR_TEXTURE");
        GlDebugTextUtils.func_209243_a((int)1792, (String)"GL11.GL_PASS_THROUGH_TOKEN");
        GlDebugTextUtils.func_209243_a((int)1793, (String)"GL11.GL_POINT_TOKEN");
        GlDebugTextUtils.func_209243_a((int)1794, (String)"GL11.GL_LINE_TOKEN");
        GlDebugTextUtils.func_209243_a((int)1795, (String)"GL11.GL_POLYGON_TOKEN");
        GlDebugTextUtils.func_209243_a((int)1796, (String)"GL11.GL_BITMAP_TOKEN");
        GlDebugTextUtils.func_209243_a((int)1797, (String)"GL11.GL_DRAW_PIXEL_TOKEN");
        GlDebugTextUtils.func_209243_a((int)1798, (String)"GL11.GL_COPY_PIXEL_TOKEN");
        GlDebugTextUtils.func_209243_a((int)1799, (String)"GL11.GL_LINE_RESET_TOKEN");
        GlDebugTextUtils.func_209243_a((int)2048, (String)"GL11.GL_EXP");
        GlDebugTextUtils.func_209243_a((int)2049, (String)"GL11.GL_EXP2");
        GlDebugTextUtils.func_209243_a((int)2304, (String)"GL11.GL_CW");
        GlDebugTextUtils.func_209243_a((int)2305, (String)"GL11.GL_CCW");
        GlDebugTextUtils.func_209243_a((int)2560, (String)"GL11.GL_COEFF");
        GlDebugTextUtils.func_209243_a((int)2561, (String)"GL11.GL_ORDER");
        GlDebugTextUtils.func_209243_a((int)2562, (String)"GL11.GL_DOMAIN");
        GlDebugTextUtils.func_209243_a((int)2816, (String)"GL11.GL_CURRENT_COLOR");
        GlDebugTextUtils.func_209243_a((int)2817, (String)"GL11.GL_CURRENT_INDEX");
        GlDebugTextUtils.func_209243_a((int)2818, (String)"GL11.GL_CURRENT_NORMAL");
        GlDebugTextUtils.func_209243_a((int)2819, (String)"GL11.GL_CURRENT_TEXTURE_COORDS");
        GlDebugTextUtils.func_209243_a((int)2820, (String)"GL11.GL_CURRENT_RASTER_COLOR");
        GlDebugTextUtils.func_209243_a((int)2821, (String)"GL11.GL_CURRENT_RASTER_INDEX");
        GlDebugTextUtils.func_209243_a((int)2822, (String)"GL11.GL_CURRENT_RASTER_TEXTURE_COORDS");
        GlDebugTextUtils.func_209243_a((int)2823, (String)"GL11.GL_CURRENT_RASTER_POSITION");
        GlDebugTextUtils.func_209243_a((int)2824, (String)"GL11.GL_CURRENT_RASTER_POSITION_VALID");
        GlDebugTextUtils.func_209243_a((int)2825, (String)"GL11.GL_CURRENT_RASTER_DISTANCE");
        GlDebugTextUtils.func_209243_a((int)2832, (String)"GL11.GL_POINT_SMOOTH");
        GlDebugTextUtils.func_209243_a((int)2833, (String)"GL11.GL_POINT_SIZE");
        GlDebugTextUtils.func_209243_a((int)2834, (String)"GL11.GL_POINT_SIZE_RANGE");
        GlDebugTextUtils.func_209243_a((int)2835, (String)"GL11.GL_POINT_SIZE_GRANULARITY");
        GlDebugTextUtils.func_209243_a((int)2848, (String)"GL11.GL_LINE_SMOOTH");
        GlDebugTextUtils.func_209243_a((int)2849, (String)"GL11.GL_LINE_WIDTH");
        GlDebugTextUtils.func_209243_a((int)2850, (String)"GL11.GL_LINE_WIDTH_RANGE");
        GlDebugTextUtils.func_209243_a((int)2851, (String)"GL11.GL_LINE_WIDTH_GRANULARITY");
        GlDebugTextUtils.func_209243_a((int)2852, (String)"GL11.GL_LINE_STIPPLE");
        GlDebugTextUtils.func_209243_a((int)2853, (String)"GL11.GL_LINE_STIPPLE_PATTERN");
        GlDebugTextUtils.func_209243_a((int)2854, (String)"GL11.GL_LINE_STIPPLE_REPEAT");
        GlDebugTextUtils.func_209243_a((int)2864, (String)"GL11.GL_LIST_MODE");
        GlDebugTextUtils.func_209243_a((int)2865, (String)"GL11.GL_MAX_LIST_NESTING");
        GlDebugTextUtils.func_209243_a((int)2866, (String)"GL11.GL_LIST_BASE");
        GlDebugTextUtils.func_209243_a((int)2867, (String)"GL11.GL_LIST_INDEX");
        GlDebugTextUtils.func_209243_a((int)2880, (String)"GL11.GL_POLYGON_MODE");
        GlDebugTextUtils.func_209243_a((int)2881, (String)"GL11.GL_POLYGON_SMOOTH");
        GlDebugTextUtils.func_209243_a((int)2882, (String)"GL11.GL_POLYGON_STIPPLE");
        GlDebugTextUtils.func_209243_a((int)2883, (String)"GL11.GL_EDGE_FLAG");
        GlDebugTextUtils.func_209243_a((int)2884, (String)"GL11.GL_CULL_FACE");
        GlDebugTextUtils.func_209243_a((int)2885, (String)"GL11.GL_CULL_FACE_MODE");
        GlDebugTextUtils.func_209243_a((int)2886, (String)"GL11.GL_FRONT_FACE");
        GlDebugTextUtils.func_209243_a((int)2896, (String)"GL11.GL_LIGHTING");
        GlDebugTextUtils.func_209243_a((int)2897, (String)"GL11.GL_LIGHT_MODEL_LOCAL_VIEWER");
        GlDebugTextUtils.func_209243_a((int)2898, (String)"GL11.GL_LIGHT_MODEL_TWO_SIDE");
        GlDebugTextUtils.func_209243_a((int)2899, (String)"GL11.GL_LIGHT_MODEL_AMBIENT");
        GlDebugTextUtils.func_209243_a((int)2900, (String)"GL11.GL_SHADE_MODEL");
        GlDebugTextUtils.func_209243_a((int)2901, (String)"GL11.GL_COLOR_MATERIAL_FACE");
        GlDebugTextUtils.func_209243_a((int)2902, (String)"GL11.GL_COLOR_MATERIAL_PARAMETER");
        GlDebugTextUtils.func_209243_a((int)2903, (String)"GL11.GL_COLOR_MATERIAL");
        GlDebugTextUtils.func_209243_a((int)2912, (String)"GL11.GL_FOG");
        GlDebugTextUtils.func_209243_a((int)2913, (String)"GL11.GL_FOG_INDEX");
        GlDebugTextUtils.func_209243_a((int)2914, (String)"GL11.GL_FOG_DENSITY");
        GlDebugTextUtils.func_209243_a((int)2915, (String)"GL11.GL_FOG_START");
        GlDebugTextUtils.func_209243_a((int)2916, (String)"GL11.GL_FOG_END");
        GlDebugTextUtils.func_209243_a((int)2917, (String)"GL11.GL_FOG_MODE");
        GlDebugTextUtils.func_209243_a((int)2918, (String)"GL11.GL_FOG_COLOR");
        GlDebugTextUtils.func_209243_a((int)2928, (String)"GL11.GL_DEPTH_RANGE");
        GlDebugTextUtils.func_209243_a((int)2929, (String)"GL11.GL_DEPTH_TEST");
        GlDebugTextUtils.func_209243_a((int)2930, (String)"GL11.GL_DEPTH_WRITEMASK");
        GlDebugTextUtils.func_209243_a((int)2931, (String)"GL11.GL_DEPTH_CLEAR_VALUE");
        GlDebugTextUtils.func_209243_a((int)2932, (String)"GL11.GL_DEPTH_FUNC");
        GlDebugTextUtils.func_209243_a((int)2944, (String)"GL11.GL_ACCUM_CLEAR_VALUE");
        GlDebugTextUtils.func_209243_a((int)2960, (String)"GL11.GL_STENCIL_TEST");
        GlDebugTextUtils.func_209243_a((int)2961, (String)"GL11.GL_STENCIL_CLEAR_VALUE");
        GlDebugTextUtils.func_209243_a((int)2962, (String)"GL11.GL_STENCIL_FUNC");
        GlDebugTextUtils.func_209243_a((int)2963, (String)"GL11.GL_STENCIL_VALUE_MASK");
        GlDebugTextUtils.func_209243_a((int)2964, (String)"GL11.GL_STENCIL_FAIL");
        GlDebugTextUtils.func_209243_a((int)2965, (String)"GL11.GL_STENCIL_PASS_DEPTH_FAIL");
        GlDebugTextUtils.func_209243_a((int)2966, (String)"GL11.GL_STENCIL_PASS_DEPTH_PASS");
        GlDebugTextUtils.func_209243_a((int)2967, (String)"GL11.GL_STENCIL_REF");
        GlDebugTextUtils.func_209243_a((int)2968, (String)"GL11.GL_STENCIL_WRITEMASK");
        GlDebugTextUtils.func_209243_a((int)2976, (String)"GL11.GL_MATRIX_MODE");
        GlDebugTextUtils.func_209243_a((int)2977, (String)"GL11.GL_NORMALIZE");
        GlDebugTextUtils.func_209243_a((int)2978, (String)"GL11.GL_VIEWPORT");
        GlDebugTextUtils.func_209243_a((int)2979, (String)"GL11.GL_MODELVIEW_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a((int)2980, (String)"GL11.GL_PROJECTION_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a((int)2981, (String)"GL11.GL_TEXTURE_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a((int)2982, (String)"GL11.GL_MODELVIEW_MATRIX");
        GlDebugTextUtils.func_209243_a((int)2983, (String)"GL11.GL_PROJECTION_MATRIX");
        GlDebugTextUtils.func_209243_a((int)2984, (String)"GL11.GL_TEXTURE_MATRIX");
        GlDebugTextUtils.func_209243_a((int)2992, (String)"GL11.GL_ATTRIB_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a((int)2993, (String)"GL11.GL_CLIENT_ATTRIB_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a((int)3008, (String)"GL11.GL_ALPHA_TEST");
        GlDebugTextUtils.func_209243_a((int)3009, (String)"GL11.GL_ALPHA_TEST_FUNC");
        GlDebugTextUtils.func_209243_a((int)3010, (String)"GL11.GL_ALPHA_TEST_REF");
        GlDebugTextUtils.func_209243_a((int)3024, (String)"GL11.GL_DITHER");
        GlDebugTextUtils.func_209243_a((int)3040, (String)"GL11.GL_BLEND_DST");
        GlDebugTextUtils.func_209243_a((int)3041, (String)"GL11.GL_BLEND_SRC");
        GlDebugTextUtils.func_209243_a((int)3042, (String)"GL11.GL_BLEND");
        GlDebugTextUtils.func_209243_a((int)3056, (String)"GL11.GL_LOGIC_OP_MODE");
        GlDebugTextUtils.func_209243_a((int)3057, (String)"GL11.GL_INDEX_LOGIC_OP");
        GlDebugTextUtils.func_209243_a((int)3058, (String)"GL11.GL_COLOR_LOGIC_OP");
        GlDebugTextUtils.func_209243_a((int)3072, (String)"GL11.GL_AUX_BUFFERS");
        GlDebugTextUtils.func_209243_a((int)3073, (String)"GL11.GL_DRAW_BUFFER");
        GlDebugTextUtils.func_209243_a((int)3074, (String)"GL11.GL_READ_BUFFER");
        GlDebugTextUtils.func_209243_a((int)3088, (String)"GL11.GL_SCISSOR_BOX");
        GlDebugTextUtils.func_209243_a((int)3089, (String)"GL11.GL_SCISSOR_TEST");
        GlDebugTextUtils.func_209243_a((int)3104, (String)"GL11.GL_INDEX_CLEAR_VALUE");
        GlDebugTextUtils.func_209243_a((int)3105, (String)"GL11.GL_INDEX_WRITEMASK");
        GlDebugTextUtils.func_209243_a((int)3106, (String)"GL11.GL_COLOR_CLEAR_VALUE");
        GlDebugTextUtils.func_209243_a((int)3107, (String)"GL11.GL_COLOR_WRITEMASK");
        GlDebugTextUtils.func_209243_a((int)3120, (String)"GL11.GL_INDEX_MODE");
        GlDebugTextUtils.func_209243_a((int)3121, (String)"GL11.GL_RGBA_MODE");
        GlDebugTextUtils.func_209243_a((int)3122, (String)"GL11.GL_DOUBLEBUFFER");
        GlDebugTextUtils.func_209243_a((int)3123, (String)"GL11.GL_STEREO");
        GlDebugTextUtils.func_209243_a((int)3136, (String)"GL11.GL_RENDER_MODE");
        GlDebugTextUtils.func_209243_a((int)3152, (String)"GL11.GL_PERSPECTIVE_CORRECTION_HINT");
        GlDebugTextUtils.func_209243_a((int)3153, (String)"GL11.GL_POINT_SMOOTH_HINT");
        GlDebugTextUtils.func_209243_a((int)3154, (String)"GL11.GL_LINE_SMOOTH_HINT");
        GlDebugTextUtils.func_209243_a((int)3155, (String)"GL11.GL_POLYGON_SMOOTH_HINT");
        GlDebugTextUtils.func_209243_a((int)3156, (String)"GL11.GL_FOG_HINT");
        GlDebugTextUtils.func_209243_a((int)3168, (String)"GL11.GL_TEXTURE_GEN_S");
        GlDebugTextUtils.func_209243_a((int)3169, (String)"GL11.GL_TEXTURE_GEN_T");
        GlDebugTextUtils.func_209243_a((int)3170, (String)"GL11.GL_TEXTURE_GEN_R");
        GlDebugTextUtils.func_209243_a((int)3171, (String)"GL11.GL_TEXTURE_GEN_Q");
        GlDebugTextUtils.func_209243_a((int)3184, (String)"GL11.GL_PIXEL_MAP_I_TO_I");
        GlDebugTextUtils.func_209243_a((int)3185, (String)"GL11.GL_PIXEL_MAP_S_TO_S");
        GlDebugTextUtils.func_209243_a((int)3186, (String)"GL11.GL_PIXEL_MAP_I_TO_R");
        GlDebugTextUtils.func_209243_a((int)3187, (String)"GL11.GL_PIXEL_MAP_I_TO_G");
        GlDebugTextUtils.func_209243_a((int)3188, (String)"GL11.GL_PIXEL_MAP_I_TO_B");
        GlDebugTextUtils.func_209243_a((int)3189, (String)"GL11.GL_PIXEL_MAP_I_TO_A");
        GlDebugTextUtils.func_209243_a((int)3190, (String)"GL11.GL_PIXEL_MAP_R_TO_R");
        GlDebugTextUtils.func_209243_a((int)3191, (String)"GL11.GL_PIXEL_MAP_G_TO_G");
        GlDebugTextUtils.func_209243_a((int)3192, (String)"GL11.GL_PIXEL_MAP_B_TO_B");
        GlDebugTextUtils.func_209243_a((int)3193, (String)"GL11.GL_PIXEL_MAP_A_TO_A");
        GlDebugTextUtils.func_209243_a((int)3248, (String)"GL11.GL_PIXEL_MAP_I_TO_I_SIZE");
        GlDebugTextUtils.func_209243_a((int)3249, (String)"GL11.GL_PIXEL_MAP_S_TO_S_SIZE");
        GlDebugTextUtils.func_209243_a((int)3250, (String)"GL11.GL_PIXEL_MAP_I_TO_R_SIZE");
        GlDebugTextUtils.func_209243_a((int)3251, (String)"GL11.GL_PIXEL_MAP_I_TO_G_SIZE");
        GlDebugTextUtils.func_209243_a((int)3252, (String)"GL11.GL_PIXEL_MAP_I_TO_B_SIZE");
        GlDebugTextUtils.func_209243_a((int)3253, (String)"GL11.GL_PIXEL_MAP_I_TO_A_SIZE");
        GlDebugTextUtils.func_209243_a((int)3254, (String)"GL11.GL_PIXEL_MAP_R_TO_R_SIZE");
        GlDebugTextUtils.func_209243_a((int)3255, (String)"GL11.GL_PIXEL_MAP_G_TO_G_SIZE");
        GlDebugTextUtils.func_209243_a((int)3256, (String)"GL11.GL_PIXEL_MAP_B_TO_B_SIZE");
        GlDebugTextUtils.func_209243_a((int)3257, (String)"GL11.GL_PIXEL_MAP_A_TO_A_SIZE");
        GlDebugTextUtils.func_209243_a((int)3312, (String)"GL11.GL_UNPACK_SWAP_BYTES");
        GlDebugTextUtils.func_209243_a((int)3313, (String)"GL11.GL_UNPACK_LSB_FIRST");
        GlDebugTextUtils.func_209243_a((int)3314, (String)"GL11.GL_UNPACK_ROW_LENGTH");
        GlDebugTextUtils.func_209243_a((int)3315, (String)"GL11.GL_UNPACK_SKIP_ROWS");
        GlDebugTextUtils.func_209243_a((int)3316, (String)"GL11.GL_UNPACK_SKIP_PIXELS");
        GlDebugTextUtils.func_209243_a((int)3317, (String)"GL11.GL_UNPACK_ALIGNMENT");
        GlDebugTextUtils.func_209243_a((int)3328, (String)"GL11.GL_PACK_SWAP_BYTES");
        GlDebugTextUtils.func_209243_a((int)3329, (String)"GL11.GL_PACK_LSB_FIRST");
        GlDebugTextUtils.func_209243_a((int)3330, (String)"GL11.GL_PACK_ROW_LENGTH");
        GlDebugTextUtils.func_209243_a((int)3331, (String)"GL11.GL_PACK_SKIP_ROWS");
        GlDebugTextUtils.func_209243_a((int)3332, (String)"GL11.GL_PACK_SKIP_PIXELS");
        GlDebugTextUtils.func_209243_a((int)3333, (String)"GL11.GL_PACK_ALIGNMENT");
        GlDebugTextUtils.func_209243_a((int)3344, (String)"GL11.GL_MAP_COLOR");
        GlDebugTextUtils.func_209243_a((int)3345, (String)"GL11.GL_MAP_STENCIL");
        GlDebugTextUtils.func_209243_a((int)3346, (String)"GL11.GL_INDEX_SHIFT");
        GlDebugTextUtils.func_209243_a((int)3347, (String)"GL11.GL_INDEX_OFFSET");
        GlDebugTextUtils.func_209243_a((int)3348, (String)"GL11.GL_RED_SCALE");
        GlDebugTextUtils.func_209243_a((int)3349, (String)"GL11.GL_RED_BIAS");
        GlDebugTextUtils.func_209243_a((int)3350, (String)"GL11.GL_ZOOM_X");
        GlDebugTextUtils.func_209243_a((int)3351, (String)"GL11.GL_ZOOM_Y");
        GlDebugTextUtils.func_209243_a((int)3352, (String)"GL11.GL_GREEN_SCALE");
        GlDebugTextUtils.func_209243_a((int)3353, (String)"GL11.GL_GREEN_BIAS");
        GlDebugTextUtils.func_209243_a((int)3354, (String)"GL11.GL_BLUE_SCALE");
        GlDebugTextUtils.func_209243_a((int)3355, (String)"GL11.GL_BLUE_BIAS");
        GlDebugTextUtils.func_209243_a((int)3356, (String)"GL11.GL_ALPHA_SCALE");
        GlDebugTextUtils.func_209243_a((int)3357, (String)"GL11.GL_ALPHA_BIAS");
        GlDebugTextUtils.func_209243_a((int)3358, (String)"GL11.GL_DEPTH_SCALE");
        GlDebugTextUtils.func_209243_a((int)3359, (String)"GL11.GL_DEPTH_BIAS");
        GlDebugTextUtils.func_209243_a((int)3376, (String)"GL11.GL_MAX_EVAL_ORDER");
        GlDebugTextUtils.func_209243_a((int)3377, (String)"GL11.GL_MAX_LIGHTS");
        GlDebugTextUtils.func_209243_a((int)3378, (String)"GL11.GL_MAX_CLIP_PLANES");
        GlDebugTextUtils.func_209243_a((int)3379, (String)"GL11.GL_MAX_TEXTURE_SIZE");
        GlDebugTextUtils.func_209243_a((int)3380, (String)"GL11.GL_MAX_PIXEL_MAP_TABLE");
        GlDebugTextUtils.func_209243_a((int)3381, (String)"GL11.GL_MAX_ATTRIB_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a((int)3382, (String)"GL11.GL_MAX_MODELVIEW_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a((int)3383, (String)"GL11.GL_MAX_NAME_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a((int)3384, (String)"GL11.GL_MAX_PROJECTION_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a((int)3385, (String)"GL11.GL_MAX_TEXTURE_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a((int)3386, (String)"GL11.GL_MAX_VIEWPORT_DIMS");
        GlDebugTextUtils.func_209243_a((int)3387, (String)"GL11.GL_MAX_CLIENT_ATTRIB_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a((int)3408, (String)"GL11.GL_SUBPIXEL_BITS");
        GlDebugTextUtils.func_209243_a((int)3409, (String)"GL11.GL_INDEX_BITS");
        GlDebugTextUtils.func_209243_a((int)3410, (String)"GL11.GL_RED_BITS");
        GlDebugTextUtils.func_209243_a((int)3411, (String)"GL11.GL_GREEN_BITS");
        GlDebugTextUtils.func_209243_a((int)3412, (String)"GL11.GL_BLUE_BITS");
        GlDebugTextUtils.func_209243_a((int)3413, (String)"GL11.GL_ALPHA_BITS");
        GlDebugTextUtils.func_209243_a((int)3414, (String)"GL11.GL_DEPTH_BITS");
        GlDebugTextUtils.func_209243_a((int)3415, (String)"GL11.GL_STENCIL_BITS");
        GlDebugTextUtils.func_209243_a((int)3416, (String)"GL11.GL_ACCUM_RED_BITS");
        GlDebugTextUtils.func_209243_a((int)3417, (String)"GL11.GL_ACCUM_GREEN_BITS");
        GlDebugTextUtils.func_209243_a((int)3418, (String)"GL11.GL_ACCUM_BLUE_BITS");
        GlDebugTextUtils.func_209243_a((int)3419, (String)"GL11.GL_ACCUM_ALPHA_BITS");
        GlDebugTextUtils.func_209243_a((int)3440, (String)"GL11.GL_NAME_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a((int)3456, (String)"GL11.GL_AUTO_NORMAL");
        GlDebugTextUtils.func_209243_a((int)3472, (String)"GL11.GL_MAP1_COLOR_4");
        GlDebugTextUtils.func_209243_a((int)3473, (String)"GL11.GL_MAP1_INDEX");
        GlDebugTextUtils.func_209243_a((int)3474, (String)"GL11.GL_MAP1_NORMAL");
        GlDebugTextUtils.func_209243_a((int)3475, (String)"GL11.GL_MAP1_TEXTURE_COORD_1");
        GlDebugTextUtils.func_209243_a((int)3476, (String)"GL11.GL_MAP1_TEXTURE_COORD_2");
        GlDebugTextUtils.func_209243_a((int)3477, (String)"GL11.GL_MAP1_TEXTURE_COORD_3");
        GlDebugTextUtils.func_209243_a((int)3478, (String)"GL11.GL_MAP1_TEXTURE_COORD_4");
        GlDebugTextUtils.func_209243_a((int)3479, (String)"GL11.GL_MAP1_VERTEX_3");
        GlDebugTextUtils.func_209243_a((int)3480, (String)"GL11.GL_MAP1_VERTEX_4");
        GlDebugTextUtils.func_209243_a((int)3504, (String)"GL11.GL_MAP2_COLOR_4");
        GlDebugTextUtils.func_209243_a((int)3505, (String)"GL11.GL_MAP2_INDEX");
        GlDebugTextUtils.func_209243_a((int)3506, (String)"GL11.GL_MAP2_NORMAL");
        GlDebugTextUtils.func_209243_a((int)3507, (String)"GL11.GL_MAP2_TEXTURE_COORD_1");
        GlDebugTextUtils.func_209243_a((int)3508, (String)"GL11.GL_MAP2_TEXTURE_COORD_2");
        GlDebugTextUtils.func_209243_a((int)3509, (String)"GL11.GL_MAP2_TEXTURE_COORD_3");
        GlDebugTextUtils.func_209243_a((int)3510, (String)"GL11.GL_MAP2_TEXTURE_COORD_4");
        GlDebugTextUtils.func_209243_a((int)3511, (String)"GL11.GL_MAP2_VERTEX_3");
        GlDebugTextUtils.func_209243_a((int)3512, (String)"GL11.GL_MAP2_VERTEX_4");
        GlDebugTextUtils.func_209243_a((int)3536, (String)"GL11.GL_MAP1_GRID_DOMAIN");
        GlDebugTextUtils.func_209243_a((int)3537, (String)"GL11.GL_MAP1_GRID_SEGMENTS");
        GlDebugTextUtils.func_209243_a((int)3538, (String)"GL11.GL_MAP2_GRID_DOMAIN");
        GlDebugTextUtils.func_209243_a((int)3539, (String)"GL11.GL_MAP2_GRID_SEGMENTS");
        GlDebugTextUtils.func_209243_a((int)3552, (String)"GL11.GL_TEXTURE_1D");
        GlDebugTextUtils.func_209243_a((int)3553, (String)"GL11.GL_TEXTURE_2D");
        GlDebugTextUtils.func_209243_a((int)3568, (String)"GL11.GL_FEEDBACK_BUFFER_POINTER");
        GlDebugTextUtils.func_209243_a((int)3569, (String)"GL11.GL_FEEDBACK_BUFFER_SIZE");
        GlDebugTextUtils.func_209243_a((int)3570, (String)"GL11.GL_FEEDBACK_BUFFER_TYPE");
        GlDebugTextUtils.func_209243_a((int)3571, (String)"GL11.GL_SELECTION_BUFFER_POINTER");
        GlDebugTextUtils.func_209243_a((int)3572, (String)"GL11.GL_SELECTION_BUFFER_SIZE");
        GlDebugTextUtils.func_209243_a((int)4096, (String)"GL11.GL_TEXTURE_WIDTH");
        GlDebugTextUtils.func_209243_a((int)4097, (String)"GL11.GL_TEXTURE_HEIGHT");
        GlDebugTextUtils.func_209243_a((int)4099, (String)"GL11.GL_TEXTURE_INTERNAL_FORMAT");
        GlDebugTextUtils.func_209243_a((int)4100, (String)"GL11.GL_TEXTURE_BORDER_COLOR");
        GlDebugTextUtils.func_209243_a((int)4101, (String)"GL11.GL_TEXTURE_BORDER");
        GlDebugTextUtils.func_209243_a((int)4352, (String)"GL11.GL_DONT_CARE");
        GlDebugTextUtils.func_209243_a((int)4353, (String)"GL11.GL_FASTEST");
        GlDebugTextUtils.func_209243_a((int)4354, (String)"GL11.GL_NICEST");
        GlDebugTextUtils.func_209243_a((int)16384, (String)"GL11.GL_LIGHT0");
        GlDebugTextUtils.func_209243_a((int)16385, (String)"GL11.GL_LIGHT1");
        GlDebugTextUtils.func_209243_a((int)16386, (String)"GL11.GL_LIGHT2");
        GlDebugTextUtils.func_209243_a((int)16387, (String)"GL11.GL_LIGHT3");
        GlDebugTextUtils.func_209243_a((int)16388, (String)"GL11.GL_LIGHT4");
        GlDebugTextUtils.func_209243_a((int)16389, (String)"GL11.GL_LIGHT5");
        GlDebugTextUtils.func_209243_a((int)16390, (String)"GL11.GL_LIGHT6");
        GlDebugTextUtils.func_209243_a((int)16391, (String)"GL11.GL_LIGHT7");
        GlDebugTextUtils.func_209243_a((int)4608, (String)"GL11.GL_AMBIENT");
        GlDebugTextUtils.func_209243_a((int)4609, (String)"GL11.GL_DIFFUSE");
        GlDebugTextUtils.func_209243_a((int)4610, (String)"GL11.GL_SPECULAR");
        GlDebugTextUtils.func_209243_a((int)4611, (String)"GL11.GL_POSITION");
        GlDebugTextUtils.func_209243_a((int)4612, (String)"GL11.GL_SPOT_DIRECTION");
        GlDebugTextUtils.func_209243_a((int)4613, (String)"GL11.GL_SPOT_EXPONENT");
        GlDebugTextUtils.func_209243_a((int)4614, (String)"GL11.GL_SPOT_CUTOFF");
        GlDebugTextUtils.func_209243_a((int)4615, (String)"GL11.GL_CONSTANT_ATTENUATION");
        GlDebugTextUtils.func_209243_a((int)4616, (String)"GL11.GL_LINEAR_ATTENUATION");
        GlDebugTextUtils.func_209243_a((int)4617, (String)"GL11.GL_QUADRATIC_ATTENUATION");
        GlDebugTextUtils.func_209243_a((int)4864, (String)"GL11.GL_COMPILE");
        GlDebugTextUtils.func_209243_a((int)4865, (String)"GL11.GL_COMPILE_AND_EXECUTE");
        GlDebugTextUtils.func_209243_a((int)5376, (String)"GL11.GL_CLEAR");
        GlDebugTextUtils.func_209243_a((int)5377, (String)"GL11.GL_AND");
        GlDebugTextUtils.func_209243_a((int)5378, (String)"GL11.GL_AND_REVERSE");
        GlDebugTextUtils.func_209243_a((int)5379, (String)"GL11.GL_COPY");
        GlDebugTextUtils.func_209243_a((int)5380, (String)"GL11.GL_AND_INVERTED");
        GlDebugTextUtils.func_209243_a((int)5381, (String)"GL11.GL_NOOP");
        GlDebugTextUtils.func_209243_a((int)5382, (String)"GL11.GL_XOR");
        GlDebugTextUtils.func_209243_a((int)5383, (String)"GL11.GL_OR");
        GlDebugTextUtils.func_209243_a((int)5384, (String)"GL11.GL_NOR");
        GlDebugTextUtils.func_209243_a((int)5385, (String)"GL11.GL_EQUIV");
        GlDebugTextUtils.func_209243_a((int)5386, (String)"GL11.GL_INVERT");
        GlDebugTextUtils.func_209243_a((int)5387, (String)"GL11.GL_OR_REVERSE");
        GlDebugTextUtils.func_209243_a((int)5388, (String)"GL11.GL_COPY_INVERTED");
        GlDebugTextUtils.func_209243_a((int)5389, (String)"GL11.GL_OR_INVERTED");
        GlDebugTextUtils.func_209243_a((int)5390, (String)"GL11.GL_NAND");
        GlDebugTextUtils.func_209243_a((int)5391, (String)"GL11.GL_SET");
        GlDebugTextUtils.func_209243_a((int)5632, (String)"GL11.GL_EMISSION");
        GlDebugTextUtils.func_209243_a((int)5633, (String)"GL11.GL_SHININESS");
        GlDebugTextUtils.func_209243_a((int)5634, (String)"GL11.GL_AMBIENT_AND_DIFFUSE");
        GlDebugTextUtils.func_209243_a((int)5635, (String)"GL11.GL_COLOR_INDEXES");
        GlDebugTextUtils.func_209243_a((int)5888, (String)"GL11.GL_MODELVIEW");
        GlDebugTextUtils.func_209243_a((int)5889, (String)"GL11.GL_PROJECTION");
        GlDebugTextUtils.func_209243_a((int)5890, (String)"GL11.GL_TEXTURE");
        GlDebugTextUtils.func_209243_a((int)6144, (String)"GL11.GL_COLOR");
        GlDebugTextUtils.func_209243_a((int)6145, (String)"GL11.GL_DEPTH");
        GlDebugTextUtils.func_209243_a((int)6146, (String)"GL11.GL_STENCIL");
        GlDebugTextUtils.func_209243_a((int)6400, (String)"GL11.GL_COLOR_INDEX");
        GlDebugTextUtils.func_209243_a((int)6401, (String)"GL11.GL_STENCIL_INDEX");
        GlDebugTextUtils.func_209243_a((int)6402, (String)"GL11.GL_DEPTH_COMPONENT");
        GlDebugTextUtils.func_209243_a((int)6403, (String)"GL11.GL_RED");
        GlDebugTextUtils.func_209243_a((int)6404, (String)"GL11.GL_GREEN");
        GlDebugTextUtils.func_209243_a((int)6405, (String)"GL11.GL_BLUE");
        GlDebugTextUtils.func_209243_a((int)6406, (String)"GL11.GL_ALPHA");
        GlDebugTextUtils.func_209243_a((int)6407, (String)"GL11.GL_RGB");
        GlDebugTextUtils.func_209243_a((int)6408, (String)"GL11.GL_RGBA");
        GlDebugTextUtils.func_209243_a((int)6409, (String)"GL11.GL_LUMINANCE");
        GlDebugTextUtils.func_209243_a((int)6410, (String)"GL11.GL_LUMINANCE_ALPHA");
        GlDebugTextUtils.func_209243_a((int)6656, (String)"GL11.GL_BITMAP");
        GlDebugTextUtils.func_209243_a((int)6912, (String)"GL11.GL_POINT");
        GlDebugTextUtils.func_209243_a((int)6913, (String)"GL11.GL_LINE");
        GlDebugTextUtils.func_209243_a((int)6914, (String)"GL11.GL_FILL");
        GlDebugTextUtils.func_209243_a((int)7168, (String)"GL11.GL_RENDER");
        GlDebugTextUtils.func_209243_a((int)7169, (String)"GL11.GL_FEEDBACK");
        GlDebugTextUtils.func_209243_a((int)7170, (String)"GL11.GL_SELECT");
        GlDebugTextUtils.func_209243_a((int)7424, (String)"GL11.GL_FLAT");
        GlDebugTextUtils.func_209243_a((int)7425, (String)"GL11.GL_SMOOTH");
        GlDebugTextUtils.func_209243_a((int)7680, (String)"GL11.GL_KEEP");
        GlDebugTextUtils.func_209243_a((int)7681, (String)"GL11.GL_REPLACE");
        GlDebugTextUtils.func_209243_a((int)7682, (String)"GL11.GL_INCR");
        GlDebugTextUtils.func_209243_a((int)7683, (String)"GL11.GL_DECR");
        GlDebugTextUtils.func_209243_a((int)7936, (String)"GL11.GL_VENDOR");
        GlDebugTextUtils.func_209243_a((int)7937, (String)"GL11.GL_RENDERER");
        GlDebugTextUtils.func_209243_a((int)7938, (String)"GL11.GL_VERSION");
        GlDebugTextUtils.func_209243_a((int)7939, (String)"GL11.GL_EXTENSIONS");
        GlDebugTextUtils.func_209243_a((int)8192, (String)"GL11.GL_S");
        GlDebugTextUtils.func_209243_a((int)8193, (String)"GL11.GL_T");
        GlDebugTextUtils.func_209243_a((int)8194, (String)"GL11.GL_R");
        GlDebugTextUtils.func_209243_a((int)8195, (String)"GL11.GL_Q");
        GlDebugTextUtils.func_209243_a((int)8448, (String)"GL11.GL_MODULATE");
        GlDebugTextUtils.func_209243_a((int)8449, (String)"GL11.GL_DECAL");
        GlDebugTextUtils.func_209243_a((int)8704, (String)"GL11.GL_TEXTURE_ENV_MODE");
        GlDebugTextUtils.func_209243_a((int)8705, (String)"GL11.GL_TEXTURE_ENV_COLOR");
        GlDebugTextUtils.func_209243_a((int)8960, (String)"GL11.GL_TEXTURE_ENV");
        GlDebugTextUtils.func_209243_a((int)9216, (String)"GL11.GL_EYE_LINEAR");
        GlDebugTextUtils.func_209243_a((int)9217, (String)"GL11.GL_OBJECT_LINEAR");
        GlDebugTextUtils.func_209243_a((int)9218, (String)"GL11.GL_SPHERE_MAP");
        GlDebugTextUtils.func_209243_a((int)9472, (String)"GL11.GL_TEXTURE_GEN_MODE");
        GlDebugTextUtils.func_209243_a((int)9473, (String)"GL11.GL_OBJECT_PLANE");
        GlDebugTextUtils.func_209243_a((int)9474, (String)"GL11.GL_EYE_PLANE");
        GlDebugTextUtils.func_209243_a((int)9728, (String)"GL11.GL_NEAREST");
        GlDebugTextUtils.func_209243_a((int)9729, (String)"GL11.GL_LINEAR");
        GlDebugTextUtils.func_209243_a((int)9984, (String)"GL11.GL_NEAREST_MIPMAP_NEAREST");
        GlDebugTextUtils.func_209243_a((int)9985, (String)"GL11.GL_LINEAR_MIPMAP_NEAREST");
        GlDebugTextUtils.func_209243_a((int)9986, (String)"GL11.GL_NEAREST_MIPMAP_LINEAR");
        GlDebugTextUtils.func_209243_a((int)9987, (String)"GL11.GL_LINEAR_MIPMAP_LINEAR");
        GlDebugTextUtils.func_209243_a((int)10240, (String)"GL11.GL_TEXTURE_MAG_FILTER");
        GlDebugTextUtils.func_209243_a((int)10241, (String)"GL11.GL_TEXTURE_MIN_FILTER");
        GlDebugTextUtils.func_209243_a((int)10242, (String)"GL11.GL_TEXTURE_WRAP_S");
        GlDebugTextUtils.func_209243_a((int)10243, (String)"GL11.GL_TEXTURE_WRAP_T");
        GlDebugTextUtils.func_209243_a((int)10496, (String)"GL11.GL_CLAMP");
        GlDebugTextUtils.func_209243_a((int)10497, (String)"GL11.GL_REPEAT");
        GlDebugTextUtils.func_209243_a((int)-1, (String)"GL11.GL_ALL_CLIENT_ATTRIB_BITS");
        GlDebugTextUtils.func_209243_a((int)32824, (String)"GL11.GL_POLYGON_OFFSET_FACTOR");
        GlDebugTextUtils.func_209243_a((int)10752, (String)"GL11.GL_POLYGON_OFFSET_UNITS");
        GlDebugTextUtils.func_209243_a((int)10753, (String)"GL11.GL_POLYGON_OFFSET_POINT");
        GlDebugTextUtils.func_209243_a((int)10754, (String)"GL11.GL_POLYGON_OFFSET_LINE");
        GlDebugTextUtils.func_209243_a((int)32823, (String)"GL11.GL_POLYGON_OFFSET_FILL");
        GlDebugTextUtils.func_209243_a((int)32827, (String)"GL11.GL_ALPHA4");
        GlDebugTextUtils.func_209243_a((int)32828, (String)"GL11.GL_ALPHA8");
        GlDebugTextUtils.func_209243_a((int)32829, (String)"GL11.GL_ALPHA12");
        GlDebugTextUtils.func_209243_a((int)32830, (String)"GL11.GL_ALPHA16");
        GlDebugTextUtils.func_209243_a((int)32831, (String)"GL11.GL_LUMINANCE4");
        GlDebugTextUtils.func_209243_a((int)32832, (String)"GL11.GL_LUMINANCE8");
        GlDebugTextUtils.func_209243_a((int)32833, (String)"GL11.GL_LUMINANCE12");
        GlDebugTextUtils.func_209243_a((int)32834, (String)"GL11.GL_LUMINANCE16");
        GlDebugTextUtils.func_209243_a((int)32835, (String)"GL11.GL_LUMINANCE4_ALPHA4");
        GlDebugTextUtils.func_209243_a((int)32836, (String)"GL11.GL_LUMINANCE6_ALPHA2");
        GlDebugTextUtils.func_209243_a((int)32837, (String)"GL11.GL_LUMINANCE8_ALPHA8");
        GlDebugTextUtils.func_209243_a((int)32838, (String)"GL11.GL_LUMINANCE12_ALPHA4");
        GlDebugTextUtils.func_209243_a((int)32839, (String)"GL11.GL_LUMINANCE12_ALPHA12");
        GlDebugTextUtils.func_209243_a((int)32840, (String)"GL11.GL_LUMINANCE16_ALPHA16");
        GlDebugTextUtils.func_209243_a((int)32841, (String)"GL11.GL_INTENSITY");
        GlDebugTextUtils.func_209243_a((int)32842, (String)"GL11.GL_INTENSITY4");
        GlDebugTextUtils.func_209243_a((int)32843, (String)"GL11.GL_INTENSITY8");
        GlDebugTextUtils.func_209243_a((int)32844, (String)"GL11.GL_INTENSITY12");
        GlDebugTextUtils.func_209243_a((int)32845, (String)"GL11.GL_INTENSITY16");
        GlDebugTextUtils.func_209243_a((int)10768, (String)"GL11.GL_R3_G3_B2");
        GlDebugTextUtils.func_209243_a((int)32847, (String)"GL11.GL_RGB4");
        GlDebugTextUtils.func_209243_a((int)32848, (String)"GL11.GL_RGB5");
        GlDebugTextUtils.func_209243_a((int)32849, (String)"GL11.GL_RGB8");
        GlDebugTextUtils.func_209243_a((int)32850, (String)"GL11.GL_RGB10");
        GlDebugTextUtils.func_209243_a((int)32851, (String)"GL11.GL_RGB12");
        GlDebugTextUtils.func_209243_a((int)32852, (String)"GL11.GL_RGB16");
        GlDebugTextUtils.func_209243_a((int)32853, (String)"GL11.GL_RGBA2");
        GlDebugTextUtils.func_209243_a((int)32854, (String)"GL11.GL_RGBA4");
        GlDebugTextUtils.func_209243_a((int)32855, (String)"GL11.GL_RGB5_A1");
        GlDebugTextUtils.func_209243_a((int)32856, (String)"GL11.GL_RGBA8");
        GlDebugTextUtils.func_209243_a((int)32857, (String)"GL11.GL_RGB10_A2");
        GlDebugTextUtils.func_209243_a((int)32858, (String)"GL11.GL_RGBA12");
        GlDebugTextUtils.func_209243_a((int)32859, (String)"GL11.GL_RGBA16");
        GlDebugTextUtils.func_209243_a((int)32860, (String)"GL11.GL_TEXTURE_RED_SIZE");
        GlDebugTextUtils.func_209243_a((int)32861, (String)"GL11.GL_TEXTURE_GREEN_SIZE");
        GlDebugTextUtils.func_209243_a((int)32862, (String)"GL11.GL_TEXTURE_BLUE_SIZE");
        GlDebugTextUtils.func_209243_a((int)32863, (String)"GL11.GL_TEXTURE_ALPHA_SIZE");
        GlDebugTextUtils.func_209243_a((int)32864, (String)"GL11.GL_TEXTURE_LUMINANCE_SIZE");
        GlDebugTextUtils.func_209243_a((int)32865, (String)"GL11.GL_TEXTURE_INTENSITY_SIZE");
        GlDebugTextUtils.func_209243_a((int)32867, (String)"GL11.GL_PROXY_TEXTURE_1D");
        GlDebugTextUtils.func_209243_a((int)32868, (String)"GL11.GL_PROXY_TEXTURE_2D");
        GlDebugTextUtils.func_209243_a((int)32870, (String)"GL11.GL_TEXTURE_PRIORITY");
        GlDebugTextUtils.func_209243_a((int)32871, (String)"GL11.GL_TEXTURE_RESIDENT");
        GlDebugTextUtils.func_209243_a((int)32872, (String)"GL11.GL_TEXTURE_BINDING_1D");
        GlDebugTextUtils.func_209243_a((int)32873, (String)"GL11.GL_TEXTURE_BINDING_2D");
        GlDebugTextUtils.func_209243_a((int)32884, (String)"GL11.GL_VERTEX_ARRAY");
        GlDebugTextUtils.func_209243_a((int)32885, (String)"GL11.GL_NORMAL_ARRAY");
        GlDebugTextUtils.func_209243_a((int)32886, (String)"GL11.GL_COLOR_ARRAY");
        GlDebugTextUtils.func_209243_a((int)32887, (String)"GL11.GL_INDEX_ARRAY");
        GlDebugTextUtils.func_209243_a((int)32888, (String)"GL11.GL_TEXTURE_COORD_ARRAY");
        GlDebugTextUtils.func_209243_a((int)32889, (String)"GL11.GL_EDGE_FLAG_ARRAY");
        GlDebugTextUtils.func_209243_a((int)32890, (String)"GL11.GL_VERTEX_ARRAY_SIZE");
        GlDebugTextUtils.func_209243_a((int)32891, (String)"GL11.GL_VERTEX_ARRAY_TYPE");
        GlDebugTextUtils.func_209243_a((int)32892, (String)"GL11.GL_VERTEX_ARRAY_STRIDE");
        GlDebugTextUtils.func_209243_a((int)32894, (String)"GL11.GL_NORMAL_ARRAY_TYPE");
        GlDebugTextUtils.func_209243_a((int)32895, (String)"GL11.GL_NORMAL_ARRAY_STRIDE");
        GlDebugTextUtils.func_209243_a((int)32897, (String)"GL11.GL_COLOR_ARRAY_SIZE");
        GlDebugTextUtils.func_209243_a((int)32898, (String)"GL11.GL_COLOR_ARRAY_TYPE");
        GlDebugTextUtils.func_209243_a((int)32899, (String)"GL11.GL_COLOR_ARRAY_STRIDE");
        GlDebugTextUtils.func_209243_a((int)32901, (String)"GL11.GL_INDEX_ARRAY_TYPE");
        GlDebugTextUtils.func_209243_a((int)32902, (String)"GL11.GL_INDEX_ARRAY_STRIDE");
        GlDebugTextUtils.func_209243_a((int)32904, (String)"GL11.GL_TEXTURE_COORD_ARRAY_SIZE");
        GlDebugTextUtils.func_209243_a((int)32905, (String)"GL11.GL_TEXTURE_COORD_ARRAY_TYPE");
        GlDebugTextUtils.func_209243_a((int)32906, (String)"GL11.GL_TEXTURE_COORD_ARRAY_STRIDE");
        GlDebugTextUtils.func_209243_a((int)32908, (String)"GL11.GL_EDGE_FLAG_ARRAY_STRIDE");
        GlDebugTextUtils.func_209243_a((int)32910, (String)"GL11.GL_VERTEX_ARRAY_POINTER");
        GlDebugTextUtils.func_209243_a((int)32911, (String)"GL11.GL_NORMAL_ARRAY_POINTER");
        GlDebugTextUtils.func_209243_a((int)32912, (String)"GL11.GL_COLOR_ARRAY_POINTER");
        GlDebugTextUtils.func_209243_a((int)32913, (String)"GL11.GL_INDEX_ARRAY_POINTER");
        GlDebugTextUtils.func_209243_a((int)32914, (String)"GL11.GL_TEXTURE_COORD_ARRAY_POINTER");
        GlDebugTextUtils.func_209243_a((int)32915, (String)"GL11.GL_EDGE_FLAG_ARRAY_POINTER");
        GlDebugTextUtils.func_209243_a((int)10784, (String)"GL11.GL_V2F");
        GlDebugTextUtils.func_209243_a((int)10785, (String)"GL11.GL_V3F");
        GlDebugTextUtils.func_209243_a((int)10786, (String)"GL11.GL_C4UB_V2F");
        GlDebugTextUtils.func_209243_a((int)10787, (String)"GL11.GL_C4UB_V3F");
        GlDebugTextUtils.func_209243_a((int)10788, (String)"GL11.GL_C3F_V3F");
        GlDebugTextUtils.func_209243_a((int)10789, (String)"GL11.GL_N3F_V3F");
        GlDebugTextUtils.func_209243_a((int)10790, (String)"GL11.GL_C4F_N3F_V3F");
        GlDebugTextUtils.func_209243_a((int)10791, (String)"GL11.GL_T2F_V3F");
        GlDebugTextUtils.func_209243_a((int)10792, (String)"GL11.GL_T4F_V4F");
        GlDebugTextUtils.func_209243_a((int)10793, (String)"GL11.GL_T2F_C4UB_V3F");
        GlDebugTextUtils.func_209243_a((int)10794, (String)"GL11.GL_T2F_C3F_V3F");
        GlDebugTextUtils.func_209243_a((int)10795, (String)"GL11.GL_T2F_N3F_V3F");
        GlDebugTextUtils.func_209243_a((int)10796, (String)"GL11.GL_T2F_C4F_N3F_V3F");
        GlDebugTextUtils.func_209243_a((int)10797, (String)"GL11.GL_T4F_C4F_N3F_V4F");
        GlDebugTextUtils.func_209243_a((int)3057, (String)"GL11.GL_LOGIC_OP");
        GlDebugTextUtils.func_209243_a((int)4099, (String)"GL11.GL_TEXTURE_COMPONENTS");
        GlDebugTextUtils.func_209243_a((int)32874, (String)"GL12.GL_TEXTURE_BINDING_3D");
        GlDebugTextUtils.func_209243_a((int)32875, (String)"GL12.GL_PACK_SKIP_IMAGES");
        GlDebugTextUtils.func_209243_a((int)32876, (String)"GL12.GL_PACK_IMAGE_HEIGHT");
        GlDebugTextUtils.func_209243_a((int)32877, (String)"GL12.GL_UNPACK_SKIP_IMAGES");
        GlDebugTextUtils.func_209243_a((int)32878, (String)"GL12.GL_UNPACK_IMAGE_HEIGHT");
        GlDebugTextUtils.func_209243_a((int)32879, (String)"GL12.GL_TEXTURE_3D");
        GlDebugTextUtils.func_209243_a((int)32880, (String)"GL12.GL_PROXY_TEXTURE_3D");
        GlDebugTextUtils.func_209243_a((int)32881, (String)"GL12.GL_TEXTURE_DEPTH");
        GlDebugTextUtils.func_209243_a((int)32882, (String)"GL12.GL_TEXTURE_WRAP_R");
        GlDebugTextUtils.func_209243_a((int)32883, (String)"GL12.GL_MAX_3D_TEXTURE_SIZE");
        GlDebugTextUtils.func_209243_a((int)32992, (String)"GL12.GL_BGR");
        GlDebugTextUtils.func_209243_a((int)32993, (String)"GL12.GL_BGRA");
        GlDebugTextUtils.func_209243_a((int)32818, (String)"GL12.GL_UNSIGNED_BYTE_3_3_2");
        GlDebugTextUtils.func_209243_a((int)33634, (String)"GL12.GL_UNSIGNED_BYTE_2_3_3_REV");
        GlDebugTextUtils.func_209243_a((int)33635, (String)"GL12.GL_UNSIGNED_SHORT_5_6_5");
        GlDebugTextUtils.func_209243_a((int)33636, (String)"GL12.GL_UNSIGNED_SHORT_5_6_5_REV");
        GlDebugTextUtils.func_209243_a((int)32819, (String)"GL12.GL_UNSIGNED_SHORT_4_4_4_4");
        GlDebugTextUtils.func_209243_a((int)33637, (String)"GL12.GL_UNSIGNED_SHORT_4_4_4_4_REV");
        GlDebugTextUtils.func_209243_a((int)32820, (String)"GL12.GL_UNSIGNED_SHORT_5_5_5_1");
        GlDebugTextUtils.func_209243_a((int)33638, (String)"GL12.GL_UNSIGNED_SHORT_1_5_5_5_REV");
        GlDebugTextUtils.func_209243_a((int)32821, (String)"GL12.GL_UNSIGNED_INT_8_8_8_8");
        GlDebugTextUtils.func_209243_a((int)33639, (String)"GL12.GL_UNSIGNED_INT_8_8_8_8_REV");
        GlDebugTextUtils.func_209243_a((int)32822, (String)"GL12.GL_UNSIGNED_INT_10_10_10_2");
        GlDebugTextUtils.func_209243_a((int)33640, (String)"GL12.GL_UNSIGNED_INT_2_10_10_10_REV");
        GlDebugTextUtils.func_209243_a((int)32826, (String)"GL12.GL_RESCALE_NORMAL");
        GlDebugTextUtils.func_209243_a((int)33272, (String)"GL12.GL_LIGHT_MODEL_COLOR_CONTROL");
        GlDebugTextUtils.func_209243_a((int)33273, (String)"GL12.GL_SINGLE_COLOR");
        GlDebugTextUtils.func_209243_a((int)33274, (String)"GL12.GL_SEPARATE_SPECULAR_COLOR");
        GlDebugTextUtils.func_209243_a((int)33071, (String)"GL12.GL_CLAMP_TO_EDGE");
        GlDebugTextUtils.func_209243_a((int)33082, (String)"GL12.GL_TEXTURE_MIN_LOD");
        GlDebugTextUtils.func_209243_a((int)33083, (String)"GL12.GL_TEXTURE_MAX_LOD");
        GlDebugTextUtils.func_209243_a((int)33084, (String)"GL12.GL_TEXTURE_BASE_LEVEL");
        GlDebugTextUtils.func_209243_a((int)33085, (String)"GL12.GL_TEXTURE_MAX_LEVEL");
        GlDebugTextUtils.func_209243_a((int)33000, (String)"GL12.GL_MAX_ELEMENTS_VERTICES");
        GlDebugTextUtils.func_209243_a((int)33001, (String)"GL12.GL_MAX_ELEMENTS_INDICES");
        GlDebugTextUtils.func_209243_a((int)33901, (String)"GL12.GL_ALIASED_POINT_SIZE_RANGE");
        GlDebugTextUtils.func_209243_a((int)33902, (String)"GL12.GL_ALIASED_LINE_WIDTH_RANGE");
        GlDebugTextUtils.func_209243_a((int)33984, (String)"GL13.GL_TEXTURE0");
        GlDebugTextUtils.func_209243_a((int)33985, (String)"GL13.GL_TEXTURE1");
        GlDebugTextUtils.func_209243_a((int)33986, (String)"GL13.GL_TEXTURE2");
        GlDebugTextUtils.func_209243_a((int)33987, (String)"GL13.GL_TEXTURE3");
        GlDebugTextUtils.func_209243_a((int)33988, (String)"GL13.GL_TEXTURE4");
        GlDebugTextUtils.func_209243_a((int)33989, (String)"GL13.GL_TEXTURE5");
        GlDebugTextUtils.func_209243_a((int)33990, (String)"GL13.GL_TEXTURE6");
        GlDebugTextUtils.func_209243_a((int)33991, (String)"GL13.GL_TEXTURE7");
        GlDebugTextUtils.func_209243_a((int)33992, (String)"GL13.GL_TEXTURE8");
        GlDebugTextUtils.func_209243_a((int)33993, (String)"GL13.GL_TEXTURE9");
        GlDebugTextUtils.func_209243_a((int)33994, (String)"GL13.GL_TEXTURE10");
        GlDebugTextUtils.func_209243_a((int)33995, (String)"GL13.GL_TEXTURE11");
        GlDebugTextUtils.func_209243_a((int)33996, (String)"GL13.GL_TEXTURE12");
        GlDebugTextUtils.func_209243_a((int)33997, (String)"GL13.GL_TEXTURE13");
        GlDebugTextUtils.func_209243_a((int)33998, (String)"GL13.GL_TEXTURE14");
        GlDebugTextUtils.func_209243_a((int)33999, (String)"GL13.GL_TEXTURE15");
        GlDebugTextUtils.func_209243_a((int)34000, (String)"GL13.GL_TEXTURE16");
        GlDebugTextUtils.func_209243_a((int)34001, (String)"GL13.GL_TEXTURE17");
        GlDebugTextUtils.func_209243_a((int)34002, (String)"GL13.GL_TEXTURE18");
        GlDebugTextUtils.func_209243_a((int)34003, (String)"GL13.GL_TEXTURE19");
        GlDebugTextUtils.func_209243_a((int)34004, (String)"GL13.GL_TEXTURE20");
        GlDebugTextUtils.func_209243_a((int)34005, (String)"GL13.GL_TEXTURE21");
        GlDebugTextUtils.func_209243_a((int)34006, (String)"GL13.GL_TEXTURE22");
        GlDebugTextUtils.func_209243_a((int)34007, (String)"GL13.GL_TEXTURE23");
        GlDebugTextUtils.func_209243_a((int)34008, (String)"GL13.GL_TEXTURE24");
        GlDebugTextUtils.func_209243_a((int)34009, (String)"GL13.GL_TEXTURE25");
        GlDebugTextUtils.func_209243_a((int)34010, (String)"GL13.GL_TEXTURE26");
        GlDebugTextUtils.func_209243_a((int)34011, (String)"GL13.GL_TEXTURE27");
        GlDebugTextUtils.func_209243_a((int)34012, (String)"GL13.GL_TEXTURE28");
        GlDebugTextUtils.func_209243_a((int)34013, (String)"GL13.GL_TEXTURE29");
        GlDebugTextUtils.func_209243_a((int)34014, (String)"GL13.GL_TEXTURE30");
        GlDebugTextUtils.func_209243_a((int)34015, (String)"GL13.GL_TEXTURE31");
        GlDebugTextUtils.func_209243_a((int)34016, (String)"GL13.GL_ACTIVE_TEXTURE");
        GlDebugTextUtils.func_209243_a((int)34017, (String)"GL13.GL_CLIENT_ACTIVE_TEXTURE");
        GlDebugTextUtils.func_209243_a((int)34018, (String)"GL13.GL_MAX_TEXTURE_UNITS");
        GlDebugTextUtils.func_209243_a((int)34065, (String)"GL13.GL_NORMAL_MAP");
        GlDebugTextUtils.func_209243_a((int)34066, (String)"GL13.GL_REFLECTION_MAP");
        GlDebugTextUtils.func_209243_a((int)34067, (String)"GL13.GL_TEXTURE_CUBE_MAP");
        GlDebugTextUtils.func_209243_a((int)34068, (String)"GL13.GL_TEXTURE_BINDING_CUBE_MAP");
        GlDebugTextUtils.func_209243_a((int)34069, (String)"GL13.GL_TEXTURE_CUBE_MAP_POSITIVE_X");
        GlDebugTextUtils.func_209243_a((int)34070, (String)"GL13.GL_TEXTURE_CUBE_MAP_NEGATIVE_X");
        GlDebugTextUtils.func_209243_a((int)34071, (String)"GL13.GL_TEXTURE_CUBE_MAP_POSITIVE_Y");
        GlDebugTextUtils.func_209243_a((int)34072, (String)"GL13.GL_TEXTURE_CUBE_MAP_NEGATIVE_Y");
        GlDebugTextUtils.func_209243_a((int)34073, (String)"GL13.GL_TEXTURE_CUBE_MAP_POSITIVE_Z");
        GlDebugTextUtils.func_209243_a((int)34074, (String)"GL13.GL_TEXTURE_CUBE_MAP_NEGATIVE_Z");
        GlDebugTextUtils.func_209243_a((int)34075, (String)"GL13.GL_PROXY_TEXTURE_CUBE_MAP");
        GlDebugTextUtils.func_209243_a((int)34076, (String)"GL13.GL_MAX_CUBE_MAP_TEXTURE_SIZE");
        GlDebugTextUtils.func_209243_a((int)34025, (String)"GL13.GL_COMPRESSED_ALPHA");
        GlDebugTextUtils.func_209243_a((int)34026, (String)"GL13.GL_COMPRESSED_LUMINANCE");
        GlDebugTextUtils.func_209243_a((int)34027, (String)"GL13.GL_COMPRESSED_LUMINANCE_ALPHA");
        GlDebugTextUtils.func_209243_a((int)34028, (String)"GL13.GL_COMPRESSED_INTENSITY");
        GlDebugTextUtils.func_209243_a((int)34029, (String)"GL13.GL_COMPRESSED_RGB");
        GlDebugTextUtils.func_209243_a((int)34030, (String)"GL13.GL_COMPRESSED_RGBA");
        GlDebugTextUtils.func_209243_a((int)34031, (String)"GL13.GL_TEXTURE_COMPRESSION_HINT");
        GlDebugTextUtils.func_209243_a((int)34464, (String)"GL13.GL_TEXTURE_COMPRESSED_IMAGE_SIZE");
        GlDebugTextUtils.func_209243_a((int)34465, (String)"GL13.GL_TEXTURE_COMPRESSED");
        GlDebugTextUtils.func_209243_a((int)34466, (String)"GL13.GL_NUM_COMPRESSED_TEXTURE_FORMATS");
        GlDebugTextUtils.func_209243_a((int)34467, (String)"GL13.GL_COMPRESSED_TEXTURE_FORMATS");
        GlDebugTextUtils.func_209243_a((int)32925, (String)"GL13.GL_MULTISAMPLE");
        GlDebugTextUtils.func_209243_a((int)32926, (String)"GL13.GL_SAMPLE_ALPHA_TO_COVERAGE");
        GlDebugTextUtils.func_209243_a((int)32927, (String)"GL13.GL_SAMPLE_ALPHA_TO_ONE");
        GlDebugTextUtils.func_209243_a((int)32928, (String)"GL13.GL_SAMPLE_COVERAGE");
        GlDebugTextUtils.func_209243_a((int)32936, (String)"GL13.GL_SAMPLE_BUFFERS");
        GlDebugTextUtils.func_209243_a((int)32937, (String)"GL13.GL_SAMPLES");
        GlDebugTextUtils.func_209243_a((int)32938, (String)"GL13.GL_SAMPLE_COVERAGE_VALUE");
        GlDebugTextUtils.func_209243_a((int)32939, (String)"GL13.GL_SAMPLE_COVERAGE_INVERT");
        GlDebugTextUtils.func_209243_a((int)34019, (String)"GL13.GL_TRANSPOSE_MODELVIEW_MATRIX");
        GlDebugTextUtils.func_209243_a((int)34020, (String)"GL13.GL_TRANSPOSE_PROJECTION_MATRIX");
        GlDebugTextUtils.func_209243_a((int)34021, (String)"GL13.GL_TRANSPOSE_TEXTURE_MATRIX");
        GlDebugTextUtils.func_209243_a((int)34022, (String)"GL13.GL_TRANSPOSE_COLOR_MATRIX");
        GlDebugTextUtils.func_209243_a((int)34160, (String)"GL13.GL_COMBINE");
        GlDebugTextUtils.func_209243_a((int)34161, (String)"GL13.GL_COMBINE_RGB");
        GlDebugTextUtils.func_209243_a((int)34162, (String)"GL13.GL_COMBINE_ALPHA");
        GlDebugTextUtils.func_209243_a((int)34176, (String)"GL13.GL_SOURCE0_RGB");
        GlDebugTextUtils.func_209243_a((int)34177, (String)"GL13.GL_SOURCE1_RGB");
        GlDebugTextUtils.func_209243_a((int)34178, (String)"GL13.GL_SOURCE2_RGB");
        GlDebugTextUtils.func_209243_a((int)34184, (String)"GL13.GL_SOURCE0_ALPHA");
        GlDebugTextUtils.func_209243_a((int)34185, (String)"GL13.GL_SOURCE1_ALPHA");
        GlDebugTextUtils.func_209243_a((int)34186, (String)"GL13.GL_SOURCE2_ALPHA");
        GlDebugTextUtils.func_209243_a((int)34192, (String)"GL13.GL_OPERAND0_RGB");
        GlDebugTextUtils.func_209243_a((int)34193, (String)"GL13.GL_OPERAND1_RGB");
        GlDebugTextUtils.func_209243_a((int)34194, (String)"GL13.GL_OPERAND2_RGB");
        GlDebugTextUtils.func_209243_a((int)34200, (String)"GL13.GL_OPERAND0_ALPHA");
        GlDebugTextUtils.func_209243_a((int)34201, (String)"GL13.GL_OPERAND1_ALPHA");
        GlDebugTextUtils.func_209243_a((int)34202, (String)"GL13.GL_OPERAND2_ALPHA");
        GlDebugTextUtils.func_209243_a((int)34163, (String)"GL13.GL_RGB_SCALE");
        GlDebugTextUtils.func_209243_a((int)34164, (String)"GL13.GL_ADD_SIGNED");
        GlDebugTextUtils.func_209243_a((int)34165, (String)"GL13.GL_INTERPOLATE");
        GlDebugTextUtils.func_209243_a((int)34023, (String)"GL13.GL_SUBTRACT");
        GlDebugTextUtils.func_209243_a((int)34166, (String)"GL13.GL_CONSTANT");
        GlDebugTextUtils.func_209243_a((int)34167, (String)"GL13.GL_PRIMARY_COLOR");
        GlDebugTextUtils.func_209243_a((int)34168, (String)"GL13.GL_PREVIOUS");
        GlDebugTextUtils.func_209243_a((int)34478, (String)"GL13.GL_DOT3_RGB");
        GlDebugTextUtils.func_209243_a((int)34479, (String)"GL13.GL_DOT3_RGBA");
        GlDebugTextUtils.func_209243_a((int)33069, (String)"GL13.GL_CLAMP_TO_BORDER");
        GlDebugTextUtils.func_209243_a((int)33169, (String)"GL14.GL_GENERATE_MIPMAP");
        GlDebugTextUtils.func_209243_a((int)33170, (String)"GL14.GL_GENERATE_MIPMAP_HINT");
        GlDebugTextUtils.func_209243_a((int)33189, (String)"GL14.GL_DEPTH_COMPONENT16");
        GlDebugTextUtils.func_209243_a((int)33190, (String)"GL14.GL_DEPTH_COMPONENT24");
        GlDebugTextUtils.func_209243_a((int)33191, (String)"GL14.GL_DEPTH_COMPONENT32");
        GlDebugTextUtils.func_209243_a((int)34890, (String)"GL14.GL_TEXTURE_DEPTH_SIZE");
        GlDebugTextUtils.func_209243_a((int)34891, (String)"GL14.GL_DEPTH_TEXTURE_MODE");
        GlDebugTextUtils.func_209243_a((int)34892, (String)"GL14.GL_TEXTURE_COMPARE_MODE");
        GlDebugTextUtils.func_209243_a((int)34893, (String)"GL14.GL_TEXTURE_COMPARE_FUNC");
        GlDebugTextUtils.func_209243_a((int)34894, (String)"GL14.GL_COMPARE_R_TO_TEXTURE");
        GlDebugTextUtils.func_209243_a((int)33872, (String)"GL14.GL_FOG_COORDINATE_SOURCE");
        GlDebugTextUtils.func_209243_a((int)33873, (String)"GL14.GL_FOG_COORDINATE");
        GlDebugTextUtils.func_209243_a((int)33874, (String)"GL14.GL_FRAGMENT_DEPTH");
        GlDebugTextUtils.func_209243_a((int)33875, (String)"GL14.GL_CURRENT_FOG_COORDINATE");
        GlDebugTextUtils.func_209243_a((int)33876, (String)"GL14.GL_FOG_COORDINATE_ARRAY_TYPE");
        GlDebugTextUtils.func_209243_a((int)33877, (String)"GL14.GL_FOG_COORDINATE_ARRAY_STRIDE");
        GlDebugTextUtils.func_209243_a((int)33878, (String)"GL14.GL_FOG_COORDINATE_ARRAY_POINTER");
        GlDebugTextUtils.func_209243_a((int)33879, (String)"GL14.GL_FOG_COORDINATE_ARRAY");
        GlDebugTextUtils.func_209243_a((int)33062, (String)"GL14.GL_POINT_SIZE_MIN");
        GlDebugTextUtils.func_209243_a((int)33063, (String)"GL14.GL_POINT_SIZE_MAX");
        GlDebugTextUtils.func_209243_a((int)33064, (String)"GL14.GL_POINT_FADE_THRESHOLD_SIZE");
        GlDebugTextUtils.func_209243_a((int)33065, (String)"GL14.GL_POINT_DISTANCE_ATTENUATION");
        GlDebugTextUtils.func_209243_a((int)33880, (String)"GL14.GL_COLOR_SUM");
        GlDebugTextUtils.func_209243_a((int)33881, (String)"GL14.GL_CURRENT_SECONDARY_COLOR");
        GlDebugTextUtils.func_209243_a((int)33882, (String)"GL14.GL_SECONDARY_COLOR_ARRAY_SIZE");
        GlDebugTextUtils.func_209243_a((int)33883, (String)"GL14.GL_SECONDARY_COLOR_ARRAY_TYPE");
        GlDebugTextUtils.func_209243_a((int)33884, (String)"GL14.GL_SECONDARY_COLOR_ARRAY_STRIDE");
        GlDebugTextUtils.func_209243_a((int)33885, (String)"GL14.GL_SECONDARY_COLOR_ARRAY_POINTER");
        GlDebugTextUtils.func_209243_a((int)33886, (String)"GL14.GL_SECONDARY_COLOR_ARRAY");
        GlDebugTextUtils.func_209243_a((int)32968, (String)"GL14.GL_BLEND_DST_RGB");
        GlDebugTextUtils.func_209243_a((int)32969, (String)"GL14.GL_BLEND_SRC_RGB");
        GlDebugTextUtils.func_209243_a((int)32970, (String)"GL14.GL_BLEND_DST_ALPHA");
        GlDebugTextUtils.func_209243_a((int)32971, (String)"GL14.GL_BLEND_SRC_ALPHA");
        GlDebugTextUtils.func_209243_a((int)34055, (String)"GL14.GL_INCR_WRAP");
        GlDebugTextUtils.func_209243_a((int)34056, (String)"GL14.GL_DECR_WRAP");
        GlDebugTextUtils.func_209243_a((int)34048, (String)"GL14.GL_TEXTURE_FILTER_CONTROL");
        GlDebugTextUtils.func_209243_a((int)34049, (String)"GL14.GL_TEXTURE_LOD_BIAS");
        GlDebugTextUtils.func_209243_a((int)34045, (String)"GL14.GL_MAX_TEXTURE_LOD_BIAS");
        GlDebugTextUtils.func_209243_a((int)33648, (String)"GL14.GL_MIRRORED_REPEAT");
        GlDebugTextUtils.func_209243_a((int)32773, (String)"ARBImaging.GL_BLEND_COLOR");
        GlDebugTextUtils.func_209243_a((int)32777, (String)"ARBImaging.GL_BLEND_EQUATION");
        GlDebugTextUtils.func_209243_a((int)32774, (String)"GL14.GL_FUNC_ADD");
        GlDebugTextUtils.func_209243_a((int)32778, (String)"GL14.GL_FUNC_SUBTRACT");
        GlDebugTextUtils.func_209243_a((int)32779, (String)"GL14.GL_FUNC_REVERSE_SUBTRACT");
        GlDebugTextUtils.func_209243_a((int)32775, (String)"GL14.GL_MIN");
        GlDebugTextUtils.func_209243_a((int)32776, (String)"GL14.GL_MAX");
        GlDebugTextUtils.func_209243_a((int)34962, (String)"GL15.GL_ARRAY_BUFFER");
        GlDebugTextUtils.func_209243_a((int)34963, (String)"GL15.GL_ELEMENT_ARRAY_BUFFER");
        GlDebugTextUtils.func_209243_a((int)34964, (String)"GL15.GL_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a((int)34965, (String)"GL15.GL_ELEMENT_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a((int)34966, (String)"GL15.GL_VERTEX_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a((int)34967, (String)"GL15.GL_NORMAL_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a((int)34968, (String)"GL15.GL_COLOR_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a((int)34969, (String)"GL15.GL_INDEX_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a((int)34970, (String)"GL15.GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a((int)34971, (String)"GL15.GL_EDGE_FLAG_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a((int)34972, (String)"GL15.GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a((int)34973, (String)"GL15.GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a((int)34974, (String)"GL15.GL_WEIGHT_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a((int)34975, (String)"GL15.GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a((int)35040, (String)"GL15.GL_STREAM_DRAW");
        GlDebugTextUtils.func_209243_a((int)35041, (String)"GL15.GL_STREAM_READ");
        GlDebugTextUtils.func_209243_a((int)35042, (String)"GL15.GL_STREAM_COPY");
        GlDebugTextUtils.func_209243_a((int)35044, (String)"GL15.GL_STATIC_DRAW");
        GlDebugTextUtils.func_209243_a((int)35045, (String)"GL15.GL_STATIC_READ");
        GlDebugTextUtils.func_209243_a((int)35046, (String)"GL15.GL_STATIC_COPY");
        GlDebugTextUtils.func_209243_a((int)35048, (String)"GL15.GL_DYNAMIC_DRAW");
        GlDebugTextUtils.func_209243_a((int)35049, (String)"GL15.GL_DYNAMIC_READ");
        GlDebugTextUtils.func_209243_a((int)35050, (String)"GL15.GL_DYNAMIC_COPY");
        GlDebugTextUtils.func_209243_a((int)35000, (String)"GL15.GL_READ_ONLY");
        GlDebugTextUtils.func_209243_a((int)35001, (String)"GL15.GL_WRITE_ONLY");
        GlDebugTextUtils.func_209243_a((int)35002, (String)"GL15.GL_READ_WRITE");
        GlDebugTextUtils.func_209243_a((int)34660, (String)"GL15.GL_BUFFER_SIZE");
        GlDebugTextUtils.func_209243_a((int)34661, (String)"GL15.GL_BUFFER_USAGE");
        GlDebugTextUtils.func_209243_a((int)35003, (String)"GL15.GL_BUFFER_ACCESS");
        GlDebugTextUtils.func_209243_a((int)35004, (String)"GL15.GL_BUFFER_MAPPED");
        GlDebugTextUtils.func_209243_a((int)35005, (String)"GL15.GL_BUFFER_MAP_POINTER");
        GlDebugTextUtils.func_209243_a((int)34138, (String)"NVFogDistance.GL_FOG_DISTANCE_MODE_NV");
        GlDebugTextUtils.func_209243_a((int)34139, (String)"NVFogDistance.GL_EYE_RADIAL_NV");
        GlDebugTextUtils.func_209243_a((int)34140, (String)"NVFogDistance.GL_EYE_PLANE_ABSOLUTE_NV");
    }
}

