/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.ReuseableStream;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.optifine.BlockPosM;

public abstract class Particle {
    private static final AxisAlignedBB field_187121_a = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    protected final ClientWorld field_187122_b;
    protected double field_187123_c;
    protected double field_187124_d;
    protected double field_187125_e;
    protected double field_187126_f;
    protected double field_187127_g;
    protected double field_187128_h;
    protected double field_187129_i;
    protected double field_187130_j;
    protected double field_187131_k;
    private AxisAlignedBB field_187120_G = field_187121_a;
    protected boolean field_187132_l;
    protected boolean field_190017_n = true;
    private boolean field_228343_B_;
    protected boolean field_187133_m;
    protected float field_187134_n = 0.6f;
    protected float field_187135_o = 1.8f;
    protected final Random field_187136_p = new Random();
    protected int field_70546_d;
    protected int field_70547_e;
    protected float field_70545_g;
    protected float field_70552_h = 1.0f;
    protected float field_70553_i = 1.0f;
    protected float field_70551_j = 1.0f;
    protected float field_82339_as = 1.0f;
    protected float field_190014_F;
    protected float field_190015_G;
    private BlockPosM blockPosM = new BlockPosM();

    protected Particle(ClientWorld worldIn, double posXIn, double posYIn, double posZIn) {
        this.field_187122_b = worldIn;
        this.func_187115_a(0.2f, 0.2f);
        this.func_187109_b(posXIn, posYIn, posZIn);
        this.field_187123_c = posXIn;
        this.field_187124_d = posYIn;
        this.field_187125_e = posZIn;
        this.field_70547_e = (int)(4.0f / (this.field_187136_p.nextFloat() * 0.9f + 0.1f));
    }

    public Particle(ClientWorld worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        this(worldIn, xCoordIn, yCoordIn, zCoordIn);
        this.field_187129_i = xSpeedIn + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        this.field_187130_j = ySpeedIn + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        this.field_187131_k = zSpeedIn + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        float f2 = (float)(Math.random() + Math.random() + 1.0) * 0.15f;
        float f1 = MathHelper.func_76133_a((double)(this.field_187129_i * this.field_187129_i + this.field_187130_j * this.field_187130_j + this.field_187131_k * this.field_187131_k));
        this.field_187129_i = this.field_187129_i / (double)f1 * (double)f2 * (double)0.4f;
        this.field_187130_j = this.field_187130_j / (double)f1 * (double)f2 * (double)0.4f + (double)0.1f;
        this.field_187131_k = this.field_187131_k / (double)f1 * (double)f2 * (double)0.4f;
    }

    public Particle func_70543_e(float multiplier) {
        this.field_187129_i *= (double)multiplier;
        this.field_187130_j = (this.field_187130_j - (double)0.1f) * (double)multiplier + (double)0.1f;
        this.field_187131_k *= (double)multiplier;
        return this;
    }

    public Particle func_70541_f(float scale) {
        this.func_187115_a(0.2f * scale, 0.2f * scale);
        return this;
    }

    public void func_70538_b(float particleRedIn, float particleGreenIn, float particleBlueIn) {
        this.field_70552_h = particleRedIn;
        this.field_70553_i = particleGreenIn;
        this.field_70551_j = particleBlueIn;
    }

    protected void func_82338_g(float alpha) {
        this.field_82339_as = alpha;
    }

    public void func_187114_a(int particleLifeTime) {
        this.field_70547_e = particleLifeTime;
    }

    public int func_206254_h() {
        return this.field_70547_e;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        } else {
            this.field_187130_j -= 0.04 * (double)this.field_70545_g;
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            this.field_187129_i *= (double)0.98f;
            this.field_187130_j *= (double)0.98f;
            this.field_187131_k *= (double)0.98f;
            if (this.field_187132_l) {
                this.field_187129_i *= (double)0.7f;
                this.field_187131_k *= (double)0.7f;
            }
        }
    }

    public abstract void func_225606_a_(IVertexBuilder var1, ActiveRenderInfo var2, float var3);

    public abstract IParticleRenderType func_217558_b();

    public String toString() {
        return this.getClass().getSimpleName() + ", Pos (" + this.field_187126_f + "," + this.field_187127_g + "," + this.field_187128_h + "), RGBA (" + this.field_70552_h + "," + this.field_70553_i + "," + this.field_70551_j + "," + this.field_82339_as + "), Age " + this.field_70546_d;
    }

    public void func_187112_i() {
        this.field_187133_m = true;
    }

    protected void func_187115_a(float particleWidth, float particleHeight) {
        if (particleWidth != this.field_187134_n || particleHeight != this.field_187135_o) {
            this.field_187134_n = particleWidth;
            this.field_187135_o = particleHeight;
            AxisAlignedBB axisalignedbb = this.func_187116_l();
            double d0 = (axisalignedbb.field_72340_a + axisalignedbb.field_72336_d - (double)particleWidth) / 2.0;
            double d1 = (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f - (double)particleWidth) / 2.0;
            this.func_187108_a(new AxisAlignedBB(d0, axisalignedbb.field_72338_b, d1, d0 + (double)this.field_187134_n, axisalignedbb.field_72338_b + (double)this.field_187135_o, d1 + (double)this.field_187134_n));
        }
    }

    public void func_187109_b(double x2, double y2, double z) {
        this.field_187126_f = x2;
        this.field_187127_g = y2;
        this.field_187128_h = z;
        float f2 = this.field_187134_n / 2.0f;
        float f1 = this.field_187135_o;
        this.func_187108_a(new AxisAlignedBB(x2 - (double)f2, y2, z - (double)f2, x2 + (double)f2, y2 + (double)f1, z + (double)f2));
    }

    public void func_187110_a(double x2, double y2, double z) {
        if (!this.field_228343_B_) {
            double d0 = x2;
            double d1 = y2;
            double d2 = z;
            if (this.field_190017_n && (x2 != 0.0 || y2 != 0.0 || z != 0.0) && this.hasNearBlocks(x2, y2, z)) {
                Vector3d vector3d = Entity.func_223307_a((Entity)null, (Vector3d)new Vector3d(x2, y2, z), (AxisAlignedBB)this.func_187116_l(), (World)this.field_187122_b, (ISelectionContext)ISelectionContext.func_216377_a(), (ReuseableStream)new ReuseableStream(Stream.empty()));
                x2 = vector3d.field_72450_a;
                y2 = vector3d.field_72448_b;
                z = vector3d.field_72449_c;
            }
            if (x2 != 0.0 || y2 != 0.0 || z != 0.0) {
                this.func_187108_a(this.func_187116_l().func_72317_d(x2, y2, z));
                this.func_187118_j();
            }
            if (Math.abs(d1) >= (double)1.0E-5f && Math.abs(y2) < (double)1.0E-5f) {
                this.field_228343_B_ = true;
            }
            boolean bl = this.field_187132_l = d1 != y2 && d1 < 0.0;
            if (d0 != x2) {
                this.field_187129_i = 0.0;
            }
            if (d2 != z) {
                this.field_187131_k = 0.0;
            }
        }
    }

    protected void func_187118_j() {
        AxisAlignedBB axisalignedbb = this.func_187116_l();
        this.field_187126_f = (axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0;
        this.field_187127_g = axisalignedbb.field_72338_b;
        this.field_187128_h = (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0;
    }

    protected int func_189214_a(float partialTick) {
        BlockPos blockpos = new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        return this.field_187122_b.func_175667_e(blockpos) ? WorldRenderer.func_228421_a_((IBlockDisplayReader)this.field_187122_b, (BlockPos)blockpos) : 0;
    }

    public boolean func_187113_k() {
        return !this.field_187133_m;
    }

    public AxisAlignedBB func_187116_l() {
        return this.field_187120_G;
    }

    public void func_187108_a(AxisAlignedBB bb) {
        this.field_187120_G = bb;
    }

    private boolean hasNearBlocks(double dx, double dy, double dz) {
        double posY2;
        double posX2;
        if (this.field_187134_n > 1.0f || this.field_187135_o > 1.0f) {
            return true;
        }
        int posXi = MathHelper.func_76128_c((double)this.field_187126_f);
        int posYi = MathHelper.func_76128_c((double)this.field_187127_g);
        int posZi = MathHelper.func_76128_c((double)this.field_187128_h);
        this.blockPosM.setXyz(posXi, posYi, posZi);
        BlockState bs = this.field_187122_b.func_180495_p((BlockPos)this.blockPosM);
        if (!bs.func_196958_f()) {
            return true;
        }
        double d2 = dx > 0.0 ? this.field_187120_G.field_72336_d : (posX2 = dx < 0.0 ? this.field_187120_G.field_72340_a : this.field_187126_f);
        double d3 = dy > 0.0 ? this.field_187120_G.field_72337_e : (posY2 = dy < 0.0 ? this.field_187120_G.field_72338_b : this.field_187127_g);
        double posZ2 = dz > 0.0 ? this.field_187120_G.field_72334_f : (dz < 0.0 ? this.field_187120_G.field_72339_c : this.field_187128_h);
        int posXi2 = MathHelper.func_76128_c((double)(posX2 + dx));
        int posYi2 = MathHelper.func_76128_c((double)(posY2 + dy));
        int posZi2 = MathHelper.func_76128_c((double)(posZ2 + dz));
        if (posXi2 != posXi || posYi2 != posYi || posZi2 != posZi) {
            this.blockPosM.setXyz(posXi2, posYi2, posZi2);
            BlockState bs2 = this.field_187122_b.func_180495_p((BlockPos)this.blockPosM);
            if (!bs2.func_196958_f()) {
                return true;
            }
        }
        return false;
    }

    public boolean shouldCull() {
        return true;
    }
}

