/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.scripting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import tschipp.carryon.common.helper.InvalidConfigException;

public class CarryOnOverride {
    private CompoundNBT typeBlockTag;
    private String typeNameBlock;
    private String typeMaterial;
    private String typeHardness;
    private String typeResistance;
    private CompoundNBT typeEntityTag;
    private String typeNameEntity;
    private String typeHeight;
    private String typeWidth;
    private String typeHealth;
    private String conditionGamestage;
    private String conditionAchievement;
    private String conditionXp;
    private String conditionGamemode;
    private String conditionScoreboard;
    private String conditionPosition;
    private String conditionEffects;
    private String renderNameBlock;
    private String renderNameEntity;
    private CompoundNBT renderNBT;
    private String renderTranslation;
    private String renderRotation;
    private String renderscaled;
    private String renderRotationLeftArm;
    private String renderRotationRightArm;
    private boolean renderLeftArm;
    private boolean renderRightArm;
    private String commandInit;
    private String commandLoop;
    private String commandPlace;
    private boolean isBlock;
    private boolean isEntity;
    private String resourceLocation;
    public boolean isInvalid;

    public CarryOnOverride(String path) {
        this.typeBlockTag = new CompoundNBT();
        this.typeNameBlock = "";
        this.typeMaterial = "";
        this.typeHardness = "";
        this.typeResistance = "";
        this.typeNameEntity = "";
        this.typeHeight = "";
        this.typeWidth = "";
        this.typeHealth = "";
        this.conditionGamestage = "";
        this.conditionAchievement = "";
        this.conditionXp = "";
        this.conditionGamemode = "";
        this.conditionScoreboard = "";
        this.conditionPosition = "";
        this.conditionEffects = "";
        this.renderNameBlock = "";
        this.renderNameEntity = "";
        this.renderNBT = new CompoundNBT();
        this.renderTranslation = "";
        this.renderRotation = "";
        this.renderscaled = "";
        this.renderRotationLeftArm = "";
        this.renderRotationRightArm = "";
        this.renderLeftArm = true;
        this.renderRightArm = true;
        this.commandInit = "";
        this.commandLoop = "";
        this.commandPlace = "";
        this.resourceLocation = "";
        this.isInvalid = false;
        this.resourceLocation = path;
    }

    public CarryOnOverride(JsonElement jsonElem, ResourceLocation loc) {
        block43: {
            this.typeBlockTag = new CompoundNBT();
            this.typeNameBlock = "";
            this.typeMaterial = "";
            this.typeHardness = "";
            this.typeResistance = "";
            this.typeNameEntity = "";
            this.typeHeight = "";
            this.typeWidth = "";
            this.typeHealth = "";
            this.conditionGamestage = "";
            this.conditionAchievement = "";
            this.conditionXp = "";
            this.conditionGamemode = "";
            this.conditionScoreboard = "";
            this.conditionPosition = "";
            this.conditionEffects = "";
            this.renderNameBlock = "";
            this.renderNameEntity = "";
            this.renderNBT = new CompoundNBT();
            this.renderTranslation = "";
            this.renderRotation = "";
            this.renderscaled = "";
            this.renderRotationLeftArm = "";
            this.renderRotationRightArm = "";
            this.renderLeftArm = true;
            this.renderRightArm = true;
            this.commandInit = "";
            this.commandLoop = "";
            this.commandPlace = "";
            this.resourceLocation = "";
            this.isInvalid = false;
            boolean errored = false;
            this.resourceLocation = loc.toString();
            if (jsonElem != null && jsonElem.isJsonObject()) {
                try {
                    JsonObject json = jsonElem.getAsJsonObject();
                    JsonObject object = (JsonObject)json.get("object");
                    JsonObject conditions = (JsonObject)json.get("conditions");
                    JsonObject render = (JsonObject)json.get("render");
                    JsonObject effects = (JsonObject)json.get("effects");
                    if (!(object != null && conditions != null || object != null && render != null) && (object == null || effects == null)) break block43;
                    JsonObject block = (JsonObject)object.get("block");
                    JsonObject entity = (JsonObject)object.get("entity");
                    if (block == null && entity == null || block != null && entity != null) {
                        errored = true;
                    }
                    if (!errored) {
                        JsonObject nbt;
                        JsonElement name;
                        if (block != null) {
                            this.setBlock(true);
                            name = block.get("name");
                            JsonElement material = block.get("material");
                            JsonElement hardness = block.get("hardness");
                            JsonElement resistance = block.get("resistance");
                            nbt = (JsonObject)block.get("nbt");
                            if (name != null) {
                                this.setTypeNameBlock(name.getAsString());
                            }
                            if (material != null) {
                                this.setTypeMaterial(material.getAsString());
                            }
                            if (hardness != null) {
                                this.setTypeHardness(hardness.getAsString());
                            }
                            if (resistance != null) {
                                this.setTypeResistance(resistance.getAsString());
                            }
                            if (nbt != null) {
                                this.setTypeBlockTag(JsonToNBT.func_180713_a((String)nbt.toString()));
                            }
                        } else {
                            this.setEntity(true);
                            name = entity.get("name");
                            JsonElement health = entity.get("health");
                            JsonElement height = entity.get("height");
                            JsonElement width = entity.get("width");
                            nbt = (JsonObject)entity.get("nbt");
                            if (name != null) {
                                this.setTypeNameEntity(name.getAsString());
                            }
                            if (health != null) {
                                this.setTypeHealth(health.getAsString());
                            }
                            if (height != null) {
                                this.setTypeHeight(height.getAsString());
                            }
                            if (width != null) {
                                this.setTypeWidth(width.getAsString());
                            }
                            if (nbt != null) {
                                this.setTypeEntityTag(JsonToNBT.func_180713_a((String)nbt.toString()));
                            }
                        }
                        if (conditions != null) {
                            JsonElement gamestage = conditions.get("gamestage");
                            JsonElement achievement = conditions.get("advancement");
                            JsonElement xp = conditions.get("xp");
                            JsonElement gamemode = conditions.get("gamemode");
                            JsonElement scoreboard = conditions.get("scoreboard");
                            JsonElement position = conditions.get("position");
                            JsonElement potionEffects = conditions.get("effects");
                            if (gamestage != null) {
                                this.setConditionGamestage(gamestage.getAsString());
                            }
                            if (achievement != null) {
                                this.setConditionAchievement(achievement.getAsString());
                            }
                            if (xp != null) {
                                this.setConditionXp(xp.getAsString());
                            }
                            if (gamemode != null) {
                                this.setConditionGamemode(gamemode.getAsString());
                            }
                            if (scoreboard != null) {
                                this.setConditionScoreboard(scoreboard.getAsString());
                            }
                            if (position != null) {
                                this.setConditionPosition(position.getAsString());
                            }
                            if (potionEffects != null) {
                                this.setConditionEffects(potionEffects.getAsString());
                            }
                        }
                        if (render != null) {
                            JsonElement name_block = render.get("name_block");
                            JsonElement name_entity = render.get("name_entity");
                            JsonObject nbt2 = (JsonObject)render.get("nbt");
                            JsonElement translation = render.get("translation");
                            JsonElement rotation = render.get("rotation");
                            JsonElement scaled = render.get("scale");
                            JsonElement rotationLeftArm = render.get("rotation_left_arm");
                            JsonElement rotationRightArm = render.get("rotation_right_arm");
                            JsonElement renderLeftArm = render.get("render_left_arm");
                            JsonElement renderRightArm = render.get("render_right_arm");
                            if (name_block != null) {
                                this.setRenderNameBlock(name_block.getAsString());
                            }
                            if (name_entity != null) {
                                this.setRenderNameEntity(name_entity.getAsString());
                            }
                            if (translation != null) {
                                this.setRenderTranslation(translation.getAsString());
                            }
                            if (rotation != null) {
                                this.setRenderRotation(rotation.getAsString());
                            }
                            if (scaled != null) {
                                this.setRenderscaled(scaled.getAsString());
                            }
                            if (nbt2 != null) {
                                this.setRenderNBT(JsonToNBT.func_180713_a((String)nbt2.toString()));
                            }
                            if (rotationLeftArm != null) {
                                this.setRenderRotationLeftArm(rotationLeftArm.getAsString());
                            }
                            if (rotationRightArm != null) {
                                this.setRenderRotationRightArm(rotationRightArm.getAsString());
                            }
                            if (renderLeftArm != null) {
                                this.setRenderLeftArm(renderLeftArm.getAsBoolean());
                            }
                            if (renderRightArm != null) {
                                this.setRenderRightArm(renderRightArm.getAsBoolean());
                            }
                        }
                        if (effects != null) {
                            JsonElement commandInit = effects.get("commandPickup");
                            JsonElement commandLoop = effects.get("commandLoop");
                            JsonElement commandPlace = effects.get("commandPlace");
                            if (commandInit != null) {
                                this.setCommandInit(commandInit.getAsString());
                            }
                            if (commandLoop != null) {
                                this.setCommandLoop(commandLoop.getAsString());
                            }
                            if (commandPlace != null) {
                                this.setCommandPlace(commandPlace.getAsString());
                            }
                        }
                        break block43;
                    }
                    this.isInvalid = true;
                }
                catch (Exception e) {
                    this.isInvalid = true;
                }
            } else {
                this.isInvalid = true;
            }
        }
        if (!this.isBlock && !this.isEntity) {
            this.isInvalid = true;
        }
        if (this.isInvalid) {
            new InvalidConfigException("The script parsing for " + this.resourceLocation + " has failed! Please double check!").printException();
        }
    }

    public String getCommandInit() {
        return this.commandInit;
    }

    public void setCommandInit(String commandInit) {
        this.commandInit = commandInit;
    }

    public String getCommandLoop() {
        return this.commandLoop;
    }

    public void setCommandLoop(String commandLoop) {
        this.commandLoop = commandLoop;
    }

    public String getConditionEffects() {
        return this.conditionEffects;
    }

    public void setConditionEffects(String conditionEffects) {
        this.conditionEffects = conditionEffects;
    }

    public String getRenderRotationLeftArm() {
        return this.renderRotationLeftArm;
    }

    public void setRenderRotationLeftArm(String renderRotationLeftArm) {
        this.renderRotationLeftArm = renderRotationLeftArm;
    }

    public String getRenderRotationRightArm() {
        return this.renderRotationRightArm;
    }

    public void setRenderRotationRightArm(String renderRotationRightArm) {
        this.renderRotationRightArm = renderRotationRightArm;
    }

    public boolean isRenderLeftArm() {
        return this.renderLeftArm;
    }

    public void setRenderLeftArm(boolean renderLeftArm) {
        this.renderLeftArm = renderLeftArm;
    }

    public boolean isRenderRightArm() {
        return this.renderRightArm;
    }

    public void setRenderRightArm(boolean renderRightArm) {
        this.renderRightArm = renderRightArm;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resourceLocation == null ? 0 : this.resourceLocation.hashCode());
        return result;
    }

    public String toString() {
        return "Code: " + this.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CarryOnOverride other = (CarryOnOverride)obj;
        if (this.commandInit == null ? other.commandInit != null : !this.commandInit.equals(other.commandInit)) {
            return false;
        }
        if (this.commandLoop == null ? other.commandLoop != null : !this.commandLoop.equals(other.commandLoop)) {
            return false;
        }
        if (this.commandPlace == null ? other.commandPlace != null : !this.commandPlace.equals(other.commandPlace)) {
            return false;
        }
        if (this.conditionAchievement == null ? other.conditionAchievement != null : !this.conditionAchievement.equals(other.conditionAchievement)) {
            return false;
        }
        if (this.conditionEffects == null ? other.conditionEffects != null : !this.conditionEffects.equals(other.conditionEffects)) {
            return false;
        }
        if (this.conditionGamemode == null ? other.conditionGamemode != null : !this.conditionGamemode.equals(other.conditionGamemode)) {
            return false;
        }
        if (this.conditionGamestage == null ? other.conditionGamestage != null : !this.conditionGamestage.equals(other.conditionGamestage)) {
            return false;
        }
        if (this.conditionPosition == null ? other.conditionPosition != null : !this.conditionPosition.equals(other.conditionPosition)) {
            return false;
        }
        if (this.conditionScoreboard == null ? other.conditionScoreboard != null : !this.conditionScoreboard.equals(other.conditionScoreboard)) {
            return false;
        }
        if (this.conditionXp == null ? other.conditionXp != null : !this.conditionXp.equals(other.conditionXp)) {
            return false;
        }
        if (this.isBlock != other.isBlock) {
            return false;
        }
        if (this.isEntity != other.isEntity) {
            return false;
        }
        if (this.resourceLocation == null ? other.resourceLocation != null : !this.resourceLocation.equals(other.resourceLocation)) {
            return false;
        }
        if (this.renderLeftArm != other.renderLeftArm) {
            return false;
        }
        if (this.renderNBT == null ? other.renderNBT != null : !this.renderNBT.equals((Object)other.renderNBT)) {
            return false;
        }
        if (this.renderNameBlock == null ? other.renderNameBlock != null : !this.renderNameBlock.equals(other.renderNameBlock)) {
            return false;
        }
        if (this.renderNameEntity == null ? other.renderNameEntity != null : !this.renderNameEntity.equals(other.renderNameEntity)) {
            return false;
        }
        if (this.renderRightArm != other.renderRightArm) {
            return false;
        }
        if (this.renderRotation == null ? other.renderRotation != null : !this.renderRotation.equals(other.renderRotation)) {
            return false;
        }
        if (this.renderRotationLeftArm == null ? other.renderRotationLeftArm != null : !this.renderRotationLeftArm.equals(other.renderRotationLeftArm)) {
            return false;
        }
        if (this.renderRotationRightArm == null ? other.renderRotationRightArm != null : !this.renderRotationRightArm.equals(other.renderRotationRightArm)) {
            return false;
        }
        if (this.renderscaled == null ? other.renderscaled != null : !this.renderscaled.equals(other.renderscaled)) {
            return false;
        }
        if (this.renderTranslation == null ? other.renderTranslation != null : !this.renderTranslation.equals(other.renderTranslation)) {
            return false;
        }
        if (this.typeBlockTag == null ? other.typeBlockTag != null : !this.typeBlockTag.equals((Object)other.typeBlockTag)) {
            return false;
        }
        if (this.typeEntityTag == null ? other.typeEntityTag != null : !this.typeEntityTag.equals((Object)other.typeEntityTag)) {
            return false;
        }
        if (this.typeHardness == null ? other.typeHardness != null : !this.typeHardness.equals(other.typeHardness)) {
            return false;
        }
        if (this.typeHealth == null ? other.typeHealth != null : !this.typeHealth.equals(other.typeHealth)) {
            return false;
        }
        if (this.typeHeight == null ? other.typeHeight != null : !this.typeHeight.equals(other.typeHeight)) {
            return false;
        }
        if (this.typeMaterial == null ? other.typeMaterial != null : !this.typeMaterial.equals(other.typeMaterial)) {
            return false;
        }
        if (this.typeNameBlock == null ? other.typeNameBlock != null : !this.typeNameBlock.equals(other.typeNameBlock)) {
            return false;
        }
        if (this.typeNameEntity == null ? other.typeNameEntity != null : !this.typeNameEntity.equals(other.typeNameEntity)) {
            return false;
        }
        if (this.typeResistance == null ? other.typeResistance != null : !this.typeResistance.equals(other.typeResistance)) {
            return false;
        }
        return !(this.typeWidth == null ? other.typeWidth != null : !this.typeWidth.equals(other.typeWidth));
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    public void setBlock(boolean isBlock) {
        this.isBlock = isBlock;
    }

    public boolean isEntity() {
        return this.isEntity;
    }

    public void setEntity(boolean isEntity) {
        this.isEntity = isEntity;
    }

    public CompoundNBT getTypeBlockTag() {
        return this.typeBlockTag;
    }

    public String getTypeNameBlock() {
        return this.typeNameBlock;
    }

    public String getTypeMaterial() {
        return this.typeMaterial;
    }

    public String getTypeHardness() {
        return this.typeHardness;
    }

    public String getTypeResistance() {
        return this.typeResistance;
    }

    public CompoundNBT getTypeEntityTag() {
        return this.typeEntityTag;
    }

    public String getTypeNameEntity() {
        return this.typeNameEntity;
    }

    public String getTypeHeight() {
        return this.typeHeight;
    }

    public String getTypeWidth() {
        return this.typeWidth;
    }

    public String getTypeHealth() {
        return this.typeHealth;
    }

    public String getConditionGamestage() {
        return this.conditionGamestage;
    }

    public String getConditionAchievement() {
        return this.conditionAchievement;
    }

    public String getConditionXp() {
        return this.conditionXp;
    }

    public String getConditionGamemode() {
        return this.conditionGamemode;
    }

    public String getConditionScoreboard() {
        return this.conditionScoreboard;
    }

    public String getConditionPosition() {
        return this.conditionPosition;
    }

    public String getRenderNameBlock() {
        return this.renderNameBlock;
    }

    public String getRenderNameEntity() {
        return this.renderNameEntity;
    }

    public CompoundNBT getRenderNBT() {
        return this.renderNBT;
    }

    public String getRenderTranslation() {
        return this.renderTranslation;
    }

    public String getRenderRotation() {
        return this.renderRotation;
    }

    public String getRenderScaled() {
        return this.renderscaled;
    }

    public void setTypeBlockTag(CompoundNBT typeBlockTag) {
        this.typeBlockTag = typeBlockTag;
    }

    public void setTypeNameBlock(String typeNameBlock) {
        this.typeNameBlock = typeNameBlock;
    }

    public void setTypeMaterial(String typeMaterial) {
        this.typeMaterial = typeMaterial;
    }

    public void setTypeHardness(String typeHardness) {
        this.typeHardness = typeHardness;
    }

    public void setTypeResistance(String typeResistance) {
        this.typeResistance = typeResistance;
    }

    public void setTypeEntityTag(CompoundNBT typeEntityTag) {
        this.typeEntityTag = typeEntityTag;
    }

    public void setTypeNameEntity(String typeNameEntity) {
        this.typeNameEntity = typeNameEntity;
    }

    public void setTypeHeight(String typeHeight) {
        this.typeHeight = typeHeight;
    }

    public void setTypeWidth(String typeWidth) {
        this.typeWidth = typeWidth;
    }

    public void setTypeHealth(String typeHealth) {
        this.typeHealth = typeHealth;
    }

    public void setConditionGamestage(String conditionGamestage) {
        this.conditionGamestage = conditionGamestage;
    }

    public void setConditionAchievement(String conditionAchievement) {
        this.conditionAchievement = conditionAchievement;
    }

    public void setConditionXp(String conditionXp) {
        this.conditionXp = conditionXp;
    }

    public void setConditionGamemode(String conditionGamemode) {
        this.conditionGamemode = conditionGamemode;
    }

    public void setConditionScoreboard(String conditionScoreboard) {
        this.conditionScoreboard = conditionScoreboard;
    }

    public void setConditionPosition(String conditionPosition) {
        this.conditionPosition = conditionPosition;
    }

    public void setRenderNameBlock(String renderNameBlock) {
        this.renderNameBlock = renderNameBlock;
    }

    public void setRenderNameEntity(String renderNameEntity) {
        this.renderNameEntity = renderNameEntity;
    }

    public void setRenderNBT(CompoundNBT renderNBT) {
        this.renderNBT = renderNBT;
    }

    public void setRenderTranslation(String renderTranslation) {
        this.renderTranslation = renderTranslation;
    }

    public void setRenderRotation(String renderRotation) {
        this.renderRotation = renderRotation;
    }

    public void setRenderscaled(String renderscaled) {
        this.renderscaled = renderscaled;
    }

    public String getCommandPlace() {
        return this.commandPlace;
    }

    public void setCommandPlace(String commandPlace) {
        this.commandPlace = commandPlace;
    }

    public void serialize(PacketBuffer buf) {
        buf.func_150786_a(this.typeBlockTag);
        buf.func_180714_a(this.typeNameBlock);
        buf.func_180714_a(this.typeMaterial);
        buf.func_180714_a(this.typeHardness);
        buf.func_180714_a(this.typeResistance);
        buf.func_150786_a(this.typeEntityTag);
        buf.func_180714_a(this.typeNameEntity);
        buf.func_180714_a(this.typeHeight);
        buf.func_180714_a(this.typeWidth);
        buf.func_180714_a(this.typeHealth);
        buf.func_180714_a(this.conditionGamestage);
        buf.func_180714_a(this.conditionAchievement);
        buf.func_180714_a(this.conditionXp);
        buf.func_180714_a(this.conditionGamemode);
        buf.func_180714_a(this.conditionScoreboard);
        buf.func_180714_a(this.conditionPosition);
        buf.func_180714_a(this.conditionEffects);
        buf.func_180714_a(this.renderNameBlock);
        buf.func_180714_a(this.renderNameEntity);
        buf.func_150786_a(this.renderNBT);
        buf.func_180714_a(this.renderTranslation);
        buf.func_180714_a(this.renderRotation);
        buf.func_180714_a(this.renderscaled);
        buf.func_180714_a(this.renderRotationLeftArm);
        buf.func_180714_a(this.renderRotationRightArm);
        buf.writeBoolean(this.renderLeftArm);
        buf.writeBoolean(this.renderRightArm);
        buf.func_180714_a(this.commandInit);
        buf.func_180714_a(this.commandLoop);
        buf.func_180714_a(this.commandPlace);
        buf.writeBoolean(this.isBlock);
        buf.writeBoolean(this.isEntity);
        buf.func_180714_a(this.resourceLocation);
    }

    public static CarryOnOverride deserialize(PacketBuffer buf) {
        CarryOnOverride override = new CarryOnOverride("");
        override.typeBlockTag = buf.func_150793_b();
        override.typeNameBlock = buf.func_218666_n();
        override.typeMaterial = buf.func_218666_n();
        override.typeHardness = buf.func_218666_n();
        override.typeResistance = buf.func_218666_n();
        override.typeEntityTag = buf.func_150793_b();
        override.typeNameEntity = buf.func_218666_n();
        override.typeHeight = buf.func_218666_n();
        override.typeWidth = buf.func_218666_n();
        override.typeHealth = buf.func_218666_n();
        override.conditionGamestage = buf.func_218666_n();
        override.conditionAchievement = buf.func_218666_n();
        override.conditionXp = buf.func_218666_n();
        override.conditionGamemode = buf.func_218666_n();
        override.conditionScoreboard = buf.func_218666_n();
        override.conditionPosition = buf.func_218666_n();
        override.conditionEffects = buf.func_218666_n();
        override.renderNameBlock = buf.func_218666_n();
        override.renderNameEntity = buf.func_218666_n();
        override.renderNBT = buf.func_150793_b();
        override.renderTranslation = buf.func_218666_n();
        override.renderRotation = buf.func_218666_n();
        override.renderscaled = buf.func_218666_n();
        override.renderRotationLeftArm = buf.func_218666_n();
        override.renderRotationRightArm = buf.func_218666_n();
        override.renderLeftArm = buf.readBoolean();
        override.renderRightArm = buf.readBoolean();
        override.commandInit = buf.func_218666_n();
        override.commandLoop = buf.func_218666_n();
        override.commandPlace = buf.func_218666_n();
        override.isBlock = buf.readBoolean();
        override.isEntity = buf.readBoolean();
        override.resourceLocation = buf.func_218666_n();
        return override;
    }
}

