/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.common.world.SimplexNoise;
import biomesoplenty.common.world.layer.traits.IBOPAreaTransformer0;
import biomesoplenty.common.world.layer.traits.IBOPContextExtended;

public enum RainfallNoiseLayer implements IBOPAreaTransformer0
{
    SMALL_ZONES(0.16),
    MEDIUM_ZONES(0.06),
    LARGE_ZONES(0.01);

    private final double scale;

    private RainfallNoiseLayer(double scale) {
        this.scale = scale;
    }

    @Override
    public int applyPixel(IBOPContextExtended context, int x, int z) {
        long seed = context.getWorldSeed();
        double noiseVal = SimplexNoise.noise(seed ^ 0xE157A1DC3B2A298CL, (double)x * this.scale + SimplexNoise.TRIANGLE_START_Y, (double)z * this.scale + SimplexNoise.TRIANGLE_START_X);
        if (noiseVal < -0.7804209166984755) {
            return 0;
        }
        if (noiseVal < -0.6263615214979332) {
            return 1;
        }
        if (noiseVal < -0.47131115810932966) {
            return 2;
        }
        if (noiseVal < -0.31471113670415907) {
            return 3;
        }
        if (noiseVal < -0.15717936237854807) {
            return 4;
        }
        if (noiseVal < 0.0) {
            return 5;
        }
        if (noiseVal < 0.15717936237854807) {
            return 6;
        }
        if (noiseVal < 0.31471113670415907) {
            return 7;
        }
        if (noiseVal < 0.47131115810932966) {
            return 8;
        }
        if (noiseVal < 0.6263615214979332) {
            return 9;
        }
        if (noiseVal < 0.7804209166984755) {
            return 10;
        }
        return 11;
    }
}

