/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.block.BOPBlocks;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class NetherCrystalBlock
extends HorizontalFaceBlock {
    protected static final VoxelShape FLOOR_AABB = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    protected static final VoxelShape CEILING_AABB = Block.func_208617_a((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape NORTH_AABB = Block.func_208617_a((double)2.0, (double)2.0, (double)3.0, (double)14.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)13.0);
    protected static final VoxelShape EAST_AABB = Block.func_208617_a((double)0.0, (double)2.0, (double)2.0, (double)13.0, (double)14.0, (double)14.0);
    protected static final VoxelShape WEST_AABB = Block.func_208617_a((double)3.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);

    public NetherCrystalBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_196366_M, (Comparable)AttachFace.FLOOR)).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH));
    }

    protected static boolean mayPlaceOn(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Block block = state.func_177230_c();
        return block == Blocks.field_150424_aL || block == Blocks.field_196766_fg || block == Blocks.field_235406_np_ || block == BOPBlocks.nether_crystal_block;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return NetherCrystalBlock.canAttach(worldIn, pos, NetherCrystalBlock.func_196365_i((BlockState)state).func_176734_d());
    }

    public static boolean canAttach(IWorldReader p_220185_0_, BlockPos p_220185_1_, Direction p_220185_2_) {
        BlockPos blockpos = p_220185_1_.func_177972_a(p_220185_2_);
        return NetherCrystalBlock.mayPlaceOn(p_220185_0_.func_180495_p(blockpos), (IBlockReader)p_220185_0_, blockpos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)field_185512_D);
        switch ((AttachFace)state.func_177229_b((Property)field_196366_M)) {
            case FLOOR: {
                return FLOOR_AABB;
            }
            case WALL: {
                switch (direction) {
                    case EAST: {
                        return EAST_AABB;
                    }
                    case WEST: {
                        return WEST_AABB;
                    }
                    case SOUTH: {
                        return SOUTH_AABB;
                    }
                }
                return NORTH_AABB;
            }
        }
        return CEILING_AABB;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return state.func_204520_s().func_206888_e();
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return type == PathType.AIR && !this.field_235688_at_ ? true : super.func_196266_a(state, worldIn, pos, type);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builderIn) {
        builderIn.func_206894_a(new Property[]{field_185512_D, field_196366_M});
    }
}

