/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome;

import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.common.biome.BiomeMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;

public class BiomeTemplate {
    private Map<BOPClimates, Integer> weightMap = new HashMap<BOPClimates, Integer>();
    private RegistryKey<Biome> beachBiome = Biomes.field_76787_r;
    private RegistryKey<Biome> riverBiome = Biomes.field_76781_i;
    private BiFunction<Double, Double, Integer> foliageColorFunction;
    private BiFunction<Double, Double, Integer> grassColorFunction;
    private BiFunction<Double, Double, Integer> waterColorFunction;

    protected void configureBiome(Biome.Builder builder) {
    }

    protected void configureGeneration(BiomeGenerationSettings.Builder builder) {
    }

    protected void configureMobSpawns(MobSpawnInfo.Builder builder) {
    }

    protected void configureDefaultMobSpawns(MobSpawnInfo.Builder builder) {
        builder.func_242571_a();
    }

    public final Biome build() {
        Biome.Builder biomeBuilder = new Biome.Builder();
        BiomeGenerationSettings.Builder biomeGenBuilder = new BiomeGenerationSettings.Builder();
        this.configureGeneration(biomeGenBuilder);
        biomeBuilder.func_242457_a(biomeGenBuilder.func_242508_a());
        MobSpawnInfo.Builder mobSpawnBuilder = new MobSpawnInfo.Builder();
        this.configureDefaultMobSpawns(mobSpawnBuilder);
        this.configureMobSpawns(mobSpawnBuilder);
        biomeBuilder.func_242458_a(mobSpawnBuilder.func_242577_b());
        this.configureBiome(biomeBuilder);
        return biomeBuilder.func_242455_a();
    }

    public final BiomeMetadata buildMetadata() {
        return new BiomeMetadata(this.weightMap, this.beachBiome, this.riverBiome, this.foliageColorFunction, this.grassColorFunction, this.waterColorFunction);
    }

    public void addWeight(BOPClimates climate, int weight) {
        this.weightMap.put(climate, weight);
    }

    public void setBeachBiome(RegistryKey<Biome> biome) {
        this.beachBiome = biome;
    }

    public void setRiverBiome(RegistryKey<Biome> biome) {
        this.riverBiome = biome;
    }

    public void setFoliageColorFunction(BiFunction<Double, Double, Integer> func) {
        this.foliageColorFunction = func;
    }

    public void setGrassColorFunction(BiFunction<Double, Double, Integer> func) {
        this.grassColorFunction = func;
    }

    public void setWaterColorFunction(BiFunction<Double, Double, Integer> func) {
        this.waterColorFunction = func;
    }

    public static int calculateSkyColor(float temperature) {
        float lvt_1_1_ = temperature / 3.0f;
        lvt_1_1_ = MathHelper.func_76131_a((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
    }
}

