/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.tileentity;

import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModTileEntityTypes;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.SettingsManager;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackTileContainer;
import com.tiviacz.travelersbackpack.inventory.sorter.SlotManager;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class TravelersBackpackTileEntity
extends TileEntity
implements ITravelersBackpackInventory,
INamedContainerProvider,
INameable,
ITickableTileEntity {
    private final ItemStackHandler inventory = this.createHandler(Tiers.LEATHER.getAllSlots(), true);
    private final ItemStackHandler craftingInventory = this.createHandler(9, false);
    private final ItemStackHandler fluidSlots = this.createTemporaryHandler();
    private final FluidTank leftTank = this.createFluidHandler(Tiers.LEATHER.getTankCapacity());
    private final FluidTank rightTank = this.createFluidHandler(Tiers.LEATHER.getTankCapacity());
    private PlayerEntity player = null;
    private boolean isSleepingBagDeployed = false;
    private int color = 0;
    private int sleepingBagColor = DyeColor.RED.func_196059_a();
    private Tiers.Tier tier = Tiers.LEATHER;
    private boolean ability = true;
    private int lastTime = 0;
    private ITextComponent customName = null;
    private final LazyOptional<IItemHandlerModifiable> inventoryCapability = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, this.tier.getStorageSlots()));
    private final LazyOptional<ItemStackHandler> craftingInventoryCapability = LazyOptional.of(() -> this.craftingInventory);
    private final LazyOptional<IFluidHandler> leftFluidTankCapability = LazyOptional.of(() -> this.leftTank);
    private final LazyOptional<IFluidHandler> rightFluidTankCapability = LazyOptional.of(() -> this.rightTank);
    private final SlotManager slotManager = new SlotManager(this);
    private final SettingsManager settingsManager = new SettingsManager(this);
    private final String INVENTORY = "Inventory";
    private final String CRAFTING_INVENTORY = "CraftingInventory";
    private final String LEFT_TANK = "LeftTank";
    private final String RIGHT_TANK = "RightTank";
    private final String SLEEPING_BAG = "SleepingBag";
    private final String COLOR = "Color";
    private final String SLEEPING_BAG_COLOR = "SleepingBagColor";
    private final String ABILITY = "Ability";
    private final String LAST_TIME = "LastTime";
    private final String CUSTOM_NAME = "CustomName";

    public TravelersBackpackTileEntity() {
        super((TileEntityType)ModTileEntityTypes.TRAVELERS_BACKPACK.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.saveAllData(compound);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.loadAllData(nbt);
    }

    @Override
    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public ItemStackHandler getCraftingGridInventory() {
        return this.craftingInventory;
    }

    @Override
    public ItemStackHandler getFluidSlotsInventory() {
        return this.fluidSlots;
    }

    @Override
    public IItemHandlerModifiable getCombinedInventory() {
        RangedWrapper additional = null;
        if (this.tier != Tiers.LEATHER) {
            additional = new RangedWrapper((IItemHandlerModifiable)this.getInventory(), 0, this.tier.getStorageSlots() - 18);
        }
        if (additional != null) {
            return new CombinedInvWrapper(new IItemHandlerModifiable[]{additional, new RangedWrapper((IItemHandlerModifiable)this.getInventory(), additional.getSlots(), additional.getSlots() + 6), new RangedWrapper((IItemHandlerModifiable)this.getCraftingGridInventory(), 0, 3), new RangedWrapper((IItemHandlerModifiable)this.getInventory(), additional.getSlots() + 6, additional.getSlots() + 12), new RangedWrapper((IItemHandlerModifiable)this.getCraftingGridInventory(), 3, 6), new RangedWrapper((IItemHandlerModifiable)this.getInventory(), additional.getSlots() + 12, additional.getSlots() + 18), new RangedWrapper((IItemHandlerModifiable)this.getCraftingGridInventory(), 6, 9)});
        }
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{new RangedWrapper((IItemHandlerModifiable)this.getInventory(), 0, 6), new RangedWrapper((IItemHandlerModifiable)this.getCraftingGridInventory(), 0, 3), new RangedWrapper((IItemHandlerModifiable)this.getInventory(), 6, 12), new RangedWrapper((IItemHandlerModifiable)this.getCraftingGridInventory(), 3, 6), new RangedWrapper((IItemHandlerModifiable)this.getInventory(), 12, 18), new RangedWrapper((IItemHandlerModifiable)this.getCraftingGridInventory(), 6, 9)});
    }

    @Override
    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    @Override
    public FluidTank getRightTank() {
        return this.rightTank;
    }

    public void saveTier(CompoundNBT compound) {
        compound.func_74768_a("Tier", this.tier.getOrdinal());
    }

    public void loadTier(CompoundNBT compound) {
        if (compound.func_150297_b("Tier", 8)) {
            Tiers.Tier tier = Tiers.of(compound.func_74779_i("Tier"));
            compound.func_82580_o("Tier");
            compound.func_74768_a("Tier", tier.getOrdinal());
        }
        this.tier = compound.func_74764_b("Tier") ? Tiers.of(compound.func_74762_e("Tier")) : (TravelersBackpackConfig.enableTierUpgrades ? Tiers.LEATHER : Tiers.DIAMOND);
    }

    @Override
    public void saveItems(CompoundNBT compound) {
        compound.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        compound.func_218657_a("CraftingInventory", (INBT)this.craftingInventory.serializeNBT());
    }

    @Override
    public void loadItems(CompoundNBT compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
        this.craftingInventory.deserializeNBT(compound.func_74775_l("CraftingInventory"));
    }

    @Override
    public void saveTanks(CompoundNBT compound) {
        compound.func_218657_a("LeftTank", (INBT)this.leftTank.writeToNBT(new CompoundNBT()));
        compound.func_218657_a("RightTank", (INBT)this.rightTank.writeToNBT(new CompoundNBT()));
    }

    @Override
    public void loadTanks(CompoundNBT compound) {
        this.leftTank.readFromNBT(compound.func_74775_l("LeftTank"));
        this.rightTank.readFromNBT(compound.func_74775_l("RightTank"));
    }

    @Override
    public void saveColor(CompoundNBT compound) {
        compound.func_74768_a("Color", this.color);
    }

    @Override
    public void loadColor(CompoundNBT compound) {
        this.color = compound.func_74762_e("Color");
    }

    @Override
    public void saveSleepingBagColor(CompoundNBT compound) {
        compound.func_74768_a("SleepingBagColor", this.sleepingBagColor);
    }

    @Override
    public void loadSleepingBagColor(CompoundNBT compound) {
        this.sleepingBagColor = compound.func_74764_b("SleepingBagColor") ? compound.func_74762_e("SleepingBagColor") : DyeColor.RED.func_196059_a();
    }

    @Override
    public void saveAbility(CompoundNBT compound) {
        compound.func_74757_a("Ability", this.ability);
    }

    @Override
    public void loadAbility(CompoundNBT compound) {
        this.ability = !compound.func_74764_b("Ability") && TravelersBackpackConfig.forceAbilityEnabled || compound.func_74767_n("Ability");
    }

    @Override
    public void saveTime(CompoundNBT compound) {
        compound.func_74768_a("LastTime", this.lastTime);
    }

    @Override
    public void loadTime(CompoundNBT compound) {
        this.lastTime = compound.func_74762_e("LastTime");
    }

    public void saveSleepingBag(CompoundNBT compound) {
        compound.func_74757_a("SleepingBag", this.isSleepingBagDeployed);
    }

    public void loadSleepingBag(CompoundNBT compound) {
        this.isSleepingBagDeployed = compound.func_74767_n("SleepingBag");
    }

    public void saveName(CompoundNBT compound) {
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
    }

    public void loadName(CompoundNBT compound) {
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
    }

    @Override
    public void saveAllData(CompoundNBT compound) {
        this.saveTier(compound);
        this.saveTanks(compound);
        this.saveItems(compound);
        this.saveSleepingBag(compound);
        this.saveColor(compound);
        this.saveSleepingBagColor(compound);
        this.saveAbility(compound);
        this.saveTime(compound);
        this.saveName(compound);
        this.slotManager.saveUnsortableSlots(compound);
        this.slotManager.saveMemorySlots(compound);
        this.settingsManager.saveSettings(compound);
    }

    @Override
    public void loadAllData(CompoundNBT compound) {
        this.loadTier(compound);
        this.loadTanks(compound);
        this.loadItems(compound);
        this.loadSleepingBag(compound);
        this.loadColor(compound);
        this.loadSleepingBagColor(compound);
        this.loadAbility(compound);
        this.loadTime(compound);
        this.loadName(compound);
        this.slotManager.loadUnsortableSlots(compound);
        this.slotManager.loadMemorySlots(compound);
        this.settingsManager.loadSettings(compound);
    }

    @Override
    public boolean updateTankSlots() {
        return InventoryActions.transferContainerTank(this, this.getLeftTank(), this.tier.getSlotIndex(Tiers.SlotType.BUCKET_IN_LEFT), this.player) || InventoryActions.transferContainerTank(this, this.getRightTank(), this.tier.getSlotIndex(Tiers.SlotType.BUCKET_IN_RIGHT), this.player);
    }

    @Override
    public boolean hasColor() {
        return this.color != 0;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public boolean hasSleepingBagColor() {
        return this.sleepingBagColor != DyeColor.RED.func_196059_a();
    }

    @Override
    public int getSleepingBagColor() {
        if (this.hasSleepingBagColor()) {
            return this.sleepingBagColor;
        }
        return DyeColor.RED.func_196059_a();
    }

    public void setSleepingBagColor(int colorId) {
        this.sleepingBagColor = colorId;
    }

    @Override
    public boolean getAbilityValue() {
        return TravelersBackpackConfig.enableBackpackAbilities ? (BackpackAbilities.ALLOWED_ABILITIES.contains(this.getItemStack().func_77973_b()) ? this.ability : false) : false;
    }

    @Override
    public void setAbility(boolean value) {
        this.ability = value;
        this.setDataChanged();
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int time) {
        this.lastTime = time;
    }

    @Override
    public boolean hasTileEntity() {
        return true;
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return this.isSleepingBagDeployed;
    }

    @Override
    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    @Override
    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    @Override
    public Tiers.Tier getTier() {
        return this.tier;
    }

    public void resetTier() {
        this.tier = Tiers.LEATHER;
        this.setDataChanged();
    }

    public World func_145831_w() {
        return super.func_145831_w();
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    @Override
    public byte getScreenID() {
        return 3;
    }

    @Override
    public ItemStack getItemStack() {
        Block block = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c();
        if (block instanceof TravelersBackpackBlock) {
            return new ItemStack((IItemProvider)block);
        }
        return new ItemStack((IItemProvider)ModBlocks.STANDARD_TRAVELERS_BACKPACK.get());
    }

    @Override
    public void setUsingPlayer(@Nullable PlayerEntity player) {
        this.player = player;
    }

    @Override
    public void setDataChanged(byte ... dataIds) {
    }

    @Override
    public void setDataChanged() {
        if (!this.field_145850_b.field_72995_K) {
            super.func_70296_d();
            this.notifyBlockUpdate();
        }
    }

    private void notifyBlockUpdate() {
        BlockState blockstate = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.field_145850_b.func_225319_b(this.func_174877_v(), blockstate, blockstate);
        this.field_145850_b.func_184138_a(this.func_174877_v(), blockstate, blockstate, 3);
    }

    public void setSleepingBagDeployed(boolean isSleepingBagDeployed) {
        this.isSleepingBagDeployed = isSleepingBagDeployed;
    }

    public boolean deploySleepingBag(World world, BlockPos pos) {
        BlockPos sleepingBagPos1;
        BlockPos sleepingBagPos2;
        Direction direction = this.getBlockDirection(world.func_175625_s(this.func_174877_v()));
        this.isThereSleepingBag(direction);
        if (!this.isSleepingBagDeployed && world.func_175623_d(sleepingBagPos2 = (sleepingBagPos1 = pos.func_177972_a(direction)).func_177972_a(direction)) && world.func_175623_d(sleepingBagPos1) && world.func_180495_p(sleepingBagPos1.func_177977_b()).func_224755_d((IBlockReader)world, sleepingBagPos1.func_177977_b(), Direction.UP) && world.func_180495_p(sleepingBagPos2.func_177977_b()).func_224755_d((IBlockReader)world, sleepingBagPos2.func_177977_b(), Direction.UP)) {
            world.func_184133_a(null, sleepingBagPos2, SoundEvents.field_187552_ah, SoundCategory.BLOCKS, 0.5f, 1.0f);
            if (!world.field_72995_K) {
                BlockState sleepingBagState = this.getProperSleepingBag(this.getSleepingBagColor());
                this.field_145850_b.func_180501_a(sleepingBagPos1, (BlockState)((BlockState)((BlockState)sleepingBagState.func_206870_a((Property)SleepingBagBlock.field_185512_D, (Comparable)direction)).func_206870_a(SleepingBagBlock.PART, (Comparable)BedPart.FOOT)).func_206870_a((Property)SleepingBagBlock.CAN_DROP, (Comparable)Boolean.valueOf(false)), 3);
                this.field_145850_b.func_180501_a(sleepingBagPos2, (BlockState)((BlockState)((BlockState)sleepingBagState.func_206870_a((Property)SleepingBagBlock.field_185512_D, (Comparable)direction)).func_206870_a(SleepingBagBlock.PART, (Comparable)BedPart.HEAD)).func_206870_a((Property)SleepingBagBlock.CAN_DROP, (Comparable)Boolean.valueOf(false)), 3);
                world.func_195593_d(pos, sleepingBagState.func_177230_c());
                world.func_195593_d(sleepingBagPos2, sleepingBagState.func_177230_c());
            }
            this.isSleepingBagDeployed = true;
            this.setDataChanged();
            return true;
        }
        return false;
    }

    public boolean removeSleepingBag(World world) {
        Direction blockFacing = this.getBlockDirection(world.func_175625_s(this.func_174877_v()));
        this.isThereSleepingBag(blockFacing);
        if (this.isSleepingBagDeployed) {
            BlockPos sleepingBagPos1 = this.func_174877_v().func_177972_a(blockFacing);
            BlockPos sleepingBagPos2 = sleepingBagPos1.func_177972_a(blockFacing);
            if (world.func_180495_p(sleepingBagPos1).func_177230_c() instanceof SleepingBagBlock && world.func_180495_p(sleepingBagPos2).func_177230_c() instanceof SleepingBagBlock) {
                world.func_184133_a(null, sleepingBagPos2, SoundEvents.field_187552_ah, SoundCategory.BLOCKS, 0.5f, 1.0f);
                world.func_175656_a(sleepingBagPos2, Blocks.field_150350_a.func_176223_P());
                world.func_175656_a(sleepingBagPos1, Blocks.field_150350_a.func_176223_P());
                this.isSleepingBagDeployed = false;
                this.setDataChanged();
                return true;
            }
        } else {
            this.isSleepingBagDeployed = false;
            this.setDataChanged();
            return true;
        }
        return false;
    }

    public boolean isThereSleepingBag(Direction direction) {
        if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177972_a(direction)).func_177230_c() instanceof SleepingBagBlock && this.field_145850_b.func_180495_p(this.func_174877_v().func_177972_a(direction).func_177972_a(direction)).func_177230_c() instanceof SleepingBagBlock) {
            return true;
        }
        this.isSleepingBagDeployed = false;
        return false;
    }

    public BlockState getProperSleepingBag(int colorId) {
        switch (colorId) {
            case 0: {
                return ((Block)ModBlocks.WHITE_SLEEPING_BAG.get()).func_176223_P();
            }
            case 1: {
                return ((Block)ModBlocks.ORANGE_SLEEPING_BAG.get()).func_176223_P();
            }
            case 2: {
                return ((Block)ModBlocks.MAGENTA_SLEEPING_BAG.get()).func_176223_P();
            }
            case 3: {
                return ((Block)ModBlocks.LIGHT_BLUE_SLEEPING_BAG.get()).func_176223_P();
            }
            case 4: {
                return ((Block)ModBlocks.YELLOW_SLEEPING_BAG.get()).func_176223_P();
            }
            case 5: {
                return ((Block)ModBlocks.LIME_SLEEPING_BAG.get()).func_176223_P();
            }
            case 6: {
                return ((Block)ModBlocks.PINK_SLEEPING_BAG.get()).func_176223_P();
            }
            case 7: {
                return ((Block)ModBlocks.GRAY_SLEEPING_BAG.get()).func_176223_P();
            }
            case 8: {
                return ((Block)ModBlocks.LIGHT_GRAY_SLEEPING_BAG.get()).func_176223_P();
            }
            case 9: {
                return ((Block)ModBlocks.CYAN_SLEEPING_BAG.get()).func_176223_P();
            }
            case 10: {
                return ((Block)ModBlocks.PURPLE_SLEEPING_BAG.get()).func_176223_P();
            }
            case 11: {
                return ((Block)ModBlocks.BLUE_SLEEPING_BAG.get()).func_176223_P();
            }
            case 12: {
                return ((Block)ModBlocks.BROWN_SLEEPING_BAG.get()).func_176223_P();
            }
            case 13: {
                return ((Block)ModBlocks.GREEN_SLEEPING_BAG.get()).func_176223_P();
            }
            case 14: {
                return ((Block)ModBlocks.RED_SLEEPING_BAG.get()).func_176223_P();
            }
            case 15: {
                return ((Block)ModBlocks.BLACK_SLEEPING_BAG.get()).func_176223_P();
            }
        }
        return ((Block)ModBlocks.RED_SLEEPING_BAG.get()).func_176223_P();
    }

    public boolean isUsableByPlayer(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.func_174877_v()) != this) {
            return false;
        }
        return player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public Direction getBlockDirection(TileEntity tile) {
        if (tile instanceof TravelersBackpackTileEntity) {
            if (this.field_145850_b == null || !(this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() instanceof TravelersBackpackBlock)) {
                return Direction.NORTH;
            }
            return (Direction)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((Property)TravelersBackpackBlock.FACING);
        }
        return Direction.NORTH;
    }

    public boolean hasData() {
        boolean isDefaultTier = this.getTier() == Tiers.LEATHER;
        boolean isInvEmpty = ItemStackUtils.isEmpty(this.getInventory());
        boolean isCraftingGridEmpty = ItemStackUtils.isEmpty(this.getCraftingGridInventory());
        boolean leftTankEmpty = this.getLeftTank().isEmpty();
        boolean rightTankEmpty = this.getRightTank().isEmpty();
        boolean hasColor = this.hasColor();
        boolean hasSleepingBagColor = this.hasSleepingBagColor();
        boolean hasTime = this.getLastTime() != 0;
        boolean hasUnsortableSlots = !this.slotManager.getUnsortableSlots().isEmpty();
        boolean hasMemorySlots = !this.slotManager.getMemorySlots().isEmpty();
        boolean hasCustomName = this.func_145818_k_();
        return !isDefaultTier || !isInvEmpty || !isCraftingGridEmpty || !leftTankEmpty || !rightTankEmpty || hasColor || hasSleepingBagColor || hasTime || hasUnsortableSlots || hasMemorySlots || hasCustomName;
    }

    public ItemStack transferToItemStack(ItemStack stack) {
        CompoundNBT compound = new CompoundNBT();
        this.saveTier(compound);
        this.saveTanks(compound);
        this.saveItems(compound);
        if (this.hasColor()) {
            this.saveColor(compound);
        }
        if (this.hasSleepingBagColor()) {
            this.saveSleepingBagColor(compound);
        }
        this.saveAbility(compound);
        this.saveTime(compound);
        this.slotManager.saveUnsortableSlots(compound);
        this.slotManager.saveMemorySlots(compound);
        this.settingsManager.saveSettings(compound);
        stack.func_77982_d(compound);
        if (this.func_145818_k_()) {
            stack.func_200302_a(this.func_200201_e());
        }
        return stack;
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    public ITextComponent getDefaultName() {
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a());
    }

    public void setCustomName(ITextComponent customName) {
        this.customName = customName;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 3, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void func_73660_a() {
        if (this.getAbilityValue() && BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.getItemStack())) {
            if (this.getLastTime() > 0) {
                this.setLastTime(this.getLastTime() - 1);
                this.setDataChanged();
            }
            BackpackAbilities.ABILITIES.abilityTick(null, null, this);
        }
    }

    public void openGUI(PlayerEntity player, INamedContainerProvider containerSupplier, BlockPos pos) {
        if (!player.field_70170_p.field_72995_K && this.player == null) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)containerSupplier, (BlockPos)pos);
        }
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity playerEntity) {
        return new TravelersBackpackTileContainer(id, inventory, this);
    }

    private ItemStackHandler createHandler(int size, final boolean isInventory) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                TravelersBackpackTileEntity.this.setDataChanged();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                ResourceLocation blacklistedItems = new ResourceLocation("travelersbackpack", "blacklisted_items");
                return !(stack.func_77973_b() instanceof TravelersBackpackItem) && !stack.func_77973_b().func_206844_a(ItemTags.func_199903_a().func_199910_a(blacklistedItems));
            }

            public void deserializeNBT(CompoundNBT nbt) {
                if (isInventory) {
                    if (TravelersBackpackTileEntity.this.getTier() == Tiers.LEATHER) {
                        int size;
                        int n = size = nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.stacks.size();
                        if (size == 45) {
                            TravelersBackpackTileEntity.this.tier = Tiers.DIAMOND;
                        }
                    }
                    this.setSize(TravelersBackpackTileEntity.this.tier.getAllSlots());
                    ListNBT tagList = nbt.func_150295_c("Items", 10);
                    for (int i = 0; i < tagList.size(); ++i) {
                        CompoundNBT itemTags = tagList.func_150305_b(i);
                        int slot = itemTags.func_74762_e("Slot");
                        if (slot < 0 || slot >= this.stacks.size()) continue;
                        this.stacks.set(slot, (Object)ItemStack.func_199557_a((CompoundNBT)itemTags));
                    }
                    this.onLoad();
                } else {
                    super.deserializeNBT(nbt);
                }
            }
        };
    }

    private FluidTank createFluidHandler(int capacity) {
        return new FluidTank(capacity){

            protected void onContentsChanged() {
                TravelersBackpackTileEntity.this.setDataChanged();
            }

            public FluidTank readFromNBT(CompoundNBT nbt) {
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt);
                this.setCapacity(TravelersBackpackTileEntity.this.tier.getTankCapacity());
                this.setFluid(fluid);
                return this;
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        Direction direction = this.getBlockDirection(this.getTileEntity());
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.inventoryCapability.cast();
            }
            switch (side) {
                case DOWN: 
                case UP: {
                    return this.inventoryCapability.cast();
                }
                case NORTH: 
                case SOUTH: 
                case WEST: 
                case EAST: {
                    if (side != direction && side != direction.func_176734_d()) break;
                    return this.craftingInventoryCapability.cast();
                }
            }
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.leftFluidTankCapability.cast();
            }
            if (direction == Direction.NORTH) {
                switch (side) {
                    case WEST: {
                        return this.rightFluidTankCapability.cast();
                    }
                    case EAST: {
                        return this.leftFluidTankCapability.cast();
                    }
                }
            }
            if (direction == Direction.SOUTH) {
                switch (side) {
                    case EAST: {
                        return this.rightFluidTankCapability.cast();
                    }
                    case WEST: {
                        return this.leftFluidTankCapability.cast();
                    }
                }
            }
            if (direction == Direction.EAST) {
                switch (side) {
                    case NORTH: {
                        return this.rightFluidTankCapability.cast();
                    }
                    case SOUTH: {
                        return this.leftFluidTankCapability.cast();
                    }
                }
            }
            if (direction == Direction.WEST) {
                switch (side) {
                    case SOUTH: {
                        return this.rightFluidTankCapability.cast();
                    }
                    case NORTH: {
                        return this.leftFluidTankCapability.cast();
                    }
                }
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryCapability.invalidate();
        this.craftingInventoryCapability.invalidate();
        this.leftFluidTankCapability.invalidate();
        this.rightFluidTankCapability.invalidate();
    }
}

