/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SSpecialActionPacket {
    private final byte screenID;
    private final byte typeOfAction;
    private final double scrollDelta;

    public SSpecialActionPacket(byte screenID, byte typeOfAction, double scrollDelta) {
        this.screenID = screenID;
        this.typeOfAction = typeOfAction;
        this.scrollDelta = scrollDelta;
    }

    public static SSpecialActionPacket decode(PacketBuffer buffer) {
        byte screenID = buffer.readByte();
        byte typeOfAction = buffer.readByte();
        double scrollDelta = buffer.readDouble();
        return new SSpecialActionPacket(screenID, typeOfAction, scrollDelta);
    }

    public static void encode(SSpecialActionPacket message, PacketBuffer buffer) {
        buffer.writeByte((int)message.screenID);
        buffer.writeByte((int)message.typeOfAction);
        buffer.writeDouble(message.scrollDelta);
    }

    public static void handle(SSpecialActionPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity serverPlayerEntity = ((NetworkEvent.Context)ctx.get()).getSender();
            if (serverPlayerEntity != null) {
                if (message.typeOfAction == 0) {
                    ServerActions.swapTool((PlayerEntity)serverPlayerEntity, message.scrollDelta);
                } else if (message.typeOfAction == 1) {
                    ServerActions.switchHoseMode((PlayerEntity)serverPlayerEntity, message.scrollDelta);
                } else if (message.typeOfAction == 2) {
                    ServerActions.toggleHoseTank((PlayerEntity)serverPlayerEntity);
                } else if (message.typeOfAction == 3) {
                    ServerActions.emptyTank(message.scrollDelta, (PlayerEntity)serverPlayerEntity, serverPlayerEntity.field_70170_p, message.screenID);
                } else if (message.typeOfAction == 4 && CapabilityUtils.isWearingBackpack((PlayerEntity)serverPlayerEntity)) {
                    TravelersBackpackInventory.openGUI(serverPlayerEntity, CapabilityUtils.getWearingBackpack((PlayerEntity)serverPlayerEntity), (byte)2);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

