/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackItemContainer;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackTileContainer;
import com.tiviacz.travelersbackpack.inventory.sorter.SlotManager;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SSlotPacket {
    private final byte screenID;
    private final boolean isActive;
    private final int[] selectedSlots;

    public SSlotPacket(byte screenID, boolean isActive, int[] selectedSlots) {
        this.screenID = screenID;
        this.isActive = isActive;
        this.selectedSlots = selectedSlots;
    }

    public static SSlotPacket decode(PacketBuffer buffer) {
        byte screenID = buffer.readByte();
        boolean isActive = buffer.readBoolean();
        int[] selectedSlots = buffer.func_186863_b();
        return new SSlotPacket(screenID, isActive, selectedSlots);
    }

    public static void encode(SSlotPacket message, PacketBuffer buffer) {
        buffer.writeByte((int)message.screenID);
        buffer.writeBoolean(message.isActive);
        buffer.func_186875_a(message.selectedSlots);
    }

    public static void handle(SSlotPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity serverPlayerEntity = ((NetworkEvent.Context)ctx.get()).getSender();
            if (serverPlayerEntity != null) {
                SlotManager manager;
                if (message.screenID == 2) {
                    manager = CapabilityUtils.getBackpackInv((PlayerEntity)serverPlayerEntity).getSlotManager();
                    manager.setSelectorActive((byte)0, message.isActive);
                    manager.setUnsortableSlots(message.selectedSlots, true);
                    manager.setSelectorActive((byte)0, !message.isActive);
                }
                if (message.screenID == 1) {
                    manager = ((TravelersBackpackItemContainer)serverPlayerEntity.field_71070_bA).inventory.getSlotManager();
                    manager.setSelectorActive((byte)0, message.isActive);
                    manager.setUnsortableSlots(message.selectedSlots, true);
                    manager.setSelectorActive((byte)0, !message.isActive);
                }
                if (message.screenID == 3) {
                    manager = ((TravelersBackpackTileContainer)serverPlayerEntity.field_71070_bA).inventory.getSlotManager();
                    manager.setSelectorActive((byte)0, message.isActive);
                    manager.setUnsortableSlots(message.selectedSlots, true);
                    manager.setSelectorActive((byte)0, !message.isActive);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

