/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.inventory.SettingsManager;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackItemContainer;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackTileContainer;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SSettingsPacket {
    private final byte screenID;
    private final byte dataArray;
    private final int place;
    private final byte value;

    public SSettingsPacket(byte screenID, byte dataArray, int place, byte value) {
        this.screenID = screenID;
        this.dataArray = dataArray;
        this.place = place;
        this.value = value;
    }

    public static SSettingsPacket decode(PacketBuffer buffer) {
        byte screenID = buffer.readByte();
        byte dataArray = buffer.readByte();
        int place = buffer.readInt();
        byte value = buffer.readByte();
        return new SSettingsPacket(screenID, dataArray, place, value);
    }

    public static void encode(SSettingsPacket message, PacketBuffer buffer) {
        buffer.writeByte((int)message.screenID);
        buffer.writeByte((int)message.dataArray);
        buffer.writeInt(message.place);
        buffer.writeByte((int)message.value);
    }

    public static void handle(SSettingsPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity serverPlayerEntity = ((NetworkEvent.Context)ctx.get()).getSender();
            if (serverPlayerEntity != null) {
                SettingsManager manager;
                if (message.screenID == 2) {
                    manager = CapabilityUtils.getBackpackInv((PlayerEntity)serverPlayerEntity).getSettingsManager();
                    manager.set(message.dataArray, message.place, message.value);
                }
                if (message.screenID == 1) {
                    manager = ((TravelersBackpackItemContainer)serverPlayerEntity.field_71070_bA).inventory.getSettingsManager();
                    manager.set(message.dataArray, message.place, message.value);
                }
                if (message.screenID == 3) {
                    manager = ((TravelersBackpackTileContainer)serverPlayerEntity.field_71070_bA).inventory.getSettingsManager();
                    manager.set(message.dataArray, message.place, message.value);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

