/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackItemContainer;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackTileContainer;
import com.tiviacz.travelersbackpack.inventory.sorter.SlotManager;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SMemoryPacket {
    private final byte screenID;
    private final boolean isActive;
    private final int[] selectedSlots;
    private final ItemStack[] stacks;

    public SMemoryPacket(byte screenID, boolean isActive, int[] selectedSlots, ItemStack[] stacks) {
        this.screenID = screenID;
        this.isActive = isActive;
        this.selectedSlots = selectedSlots;
        this.stacks = stacks;
    }

    public static SMemoryPacket decode(PacketBuffer buffer) {
        byte screenID = buffer.readByte();
        boolean isActive = buffer.readBoolean();
        int[] selectedSlots = buffer.func_186863_b();
        ItemStack[] stacks = new ItemStack[selectedSlots.length];
        for (int i = 0; i < selectedSlots.length; ++i) {
            stacks[i] = buffer.func_150791_c();
        }
        return new SMemoryPacket(screenID, isActive, selectedSlots, stacks);
    }

    public static void encode(SMemoryPacket message, PacketBuffer buffer) {
        buffer.writeByte((int)message.screenID);
        buffer.writeBoolean(message.isActive);
        buffer.func_186875_a(message.selectedSlots);
        for (int i = 0; i < message.selectedSlots.length; ++i) {
            buffer.func_150788_a(message.stacks[i]);
        }
    }

    public static void handle(SMemoryPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            if (serverPlayer != null) {
                SlotManager manager;
                if (message.screenID == 2) {
                    manager = CapabilityUtils.getBackpackInv((PlayerEntity)serverPlayer).getSlotManager();
                    manager.setSelectorActive((byte)1, message.isActive);
                    manager.setMemorySlots(message.selectedSlots, message.stacks, true);
                    manager.setSelectorActive((byte)1, !message.isActive);
                }
                if (message.screenID == 1) {
                    manager = ((TravelersBackpackItemContainer)serverPlayer.field_71070_bA).inventory.getSlotManager();
                    manager.setSelectorActive((byte)1, message.isActive);
                    manager.setMemorySlots(message.selectedSlots, message.stacks, true);
                    manager.setSelectorActive((byte)1, !message.isActive);
                }
                if (message.screenID == 3) {
                    manager = ((TravelersBackpackTileContainer)serverPlayer.field_71070_bA).inventory.getSlotManager();
                    manager.setSelectorActive((byte)1, message.isActive);
                    manager.setMemorySlots(message.selectedSlots, message.stacks, true);
                    manager.setSelectorActive((byte)1, !message.isActive);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

