/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackTileContainer;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SAbilitySliderPacket {
    private final byte screenID;
    private final boolean sliderValue;

    public SAbilitySliderPacket(byte screenID, boolean sliderValue) {
        this.screenID = screenID;
        this.sliderValue = sliderValue;
    }

    public static SAbilitySliderPacket decode(PacketBuffer buffer) {
        byte screenID = buffer.readByte();
        boolean sliderValue = buffer.readBoolean();
        return new SAbilitySliderPacket(screenID, sliderValue);
    }

    public static void encode(SAbilitySliderPacket message, PacketBuffer buffer) {
        buffer.writeByte((int)message.screenID);
        buffer.writeBoolean(message.sliderValue);
    }

    public static void handle(SAbilitySliderPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity serverPlayerEntity = ((NetworkEvent.Context)ctx.get()).getSender();
            if (serverPlayerEntity != null) {
                if (message.screenID == 2 && CapabilityUtils.isWearingBackpack((PlayerEntity)serverPlayerEntity)) {
                    ServerActions.switchAbilitySlider((PlayerEntity)serverPlayerEntity, message.sliderValue);
                } else if (message.screenID == 3 && serverPlayerEntity.field_71070_bA instanceof TravelersBackpackTileContainer) {
                    ServerActions.switchAbilitySliderTileEntity((PlayerEntity)serverPlayerEntity, ((TravelersBackpackTileContainer)serverPlayerEntity.field_71070_bA).inventory.getPosition(), message.sliderValue);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

