/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CSyncCapabilityPacket {
    private final int entityID;
    private final boolean isPlayer;
    private final CompoundNBT compound;

    public CSyncCapabilityPacket(int entityID, boolean isPlayer, CompoundNBT compound) {
        this.entityID = entityID;
        this.isPlayer = isPlayer;
        this.compound = compound;
    }

    public static CSyncCapabilityPacket decode(PacketBuffer buffer) {
        int entityID = buffer.readInt();
        boolean isPlayer = buffer.readBoolean();
        CompoundNBT compound = buffer.func_150793_b();
        return new CSyncCapabilityPacket(entityID, isPlayer, compound);
    }

    public static void encode(CSyncCapabilityPacket message, PacketBuffer buffer) {
        buffer.writeInt(message.entityID);
        buffer.writeBoolean(message.isPlayer);
        buffer.func_150786_a(message.compound);
    }

    public static void handle(CSyncCapabilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft minecraft = Minecraft.func_71410_x();
            if (message.isPlayer) {
                PlayerEntity playerEntity = (PlayerEntity)minecraft.field_71441_e.func_73045_a(message.entityID);
                CapabilityUtils.getCapability(playerEntity).ifPresent(cap -> {
                    cap.setWearable(ItemStack.func_199557_a((CompoundNBT)message.compound));
                    cap.setContents(ItemStack.func_199557_a((CompoundNBT)message.compound));
                });
            } else {
                LivingEntity livingEntity = (LivingEntity)minecraft.field_71441_e.func_73045_a(message.entityID);
                CapabilityUtils.getEntityCapability(livingEntity).ifPresent(cap -> cap.setWearable(ItemStack.func_199557_a((CompoundNBT)message.compound)));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

