/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TierUpgradeItem
extends Item {
    private final Tiers.Tier tier;

    public TierUpgradeItem(Item.Properties properties, Tiers.Tier tier) {
        super(properties);
        this.tier = tier;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (TravelersBackpackConfig.enableTierUpgrades) {
            if (this != ModItems.BLANK_UPGRADE.get()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.travelersbackpack.tier_upgrade_tooltip", new Object[]{this.tier.getName()}).func_240699_a_(TextFormatting.BLUE));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.travelersbackpack.blank_upgrade_tooltip").func_240699_a_(TextFormatting.BLUE));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.travelersbackpack.tier_upgrade_disabled"));
        }
    }

    public static NonNullList<ItemStack> getUpgradesForTier(Tiers.Tier tier) {
        NonNullList list = NonNullList.func_191196_a();
        if (tier.getOrdinal() >= 1) {
            list.add((Object)((Item)ModItems.IRON_TIER_UPGRADE.get()).func_190903_i());
            if (tier.getOrdinal() >= 2) {
                list.add((Object)((Item)ModItems.GOLD_TIER_UPGRADE.get()).func_190903_i());
                if (tier.getOrdinal() >= 3) {
                    list.add((Object)((Item)ModItems.DIAMOND_TIER_UPGRADE.get()).func_190903_i());
                    if (tier.getOrdinal() >= 4) {
                        list.add((Object)((Item)ModItems.NETHERITE_TIER_UPGRADE.get()).func_190903_i());
                    }
                }
            }
        }
        return list;
    }
}

