/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.sorter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class SortType {
    static String getStringForSort(ItemStack stack, Type type) {
        Item item = stack.func_77973_b();
        String itemName = SortType.specialCases(stack);
        ItemGroup group = item.func_77640_w();
        return (group != null ? SortType.getGroupID(group) : "999") + Registry.field_212630_s.func_148757_b((Object)item) + itemName;
    }

    public static String getGroupID(ItemGroup group) {
        for (int i = 0; i < ItemGroup.field_78032_a.length; ++i) {
            List list = Arrays.stream(ItemGroup.field_78032_a).collect(Collectors.toList());
            if (list.get(i) != group) continue;
            if (i < 10) {
                return "00" + i;
            }
            if (i >= 100) continue;
            return "0" + i;
        }
        return "999";
    }

    private static String specialCases(ItemStack stack) {
        Item item = stack.func_77973_b();
        CompoundNBT tag = stack.func_77978_p();
        if (stack.func_190916_E() != stack.func_77976_d()) {
            return SortType.stackSize(stack);
        }
        if (item instanceof EnchantedBookItem) {
            return SortType.enchantedBookNameCase(stack);
        }
        if (item instanceof ToolItem) {
            return SortType.toolDuribilityCase(stack);
        }
        return item.func_77667_c(stack);
    }

    private static String stackSize(ItemStack stack) {
        return stack.func_77973_b().toString() + stack.func_190916_E();
    }

    private static String enchantedBookNameCase(ItemStack stack) {
        ListNBT enchants = EnchantedBookItem.func_92110_g((ItemStack)stack);
        ArrayList<String> names = new ArrayList<String>();
        StringBuilder enchantNames = new StringBuilder();
        for (int i = 0; i < enchants.size(); ++i) {
            Enchantment enchant;
            CompoundNBT enchantTag = enchants.func_150305_b(i);
            ResourceLocation enchantID = ResourceLocation.func_208304_a((String)enchantTag.func_74779_i("id"));
            if (enchantID == null || (enchant = (Enchantment)Registry.field_212628_q.func_82594_a(enchantID)) == null) continue;
            names.add(enchant.func_200305_d(enchantTag.func_74762_e("lvl")).getString());
        }
        Collections.sort(names);
        for (String enchant : names) {
            enchantNames.append(enchant).append(" ");
        }
        return stack.func_77973_b() + " " + enchants.size() + " " + enchantNames;
    }

    private static String toolDuribilityCase(ItemStack stack) {
        return stack.func_77973_b().toString() + stack.func_77952_i();
    }

    public static enum Type {
        NAME,
        MOD,
        CATEGORY;

    }
}

