/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.sorter;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class SlotManager {
    protected final ITravelersBackpackInventory inventory;
    protected List<Integer> unsortableSlots = new ArrayList<Integer>();
    protected List<Pair<Integer, ItemStack>> memorySlots = new ArrayList<Pair<Integer, ItemStack>>();
    protected int[] craftingSlots = new int[]{6, 7, 8, 15, 16, 17, 24, 25, 26};
    protected boolean isUnsortableActive = false;
    protected boolean isMemoryActive = false;
    private final String UNSORTABLE_SLOTS = "UnsortableSlots";
    private final String MEMORY_SLOTS = "MemorySlots";
    public static final byte UNSORTABLE = 0;
    public static final byte MEMORY = 1;
    public static final byte CRAFTING = 2;

    public SlotManager(ITravelersBackpackInventory inventory) {
        this.inventory = inventory;
    }

    public List<Integer> getUnsortableSlots() {
        return this.unsortableSlots;
    }

    public List<Pair<Integer, ItemStack>> getMemorySlots() {
        return this.memorySlots;
    }

    public boolean isSlot(byte type, int slot) {
        if (type == 0) {
            return this.unsortableSlots.contains(slot);
        }
        if (type == 1) {
            for (Pair<Integer, ItemStack> pair : this.memorySlots) {
                if ((Integer)pair.getFirst() != slot) continue;
                return true;
            }
        }
        if (type == 2) {
            if (this.inventory.getTier() == Tiers.LEATHER) {
                return Arrays.stream(this.craftingSlots).anyMatch(i -> i == slot);
            }
            int[] tempCraftingSlots = (int[])this.craftingSlots.clone();
            int i2 = 0;
            while (i2 < 9) {
                int n = i2++;
                tempCraftingSlots[n] = tempCraftingSlots[n] + (this.inventory.getTier().getStorageSlots() - Tiers.LEATHER.getStorageSlots());
            }
            return Arrays.stream(tempCraftingSlots).anyMatch(i -> i == slot);
        }
        return false;
    }

    public void setUnsortableSlots(int[] slots, boolean isFinal) {
        if (this.isSelectorActive((byte)0)) {
            this.unsortableSlots = Arrays.stream(slots).boxed().collect(Collectors.toList());
            if (isFinal) {
                this.setChanged();
            }
        }
    }

    public void setUnsortableSlot(int slot) {
        if (this.isSelectorActive((byte)0) && slot <= this.inventory.getTier().getStorageSlotsWithCrafting() - 1) {
            if (this.isSlot((byte)0, slot)) {
                this.unsortableSlots.remove((Object)slot);
            } else {
                this.unsortableSlots.add(slot);
            }
        }
    }

    public void setMemorySlots(int[] slots, ItemStack[] stacks, boolean isFinal) {
        if (this.isSelectorActive((byte)1)) {
            ArrayList<Pair<Integer, ItemStack>> pairs = new ArrayList<Pair<Integer, ItemStack>>();
            int[] sortOrder = slots;
            if (this.inventory.getSettingsManager().isCraftingGridLocked()) {
                sortOrder = this.inventory.getTier().getSortOrder(this.inventory.getSettingsManager().isCraftingGridLocked());
                sortOrder = Arrays.stream(sortOrder).filter(i -> Arrays.stream(slots).anyMatch(j -> j == i)).toArray();
                ArrayList<Pair> stacksList = new ArrayList<Pair>();
                int k = 0;
                for (int j : slots) {
                    stacksList.add(Pair.of((Object)j, (Object)stacks[k]));
                    ++k;
                }
                ArrayList<Object> sortedStacks = new ArrayList<Object>();
                do {
                    for (int i2 : sortOrder) {
                        Iterator iterator = stacksList.iterator();
                        while (iterator.hasNext()) {
                            Pair pair = (Pair)iterator.next();
                            if (i2 != (Integer)pair.getFirst()) continue;
                            sortedStacks.add(pair.getSecond());
                            iterator.remove();
                        }
                    }
                } while (!stacksList.isEmpty());
                stacks = sortedStacks.toArray(new ItemStack[0]);
            }
            for (int i3 = 0; i3 < stacks.length; ++i3) {
                pairs.add((Pair<Integer, ItemStack>)Pair.of((Object)sortOrder[i3], (Object)stacks[i3]));
            }
            if (!this.inventory.getSettingsManager().isCraftingGridLocked()) {
                pairs.sort(Comparator.comparing(Pair::getFirst));
            }
            this.memorySlots = pairs;
            if (isFinal) {
                this.setChanged();
            }
        }
    }

    public void setMemorySlot(int slot, ItemStack stack) {
        if (this.isSelectorActive((byte)1) && slot <= this.inventory.getTier().getStorageSlotsWithCrafting() - 1) {
            if (this.isSlot((byte)1, slot)) {
                this.memorySlots.removeIf(p -> (Integer)p.getFirst() == slot);
            } else {
                this.memorySlots.add((Pair<Integer, ItemStack>)Pair.of((Object)slot, (Object)stack));
            }
        }
    }

    public void clearUnsortables() {
        if (this.isSelectorActive((byte)0)) {
            this.unsortableSlots = new ArrayList<Integer>();
        }
    }

    public void clearMemory() {
        if (this.isSelectorActive((byte)1)) {
            this.memorySlots = new ArrayList<Pair<Integer, ItemStack>>();
        }
    }

    public void setChanged() {
        if (this.inventory.getScreenID() != 3) {
            this.inventory.setDataChanged(8);
        } else {
            this.inventory.setDataChanged();
        }
    }

    public boolean isSelectorActive(byte type) {
        switch (type) {
            case 0: {
                return this.isUnsortableActive;
            }
            case 1: {
                return this.isMemoryActive;
            }
        }
        return false;
    }

    public void setSelectorActive(byte type, boolean bool) {
        if (type == 0) {
            this.isUnsortableActive = bool;
        } else if (type == 1) {
            this.isMemoryActive = bool;
        }
    }

    public void saveUnsortableSlots(CompoundNBT compound) {
        compound.func_74783_a("UnsortableSlots", this.getUnsortableSlots().stream().mapToInt(i -> i).toArray());
    }

    public void loadUnsortableSlots(CompoundNBT compound) {
        this.unsortableSlots = Arrays.stream(compound.func_74759_k("UnsortableSlots")).boxed().collect(Collectors.toList());
    }

    public void saveMemorySlots(CompoundNBT compound) {
        ListNBT memorySlotsList = new ListNBT();
        for (Pair<Integer, ItemStack> pair : this.memorySlots) {
            CompoundNBT itemTag = new CompoundNBT();
            itemTag.func_74768_a("Slot", ((Integer)pair.getFirst()).intValue());
            ((ItemStack)pair.getSecond()).func_77955_b(itemTag);
            memorySlotsList.add((Object)itemTag);
        }
        compound.func_218657_a("MemorySlots", (INBT)memorySlotsList);
    }

    public void loadMemorySlots(CompoundNBT compound) {
        ListNBT tagList = compound.func_150295_c("MemorySlots", 10);
        ArrayList<Pair<Integer, ItemStack>> pairs = new ArrayList<Pair<Integer, ItemStack>>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT itemTag = tagList.func_150305_b(i);
            int slot = itemTag.func_74762_e("Slot");
            if (slot > this.inventory.getTier().getStorageSlotsWithCrafting() - 1) continue;
            Pair pair = Pair.of((Object)slot, (Object)ItemStack.func_199557_a((CompoundNBT)itemTag));
            pairs.add((Pair<Integer, ItemStack>)pair);
        }
        this.memorySlots = pairs;
    }
}

