/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.sorter;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackBaseContainer;
import com.tiviacz.travelersbackpack.inventory.sorter.SortType;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class InventorySorter {
    public static final byte SORT_BACKPACK = 0;
    public static final byte QUICK_STACK = 1;
    public static final byte TRANSFER_TO_BACKPACK = 2;
    public static final byte TRANSFER_TO_PLAYER = 3;
    public static final byte SORT = 4;
    public static final byte MEMORY = 5;

    public static void selectSort(ITravelersBackpackInventory inventory, PlayerEntity player, byte button, boolean shiftPressed) {
        if (button == 0) {
            InventorySorter.sortBackpack(inventory, player, SortType.Type.CATEGORY, shiftPressed);
        } else if (button == 1) {
            InventorySorter.quickStackToBackpackNoSort(inventory, player, shiftPressed);
        } else if (button == 2) {
            InventorySorter.transferToBackpackNoSort(inventory, player, shiftPressed);
        } else if (button == 3) {
            InventorySorter.transferToPlayer(inventory, player);
        } else if (button == 4) {
            InventorySorter.setUnsortable(inventory, player, shiftPressed);
        } else if (button == 5) {
            InventorySorter.setMemory(inventory, player, shiftPressed);
        }
    }

    public static void sortBackpack(ITravelersBackpackInventory inventory, PlayerEntity player, SortType.Type type, boolean shiftPressed) {
        if (!inventory.getSlotManager().isSelectorActive((byte)0)) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            CustomRangedWrapper rangedWrapper = new CustomRangedWrapper(inventory, inventory.getCombinedInventory(), 0, inventory.getTier().getStorageSlotsWithCrafting());
            for (int i = 0; i < rangedWrapper.getSlots(); ++i) {
                if (inventory.getSettingsManager().isCraftingGridLocked() && inventory.getSlotManager().isSlot((byte)2, i)) continue;
                InventorySorter.addStackWithMerge(stacks, inventory.getSlotManager().isSlot((byte)0, i) ? ItemStack.field_190927_a : rangedWrapper.getStackInSlot(i));
            }
            if (!stacks.isEmpty()) {
                stacks.sort(Comparator.comparing(stack -> SortType.getStringForSort(stack, type)));
            }
            if (stacks.size() == 0) {
                return;
            }
            int j = 0;
            for (int i = 0; i < rangedWrapper.getSlots(); ++i) {
                if (inventory.getSettingsManager().isCraftingGridLocked() && inventory.getSlotManager().isSlot((byte)2, i) || inventory.getSlotManager().isSlot((byte)0, i)) continue;
                rangedWrapper.setStackInSlot(i, j < stacks.size() ? (ItemStack)stacks.get(j) : ItemStack.field_190927_a);
                ++j;
            }
            if (player.field_71070_bA instanceof TravelersBackpackBaseContainer) {
                player.field_71070_bA.func_75130_a((IInventory)((TravelersBackpackBaseContainer)player.field_71070_bA).craftMatrix);
            }
            inventory.setDataChanged(2);
        }
    }

    public static void quickStackToBackpackNoSort(ITravelersBackpackInventory inventory, PlayerEntity player, boolean shiftPressed) {
        int i;
        InvWrapper playerStacks = new InvWrapper((IInventory)player.field_71071_by);
        int n = i = shiftPressed ? 0 : 9;
        while (i < 36) {
            ItemStack playerStack = playerStacks.getStackInSlot(i);
            if (!(playerStack.func_190926_b() || inventory.getScreenID() == 1 && i == player.field_71071_by.field_70461_c)) {
                CustomRangedWrapper rangedWrapper = new CustomRangedWrapper(inventory, (IItemHandlerModifiable)(inventory.getSettingsManager().isCraftingGridLocked() ? inventory.getInventory() : inventory.getCombinedInventory()), 0, inventory.getSettingsManager().isCraftingGridLocked() ? inventory.getTier().getStorageSlots() : inventory.getTier().getStorageSlotsWithCrafting());
                boolean hasExistingStack = IntStream.range(0, rangedWrapper.getSlots()).mapToObj(arg_0 -> ((CustomRangedWrapper)rangedWrapper).getStackInSlot(arg_0)).filter(existing -> !existing.func_190926_b()).anyMatch(existing -> existing.func_77973_b() == playerStack.func_77973_b());
                if (hasExistingStack) {
                    ItemStack ext = playerStacks.extractItem(i, Integer.MAX_VALUE, false);
                    for (int j = 0; j < rangedWrapper.getSlots() && !(ext = rangedWrapper.insertItem(j, ext, false)).func_190926_b(); ++j) {
                    }
                    if (!ext.func_190926_b()) {
                        playerStacks.insertItem(i, ext, false);
                    }
                }
            }
            ++i;
        }
        if (player.field_71070_bA instanceof TravelersBackpackBaseContainer) {
            player.field_71070_bA.func_75130_a((IInventory)((TravelersBackpackBaseContainer)player.field_71070_bA).craftMatrix);
        }
    }

    public static void transferToBackpackNoSort(ITravelersBackpackInventory inventory, PlayerEntity player, boolean shiftPressed) {
        int i;
        InvWrapper playerStacks;
        block11: {
            playerStacks = new InvWrapper((IInventory)player.field_71071_by);
            if (inventory.getSlotManager().getMemorySlots().isEmpty()) break block11;
            for (Pair<Integer, ItemStack> pair : inventory.getSlotManager().getMemorySlots()) {
                int firstCraftSlot;
                int i2;
                if (inventory.getSettingsManager().isCraftingGridLocked() && ((i2 = ((Integer)pair.getFirst()).intValue()) == (firstCraftSlot = inventory.getTier().getStorageSlots() - Tiers.LEATHER.getStorageSlots() + 5) || i2 == firstCraftSlot + 1 || i2 == firstCraftSlot + 2 || i2 == firstCraftSlot + 8 || i2 == firstCraftSlot + 9 || i2 == firstCraftSlot + 10 || i2 == firstCraftSlot + 16 || i2 == firstCraftSlot + 17 || i2 == firstCraftSlot + 18)) continue;
                int n = i2 = shiftPressed ? 0 : 9;
                while (i2 < 36) {
                    block12: {
                        ItemStack ext;
                        block13: {
                            ItemStack playerStack = playerStacks.getStackInSlot(i2);
                            if (playerStack.func_190926_b() || inventory.getScreenID() == 1 && i2 == player.field_71071_by.field_70461_c) break block12;
                            CustomRangedWrapper rangedWrapper = new CustomRangedWrapper(inventory, inventory.getCombinedInventory(), 0, inventory.getTier().getStorageSlotsWithCrafting());
                            ItemStack extSimulate = playerStacks.extractItem(i2, Integer.MAX_VALUE, true);
                            ext = ItemStack.field_190927_a;
                            if (!ItemStackUtils.isSameItemSameTags((ItemStack)pair.getSecond(), extSimulate)) break block13;
                            ext = playerStacks.extractItem(i2, Integer.MAX_VALUE, false);
                            ext = rangedWrapper.insertItem((Integer)pair.getFirst(), ext, false);
                            if (ext.func_190926_b()) break block12;
                        }
                        if (!ext.func_190926_b()) {
                            playerStacks.insertItem(i2, ext, false);
                        }
                    }
                    ++i2;
                }
            }
        }
        int n = i = shiftPressed ? 0 : 9;
        while (i < 36) {
            ItemStack playerStack = playerStacks.getStackInSlot(i);
            if (!(playerStack.func_190926_b() || inventory.getScreenID() == 1 && i == player.field_71071_by.field_70461_c)) {
                CustomRangedWrapper rangedWrapper = new CustomRangedWrapper(inventory, (IItemHandlerModifiable)(inventory.getSettingsManager().isCraftingGridLocked() ? inventory.getInventory() : inventory.getCombinedInventory()), 0, inventory.getSettingsManager().isCraftingGridLocked() ? inventory.getTier().getStorageSlots() : inventory.getTier().getStorageSlotsWithCrafting());
                ItemStack ext = playerStacks.extractItem(i, Integer.MAX_VALUE, false);
                for (int j = 0; j < rangedWrapper.getSlots() && !(ext = rangedWrapper.insertItem(j, ext, false)).func_190926_b(); ++j) {
                }
                if (!ext.func_190926_b()) {
                    playerStacks.insertItem(i, ext, false);
                }
            }
            ++i;
        }
        if (player.field_71070_bA instanceof TravelersBackpackBaseContainer) {
            player.field_71070_bA.func_75130_a((IInventory)((TravelersBackpackBaseContainer)player.field_71070_bA).craftMatrix);
        }
    }

    public static void transferToPlayer(ITravelersBackpackInventory inventory, PlayerEntity player) {
        InvWrapper playerStacks = new InvWrapper((IInventory)player.field_71071_by);
        CustomRangedWrapper rangedWrapper = new CustomRangedWrapper(inventory, (IItemHandlerModifiable)(inventory.getSettingsManager().isCraftingGridLocked() ? inventory.getInventory() : inventory.getCombinedInventory()), 0, inventory.getSettingsManager().isCraftingGridLocked() ? inventory.getTier().getStorageSlots() : inventory.getTier().getStorageSlotsWithCrafting());
        for (int i = 0; i < rangedWrapper.getSlots(); ++i) {
            ItemStack stack = rangedWrapper.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ItemStack ext = rangedWrapper.extractItem(i, Integer.MAX_VALUE, false);
            for (int j = 9; j < 36 && !(ext = playerStacks.insertItem(j, ext, false)).func_190926_b(); ++j) {
            }
            if (ext.func_190926_b()) continue;
            rangedWrapper.isTransferToPlayer = true;
            rangedWrapper.insertItem(i, ext, false);
            rangedWrapper.isTransferToPlayer = false;
        }
        if (player.field_71070_bA instanceof TravelersBackpackBaseContainer) {
            player.field_71070_bA.func_75130_a((IInventory)((TravelersBackpackBaseContainer)player.field_71070_bA).craftMatrix);
        }
    }

    public static void setUnsortable(ITravelersBackpackInventory container, PlayerEntity player, boolean shiftPressed) {
        container.getSlotManager().setSelectorActive((byte)0, !container.getSlotManager().isSelectorActive((byte)0));
    }

    public static void setMemory(ITravelersBackpackInventory container, PlayerEntity player, boolean shiftPressed) {
        container.getSlotManager().setSelectorActive((byte)1, !container.getSlotManager().isSelectorActive((byte)1));
    }

    private static void addStackWithMerge(List<ItemStack> stacks, ItemStack newStack) {
        if (newStack.func_190926_b()) {
            return;
        }
        if (newStack.func_77985_e() && newStack.func_190916_E() != newStack.func_77976_d()) {
            for (int j = stacks.size() - 1; j >= 0; --j) {
                ItemStack oldStack = stacks.get(j);
                if (!InventorySorter.canMergeItems(newStack, oldStack)) continue;
                InventorySorter.combineStacks(newStack, oldStack);
                if (!oldStack.func_190926_b() && oldStack.func_190916_E() != 0) continue;
                stacks.remove(j);
            }
        }
        stacks.add(newStack);
    }

    private static void combineStacks(ItemStack stack, ItemStack stack2) {
        if (stack.func_77976_d() >= stack.func_190916_E() + stack2.func_190916_E()) {
            stack.func_190917_f(stack2.func_190916_E());
            stack2.func_190920_e(0);
        }
        int maxInsertAmount = Math.min(stack.func_77976_d() - stack.func_190916_E(), stack2.func_190916_E());
        stack.func_190917_f(maxInsertAmount);
        stack2.func_190918_g(maxInsertAmount);
    }

    private static boolean canMergeItems(ItemStack stack1, ItemStack stack2) {
        if (!stack1.func_77985_e() || !stack2.func_77985_e()) {
            return false;
        }
        if (stack1.func_190916_E() == stack2.func_77976_d() || stack2.func_190916_E() == stack2.func_77976_d()) {
            return false;
        }
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_77952_i() != stack2.func_77952_i()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static class CustomRangedWrapper
    extends RangedWrapper {
        private final ITravelersBackpackInventory inventory;
        public boolean isTransferToPlayer;

        public CustomRangedWrapper(ITravelersBackpackInventory inventory, IItemHandlerModifiable compose, int minSlot, int maxSlotExclusive) {
            this(inventory, compose, minSlot, maxSlotExclusive, false);
        }

        public CustomRangedWrapper(ITravelersBackpackInventory inventory, IItemHandlerModifiable compose, int minSlot, int maxSlotExclusive, boolean isTransferToPlayer) {
            super(compose, minSlot, maxSlotExclusive);
            this.inventory = inventory;
            this.isTransferToPlayer = isTransferToPlayer;
        }

        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.inventory.getSlotManager().isSlot((byte)1, slot)) {
                return this.inventory.getSlotManager().getMemorySlots().stream().noneMatch(pair -> (Integer)pair.getFirst() == slot && ItemStackUtils.isSameItemSameTags((ItemStack)pair.getSecond(), stack)) && !this.isTransferToPlayer ? stack : super.insertItem(slot, stack, simulate);
            }
            return this.inventory.getSlotManager().isSlot((byte)0, slot) ? stack : super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.inventory.getSlotManager().isSlot((byte)0, slot) ? ItemStack.field_190927_a : super.extractItem(slot, amount, simulate);
        }
    }
}

