/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.container.slot;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.TieredItem;
import net.minecraft.item.ToolItem;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ToolSlotItemHandler
extends SlotItemHandler {
    private final PlayerEntity player;
    private final ITravelersBackpackInventory inventory;
    public static final List<Item> TOOL_SLOTS_ACCEPTABLE_ITEMS = new ArrayList<Item>();

    public ToolSlotItemHandler(PlayerEntity player, ITravelersBackpackInventory inventoryIn, int index, int xPosition, int yPosition) {
        super((IItemHandler)inventoryIn.getInventory(), index, xPosition, yPosition);
        this.player = player;
        this.inventory = inventoryIn;
    }

    public boolean canAccessPlace() {
        return true;
    }

    public boolean canAccessPickup() {
        return true;
    }

    public boolean func_111238_b() {
        return this.inventory.getSettingsManager().showToolSlots();
    }

    public boolean func_75214_a(ItemStack stack) {
        return ToolSlotItemHandler.isValid(stack) && this.inventory.getSettingsManager().showToolSlots();
    }

    public static boolean isValid(ItemStack stack) {
        ResourceLocation acceptableToolsTag = new ResourceLocation("travelersbackpack", "acceptable_tools");
        if (stack.func_77973_b().func_206844_a(ItemTags.func_199903_a().func_199910_a(acceptableToolsTag))) {
            return true;
        }
        if (TOOL_SLOTS_ACCEPTABLE_ITEMS.contains(stack.func_77973_b())) {
            return true;
        }
        if (stack.func_77976_d() == 1) {
            if (TravelersBackpackConfig.toolSlotsAcceptSwords && stack.func_77973_b() instanceof SwordItem) {
                return true;
            }
            return stack.func_77973_b() instanceof TieredItem || stack.func_77973_b() instanceof ToolItem || stack.func_77973_b() instanceof HoeItem || stack.func_77973_b() instanceof FishingRodItem || stack.func_77973_b() instanceof ShearsItem || stack.func_77973_b() instanceof FlintAndSteelItem || stack.func_77973_b() instanceof ShootableItem;
        }
        return false;
    }

    public void func_75218_e() {
        super.func_75218_e();
        if (this.inventory.getScreenID() == 2) {
            CapabilityUtils.synchronise(this.player);
            CapabilityUtils.synchroniseToOthers(this.player);
        }
    }
}

