/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.container;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.CraftingInventoryImproved;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.container.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.container.slot.CraftResultSlotExt;
import com.tiviacz.travelersbackpack.inventory.container.slot.FluidSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.container.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.CUpdateRecipePacket;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.IntStream;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class TravelersBackpackBaseContainer
extends Container {
    public PlayerInventory playerInventory;
    public ITravelersBackpackInventory inventory;
    public CraftingInventoryImproved craftMatrix;
    public CraftResultInventory craftResult = new CraftResultInventory();
    private final int BACKPACK_INV_START = 1;
    private final int BACKPACK_INV_END;
    private final int TOOL_START;
    private final int TOOL_END;
    private final int BUCKET_LEFT_IN;
    private final int BUCKET_LEFT_OUT;
    private final int BUCKET_RIGHT_IN;
    private final int BUCKET_RIGHT_OUT;
    private final int PLAYER_INV_START;
    private final int PLAYER_HOT_END;

    public TravelersBackpackBaseContainer(ContainerType<?> type, int windowID, PlayerInventory playerInventory, ITravelersBackpackInventory inventory) {
        super(type, windowID);
        this.playerInventory = playerInventory;
        this.inventory = inventory;
        this.craftMatrix = new CraftingInventoryImproved(inventory, this);
        int currentItemIndex = playerInventory.field_70461_c;
        this.BACKPACK_INV_END = 1 + inventory.getTier().getStorageSlotsWithCrafting() - 1;
        this.TOOL_START = this.BACKPACK_INV_END + 1;
        this.TOOL_END = this.TOOL_START + inventory.getTier().getToolSlots() - 1;
        this.BUCKET_LEFT_IN = this.TOOL_END + 1;
        this.BUCKET_LEFT_OUT = this.BUCKET_LEFT_IN + 1;
        this.BUCKET_RIGHT_IN = this.BUCKET_LEFT_OUT + 1;
        this.BUCKET_RIGHT_OUT = this.BUCKET_RIGHT_IN + 1;
        this.PLAYER_INV_START = this.BUCKET_RIGHT_OUT + 1;
        this.PLAYER_HOT_END = this.PLAYER_INV_START + 35;
        this.addCraftResult();
        this.addBackpackInventoryAndCraftingGrid(inventory);
        this.addToolSlots(inventory);
        this.addFluidSlots(inventory);
        this.addPlayerInventoryAndHotbar(playerInventory, currentItemIndex);
        this.func_75130_a((IInventory)new RecipeWrapper((IItemHandlerModifiable)inventory.getCraftingGridInventory()));
    }

    public void addCraftResult() {
        this.func_75146_a((Slot)new CraftResultSlotExt(this.inventory, this.playerInventory.field_70458_d, this.craftMatrix, this.craftResult, 0, 226, 43 + this.inventory.getTier().getMenuSlotPlacementFactor()));
    }

    public void addBackpackInventoryAndCraftingGrid(ITravelersBackpackInventory inventory) {
        int j;
        int i;
        int slot = 0;
        if (inventory.getTier().getOrdinal() > Tiers.LEATHER.getOrdinal()) {
            for (i = 0; i < inventory.getTier().getOrdinal(); ++i) {
                for (j = 0; j < 9; ++j) {
                    this.func_75146_a((Slot)new BackpackSlotItemHandler((IItemHandler)inventory.getInventory(), slot++, 44 + j * 18, 7 + i * 18));
                }
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                if (j >= 6) {
                    this.func_75146_a(new Slot((IInventory)this.craftMatrix, j - 6 + i * 3, 152 + (j - 6) * 18, 7 + this.inventory.getTier().getMenuSlotPlacementFactor() + i * 18){

                        public boolean func_75214_a(ItemStack stack) {
                            ResourceLocation blacklistedItems = new ResourceLocation("travelersbackpack", "blacklisted_items");
                            if (BackpackSlotItemHandler.BLACKLISTED_ITEMS.contains(stack.func_77973_b())) {
                                return false;
                            }
                            return !(stack.func_77973_b() instanceof TravelersBackpackItem) && !stack.func_77973_b().func_206844_a(ItemTags.func_199903_a().func_199910_a(blacklistedItems));
                        }
                    });
                    continue;
                }
                this.func_75146_a((Slot)new BackpackSlotItemHandler((IItemHandler)inventory.getInventory(), slot++, 44 + j * 18, 7 + this.inventory.getTier().getMenuSlotPlacementFactor() + i * 18));
            }
        }
    }

    public void addPlayerInventoryAndHotbar(PlayerInventory playerInv, int currentItemIndex) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInv, x + y * 9 + 9, 44 + x * 18, 71 + this.inventory.getTier().getMenuSlotPlacementFactor() + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInv, x, 44 + x * 18, 129 + this.inventory.getTier().getMenuSlotPlacementFactor()));
        }
    }

    public void addFluidSlots(ITravelersBackpackInventory inventory) {
        this.func_75146_a((Slot)new FluidSlotItemHandler(inventory, inventory.getTier().getSlotIndex(Tiers.SlotType.BUCKET_IN_LEFT), 6, 7){

            @Override
            public boolean func_111238_b() {
                return !TravelersBackpackBaseContainer.this.inventory.getSettingsManager().showToolSlots() && super.func_111238_b();
            }
        });
        this.func_75146_a((Slot)new FluidSlotItemHandler(inventory, inventory.getTier().getSlotIndex(Tiers.SlotType.BUCKET_OUT_LEFT), 6, 37){

            @Override
            public boolean func_111238_b() {
                return !TravelersBackpackBaseContainer.this.inventory.getSettingsManager().showToolSlots() && super.func_111238_b();
            }
        });
        this.func_75146_a((Slot)new FluidSlotItemHandler(inventory, inventory.getTier().getSlotIndex(Tiers.SlotType.BUCKET_IN_RIGHT), 226, 7));
        this.func_75146_a((Slot)new FluidSlotItemHandler(inventory, inventory.getTier().getSlotIndex(Tiers.SlotType.BUCKET_OUT_RIGHT), 226, 37));
    }

    public void addToolSlots(ITravelersBackpackInventory inventory) {
        for (int i = 0; i < inventory.getTier().getToolSlots(); ++i) {
            this.func_75146_a((Slot)new ToolSlotItemHandler(this.playerInventory.field_70458_d, inventory, inventory.getTier().getSlotIndex(Tiers.SlotType.TOOL_FIRST) + i, 6, 7 + 18 * i));
        }
    }

    public void func_75130_a(IInventory inventory) {
        super.func_75130_a(inventory);
        if (!TravelersBackpackConfig.disableCrafting) {
            this.slotChangedCraftingGrid(this.playerInventory.field_70458_d.field_70170_p, this.playerInventory.field_70458_d);
        }
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.craftResult && super.func_94530_a(stack, slotIn);
    }

    public ItemStack handleShiftCraft(PlayerEntity player, Slot resultSlot) {
        ItemStack outputCopy = ItemStack.field_190927_a;
        if (resultSlot != null && resultSlot.func_75216_d()) {
            this.craftMatrix.checkChanges = false;
            IRecipe recipe = this.craftResult.func_193055_i();
            while (recipe != null && recipe.func_77569_a((IInventory)this.craftMatrix, player.field_70170_p)) {
                ItemStack recipeOutput = resultSlot.func_75211_c().func_77946_l();
                outputCopy = recipeOutput.func_77946_l();
                recipeOutput.func_77973_b().func_77622_d(recipeOutput, player.field_70170_p, player);
                if (!player.field_70170_p.field_72995_K && !this.moveItemStackTo(recipeOutput, 1, this.PLAYER_HOT_END + 1, true, true, true)) {
                    this.craftMatrix.checkChanges = true;
                    return ItemStack.field_190927_a;
                }
                resultSlot.func_75220_a(recipeOutput, outputCopy);
                resultSlot.func_75218_e();
                if (!player.field_70170_p.field_72995_K && recipeOutput.func_190916_E() == outputCopy.func_190916_E()) {
                    this.craftMatrix.checkChanges = true;
                    return ItemStack.field_190927_a;
                }
                this.craftResult.func_193056_a(recipe);
                resultSlot.func_190901_a(player, recipeOutput);
            }
            this.craftMatrix.checkChanges = true;
            this.func_75130_a((IInventory)new RecipeWrapper((IItemHandlerModifiable)this.inventory.getCraftingGridInventory()));
            this.inventory.setDataChanged(1);
        }
        this.craftMatrix.checkChanges = true;
        return this.craftResult.func_193055_i() == null ? ItemStack.field_190927_a : outputCopy;
    }

    public void slotChangedCraftingGrid(World world, PlayerEntity player) {
        if (!world.field_72995_K) {
            ItemStack itemstack = ItemStack.field_190927_a;
            IRecipe oldRecipe = this.craftResult.func_193055_i();
            IRecipe recipe = oldRecipe;
            if (recipe == null || !recipe.func_77569_a((IInventory)this.craftMatrix, world)) {
                recipe = world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.craftMatrix, world).orElse(null);
            }
            if (recipe != null) {
                itemstack = recipe.func_77572_b((IInventory)this.craftMatrix);
            }
            if (oldRecipe != recipe) {
                TravelersBackpack.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new CUpdateRecipePacket(recipe, itemstack));
                this.craftResult.func_70299_a(0, itemstack);
                this.craftResult.func_193056_a(recipe);
            } else if (recipe != null && recipe.func_192399_d()) {
                TravelersBackpack.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new CUpdateRecipePacket(recipe, itemstack));
                this.craftResult.func_70299_a(0, itemstack);
                this.craftResult.func_193056_a(recipe);
            }
        }
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        Slot slot = this.func_75139_a(index);
        ItemStack result = ItemStack.field_190927_a;
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            result = stack.func_77946_l();
            if (index >= 0 && index <= this.BUCKET_RIGHT_OUT) {
                if (index == 0) {
                    return this.handleShiftCraft(player, slot);
                }
                if (!this.func_75135_a(stack, this.PLAYER_INV_START, this.PLAYER_HOT_END + 1, true)) {
                    return ItemStack.field_190927_a;
                }
            }
            if (index >= this.PLAYER_INV_START) {
                if (!this.inventory.getSlotManager().getMemorySlots().isEmpty()) {
                    boolean isCraftingLocked = this.inventory.getSettingsManager().isCraftingGridLocked();
                    ArrayList<Pair<Integer, ItemStack>> craftingSlots = new ArrayList<Pair<Integer, ItemStack>>();
                    for (Pair<Integer, ItemStack> pair : this.inventory.getSlotManager().getMemorySlots()) {
                        if (isCraftingLocked) {
                            Slot slot1 = this.func_75139_a((Integer)pair.getFirst() + 1);
                            if (slot1.field_75224_c instanceof CraftingInventoryImproved) {
                                craftingSlots.add(pair);
                                continue;
                            }
                        }
                        if (!ItemStackUtils.isSameItemSameTags((ItemStack)pair.getSecond(), stack) || this.func_75139_a((Integer)pair.getFirst() + 1).func_75211_c().func_190916_E() == this.func_75139_a((Integer)pair.getFirst() + 1).func_75211_c().func_77976_d() || !this.func_75135_a(stack, (Integer)pair.getFirst() + 1, (Integer)pair.getFirst() + 2, false)) continue;
                        break;
                    }
                    if (!craftingSlots.isEmpty()) {
                        Pair pair;
                        Iterator<Object> iterator = craftingSlots.iterator();
                        while (!(!iterator.hasNext() || ItemStackUtils.isSameItemSameTags((ItemStack)(pair = (Pair)iterator.next()).getSecond(), stack) && this.func_75139_a((Integer)pair.getFirst() + 1).func_75211_c().func_190916_E() != this.func_75139_a((Integer)pair.getFirst() + 1).func_75211_c().func_77976_d() && this.func_75135_a(stack, (Integer)pair.getFirst() + 1, (Integer)pair.getFirst() + 2, false))) {
                        }
                    }
                }
                if (ToolSlotItemHandler.isValid(stack) && !this.func_75135_a(stack, this.TOOL_START, this.TOOL_END + 1, false) && !this.moveItemStackTo(stack, 1, this.BACKPACK_INV_END + 1, false, true, false)) {
                    return ItemStack.field_190927_a;
                }
                if (!this.moveItemStackTo(stack, 1, this.BACKPACK_INV_END + 1, false, true, false)) {
                    return ItemStack.field_190927_a;
                }
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == result.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stack);
        }
        return result;
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean fromLast, boolean bool, boolean isResult) {
        boolean skippedCrafting = false;
        boolean flag = false;
        int i = startIndex;
        if (fromLast) {
            i = endIndex - 1;
        }
        if (stack.func_77985_e()) {
            while (!stack.func_190926_b() && !(fromLast ? i < startIndex : i >= endIndex)) {
                Slot slot = (Slot)this.field_75151_b.get(i);
                if (bool && (this.inventory.getSettingsManager().isCraftingGridLocked() || isResult) && slot.field_75224_c instanceof CraftingInventoryImproved) {
                    i = fromLast ? --i : ++i;
                    skippedCrafting = true;
                    continue;
                }
                ItemStack itemstack = slot.func_75211_c();
                if (!itemstack.func_190926_b() && TravelersBackpackBaseContainer.func_195929_a((ItemStack)stack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.func_190916_E() + stack.func_190916_E();
                    if (j <= (maxSize = Math.min(slot.func_75219_a(), stack.func_77976_d()))) {
                        stack.func_190920_e(0);
                        itemstack.func_190920_e(j);
                        slot.func_75218_e();
                        flag = true;
                    } else if (itemstack.func_190916_E() < maxSize) {
                        stack.func_190918_g(maxSize - itemstack.func_190916_E());
                        itemstack.func_190920_e(maxSize);
                        slot.func_75218_e();
                        flag = true;
                    }
                }
                if (fromLast) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.func_190926_b()) {
            i = fromLast ? endIndex - 1 : startIndex;
            while (!(fromLast ? i < startIndex : i >= endIndex)) {
                Slot slot1 = (Slot)this.field_75151_b.get(i);
                if (bool && (this.inventory.getSettingsManager().isCraftingGridLocked() || isResult) && slot1.field_75224_c instanceof CraftingInventoryImproved) {
                    i = fromLast ? --i : ++i;
                    skippedCrafting = true;
                    continue;
                }
                ItemStack itemstack1 = slot1.func_75211_c();
                if (itemstack1.func_190926_b() && this.mayPlace(slot1, stack)) {
                    if (stack.func_190916_E() > slot1.func_75219_a()) {
                        slot1.func_75215_d(stack.func_77979_a(slot1.func_75219_a()));
                    } else {
                        slot1.func_75215_d(stack.func_77979_a(stack.func_190916_E()));
                    }
                    slot1.func_75218_e();
                    flag = true;
                    break;
                }
                if (fromLast) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (skippedCrafting && !isResult) {
            i = 43;
            bool = false;
            this.moveItemStackTo(stack, i, endIndex, fromLast, bool, false);
        }
        return flag;
    }

    public boolean mayPlace(Slot slot, ItemStack stack) {
        if (this.inventory.getSlotManager().isSlot((byte)1, slot.field_75222_d - 1)) {
            return slot.func_75214_a(stack) && this.inventory.getSlotManager().getMemorySlots().stream().anyMatch(p -> (Integer)p.getFirst() + 1 == slot.field_75222_d && ItemStackUtils.isSameItemSameTags((ItemStack)p.getSecond(), stack));
        }
        return slot.func_75214_a(stack);
    }

    protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean fromLast) {
        boolean flag = false;
        int i = startIndex;
        if (fromLast) {
            i = endIndex - 1;
        }
        if (stack.func_77985_e()) {
            while (!stack.func_190926_b() && !(!fromLast ? i >= endIndex : i < startIndex)) {
                Slot slot = (Slot)this.field_75151_b.get(i);
                ItemStack itemstack = slot.func_75211_c();
                if (!itemstack.func_190926_b() && TravelersBackpackBaseContainer.func_195929_a((ItemStack)stack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.func_190916_E() + stack.func_190916_E();
                    if (j <= (maxSize = Math.min(slot.func_75219_a(), stack.func_77976_d()))) {
                        stack.func_190920_e(0);
                        itemstack.func_190920_e(j);
                        slot.func_75218_e();
                        flag = true;
                    } else if (itemstack.func_190916_E() < maxSize) {
                        stack.func_190918_g(maxSize - itemstack.func_190916_E());
                        itemstack.func_190920_e(maxSize);
                        slot.func_75218_e();
                        flag = true;
                    }
                }
                if (fromLast) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.func_190926_b()) {
            i = fromLast ? endIndex - 1 : startIndex;
            while (!(!fromLast ? i >= endIndex : i < startIndex)) {
                Slot slot1 = (Slot)this.field_75151_b.get(i);
                ItemStack itemstack1 = slot1.func_75211_c();
                if (itemstack1.func_190926_b() && this.mayPlace(slot1, stack)) {
                    if (stack.func_190916_E() > slot1.func_75219_a()) {
                        slot1.func_75215_d(stack.func_77979_a(slot1.func_75219_a()));
                    } else {
                        slot1.func_75215_d(stack.func_77979_a(stack.func_190916_E()));
                    }
                    slot1.func_75218_e();
                    flag = true;
                    break;
                }
                if (fromLast) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, PlayerEntity player) {
        if (this.inventory.getSlotManager().isSelectorActive((byte)0) || this.inventory.getSlotManager().isSelectorActive((byte)1)) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickType, player);
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        if (this.inventory.getScreenID() != 3) {
            this.inventory.setDataChanged(10);
        }
        if (this.inventory.getScreenID() == 3) {
            if (this.inventory.getSlotManager().isSelectorActive((byte)0) || this.inventory.getSlotManager().isSelectorActive((byte)1)) {
                this.inventory.getSlotManager().setChanged();
            }
            this.inventory.setUsingPlayer(null);
        }
        if (this.inventory.getSlotManager().isSelectorActive((byte)0)) {
            this.inventory.getSlotManager().setSelectorActive((byte)0, false);
        }
        if (this.inventory.getSlotManager().isSelectorActive((byte)1)) {
            this.inventory.getSlotManager().setSelectorActive((byte)1, false);
        }
        this.playSound(playerIn, this.inventory);
        TravelersBackpackBaseContainer.clearBucketSlots(playerIn, this.inventory);
        this.shiftTools(this.inventory);
    }

    public static void clearBucketSlots(PlayerEntity playerIn, ITravelersBackpackInventory inventoryIn) {
        IntStream.range(inventoryIn.getTier().getSlotIndex(Tiers.SlotType.BUCKET_IN_LEFT), inventoryIn.getTier().getSlotIndex(Tiers.SlotType.BUCKET_OUT_RIGHT) + 1).forEach(i -> TravelersBackpackBaseContainer.clearBucketSlot(playerIn, inventoryIn, i));
    }

    public static void clearBucketSlot(PlayerEntity playerIn, ITravelersBackpackInventory inventoryIn, int index) {
        if (!inventoryIn.getFluidSlotsInventory().getStackInSlot(index).func_190926_b()) {
            if (playerIn == null) {
                return;
            }
            if (!playerIn.func_70089_S() || playerIn instanceof ServerPlayerEntity && ((ServerPlayerEntity)playerIn).func_193105_t()) {
                ItemStack stack = inventoryIn.getFluidSlotsInventory().getStackInSlot(index).func_77946_l();
                inventoryIn.getFluidSlotsInventory().setStackInSlot(index, ItemStack.field_190927_a);
                playerIn.func_71019_a(stack, false);
            } else {
                ItemStack stack = inventoryIn.getFluidSlotsInventory().getStackInSlot(index);
                inventoryIn.getFluidSlotsInventory().setStackInSlot(index, ItemStack.field_190927_a);
                playerIn.field_71071_by.func_191975_a(playerIn.field_70170_p, stack);
            }
        }
    }

    public void playSound(PlayerEntity playerIn, ITravelersBackpackInventory inventoryIn) {
        for (int i = inventoryIn.getTier().getSlotIndex(Tiers.SlotType.BUCKET_IN_LEFT); i <= inventoryIn.getTier().getSlotIndex(Tiers.SlotType.BUCKET_OUT_RIGHT); ++i) {
            if (inventoryIn.getFluidSlotsInventory().getStackInSlot(i).func_190926_b()) continue;
            playerIn.field_70170_p.func_184133_a(playerIn, playerIn.func_233580_cy_(), SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 1.0f, (1.0f + (playerIn.field_70170_p.field_73012_v.nextFloat() - playerIn.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            break;
        }
    }

    public void shiftTools(ITravelersBackpackInventory inventory) {
        int toolIndex;
        boolean foundEmptySlot = false;
        boolean needsShifting = false;
        for (int i = toolIndex = inventory.getTier().getSlotIndex(Tiers.SlotType.TOOL_FIRST); i < toolIndex + inventory.getTier().getToolSlots(); ++i) {
            if (foundEmptySlot && !inventory.getInventory().getStackInSlot(i).func_190926_b()) {
                needsShifting = true;
            }
            if (!inventory.getInventory().getStackInSlot(i).func_190926_b() || foundEmptySlot) continue;
            foundEmptySlot = true;
        }
        if (needsShifting) {
            int i;
            NonNullList tools = NonNullList.func_191197_a((int)inventory.getTier().getToolSlots(), (Object)ItemStack.field_190927_a);
            int j = 0;
            for (i = toolIndex; i < toolIndex + inventory.getTier().getToolSlots(); ++i) {
                if (inventory.getInventory().getStackInSlot(i).func_190926_b()) continue;
                tools.set(j, (Object)inventory.getInventory().getStackInSlot(i));
                ++j;
            }
            j = 0;
            for (i = toolIndex; i < toolIndex + inventory.getTier().getToolSlots(); ++i) {
                if (tools.isEmpty()) continue;
                inventory.getInventory().setStackInSlot(i, (ItemStack)tools.get(j));
                ++j;
            }
        }
    }
}

