/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import net.minecraft.nbt.CompoundNBT;

public class SettingsManager {
    private final ITravelersBackpackInventory inventory;
    private byte[] craftingSettings = new byte[]{1, 1};
    private byte[] toolSlotsSettings = new byte[]{0};
    public static final byte CRAFTING = 0;
    public static final byte TOOL_SLOTS = 1;
    public static final int LOCK_CRAFTING_GRID = 0;
    public static final int RENDER_OVERLAY = 1;
    public static final int SHOW_TOOL_SLOTS = 0;
    private final String CRAFTING_SETTINGS = "CraftingSettings";
    private final String TOOL_SLOTS_SETTINGS = "ToolSlotsSettings";

    public SettingsManager(ITravelersBackpackInventory inventory) {
        this.inventory = inventory;
    }

    public boolean isCraftingGridLocked() {
        return this.getByte((byte)0, 0) == 1;
    }

    public boolean renderOverlay() {
        return this.getByte((byte)0, 1) == 1;
    }

    public boolean showToolSlots() {
        return this.getByte((byte)1, 0) == 1;
    }

    public byte getByte(byte dataArray, int place) {
        if (dataArray == 0) {
            if (TravelersBackpackConfig.disableCrafting && place == 0) {
                return 0;
            }
            return this.craftingSettings[place];
        }
        if (dataArray == 1) {
            return this.toolSlotsSettings[place];
        }
        return 0;
    }

    public void set(byte selectedDataArray, int place, byte value) {
        byte[] dataArray = new byte[]{};
        if (selectedDataArray == 0) {
            dataArray = this.craftingSettings;
        }
        if (selectedDataArray == 1) {
            dataArray = this.toolSlotsSettings;
        }
        dataArray[place] = value;
        this.setChanged();
    }

    public void saveSettings(CompoundNBT compound) {
        compound.func_74773_a("CraftingSettings", this.craftingSettings);
        compound.func_74773_a("ToolSlotsSettings", this.toolSlotsSettings);
    }

    public void loadSettings(CompoundNBT compound) {
        byte[] byArray;
        byte[] byArray2;
        if (compound.func_74764_b("CraftingSettings")) {
            byArray2 = compound.func_74770_j("CraftingSettings");
        } else {
            byte[] byArray3 = new byte[2];
            byArray3[0] = 1;
            byArray2 = byArray3;
            byArray3[1] = 1;
        }
        this.craftingSettings = byArray2;
        if (compound.func_74764_b("ToolSlotsSettings")) {
            byArray = compound.func_74770_j("ToolSlotsSettings");
        } else {
            byte[] byArray4 = new byte[1];
            byArray = byArray4;
            byArray4[0] = 0;
        }
        this.toolSlotsSettings = byArray;
    }

    public void setChanged() {
        if (this.inventory.getScreenID() != 3) {
            this.inventory.setDataChanged(9);
        } else {
            this.inventory.setDataChanged();
        }
    }
}

