/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.mojang.brigadier.CommandDispatcher;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackCapability;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackWearable;
import com.tiviacz.travelersbackpack.capability.entity.IEntityTravelersBackpack;
import com.tiviacz.travelersbackpack.capability.entity.TravelersBackpackEntityCapability;
import com.tiviacz.travelersbackpack.capability.entity.TravelersBackpackEntityWearable;
import com.tiviacz.travelersbackpack.commands.AccessBackpackCommand;
import com.tiviacz.travelersbackpack.commands.ClearBackpackCommand;
import com.tiviacz.travelersbackpack.commands.RestoreBackpackCommand;
import com.tiviacz.travelersbackpack.commands.UnpackBackpackCommand;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.common.recipes.BackpackDyeRecipe;
import com.tiviacz.travelersbackpack.common.recipes.ShapedBackpackRecipe;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import com.tiviacz.travelersbackpack.items.SleepingBagItem;
import com.tiviacz.travelersbackpack.items.TierUpgradeItem;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.CSyncCapabilityPacket;
import com.tiviacz.travelersbackpack.tileentity.TravelersBackpackTileEntity;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import com.tiviacz.travelersbackpack.util.Reference;
import com.tiviacz.travelersbackpack.util.ResourceUtils;
import com.tiviacz.travelersbackpack.util.TimeUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.server.command.ConfigCommand;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@Mod.EventBusSubscriber(modid="travelersbackpack", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventHandler {
    private static boolean checkAbilitiesForRemoval = true;
    private static long nextBackpackCountCheck = 0L;
    private static final int BACKPACK_COUNT_CHECK_COOLDOWN = 100;

    @SubscribeEvent
    public static void playerSetSpawn(PlayerSetSpawnEvent event) {
        World world = event.getPlayer().field_70170_p;
        if (event.getNewSpawn() != null) {
            Block block = world.func_180495_p(event.getNewSpawn()).func_177230_c();
            if (!world.field_72995_K && block instanceof SleepingBagBlock && !TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        TravelersBackpackTileEntity tileEntity;
        ItemStack stack = event.getItemStack();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        PlayerEntity player = event.getPlayer();
        if (TravelersBackpackConfig.enableBackpackRightClickUnequip && CapabilityUtils.isWearingBackpack(player) && !world.field_72995_K && player.func_225608_bj_() && event.getHand() == Hand.MAIN_HAND && player.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            TravelersBackpackItem item;
            ItemStack backpackStack = CapabilityUtils.getWearingBackpack(player);
            ItemUseContext context = new ItemUseContext(world, player, Hand.MAIN_HAND, backpackStack, event.getHitVec());
            if (backpackStack.func_77973_b() instanceof TravelersBackpackItem && (item = (TravelersBackpackItem)backpackStack.func_77973_b()).func_195942_a(new BlockItemUseContext(context)) == ActionResultType.func_233537_a_((boolean)world.field_72995_K)) {
                player.func_226292_a_(Hand.MAIN_HAND, true);
                world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.05f, (1.0f + (world.func_201674_k().nextFloat() - world.func_201674_k().nextFloat()) * 0.2f) * 0.7f);
                CapabilityUtils.getCapability(player).ifPresent(ITravelersBackpack::removeWearable);
                if (TravelersBackpack.enableCurios()) {
                    int backpackSlot = (Integer)((ImmutableTriple)CuriosApi.getCuriosHelper().findEquippedCurio((Predicate<ItemStack>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$playerRightClickBlock$0(net.minecraft.item.ItemStack net.minecraft.item.ItemStack ), (Lnet/minecraft/item/ItemStack;)Z)((ItemStack)backpackStack), (LivingEntity)player).get()).middle;
                    CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(iCuriosItemHandler -> iCuriosItemHandler.getStacksHandler(SlotTypePreset.BACK.getIdentifier())).ifPresent(iCurioStacksHandler -> ((ICurioStacksHandler)iCurioStacksHandler.get()).getStacks().setStackInSlot(backpackSlot, ItemStack.field_190927_a));
                }
                CapabilityUtils.synchronise(player);
                CapabilityUtils.synchroniseToOthers(player);
                event.setCanceled(true);
                return;
            }
        }
        if (player.func_225608_bj_() && event.getHand() == Hand.MAIN_HAND && player.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof SleepingBagItem && world.func_175625_s(pos) instanceof TravelersBackpackTileEntity) {
            tileEntity = (TravelersBackpackTileEntity)world.func_175625_s(pos);
            ItemStack oldSleepingBag = tileEntity.getProperSleepingBag(tileEntity.getSleepingBagColor()).func_177230_c().func_199767_j().func_190903_i();
            tileEntity.setSleepingBagColor(ShapedBackpackRecipe.getProperColor((SleepingBagItem)player.func_184586_b(Hand.MAIN_HAND).func_77973_b()));
            if (!world.field_72995_K) {
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177984_a().func_177956_o(), (double)pos.func_177952_p(), (ItemStack)oldSleepingBag);
                stack.func_190918_g(1);
            }
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.0f, (1.0f + (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            player.func_226292_a_(Hand.MAIN_HAND, true);
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (player.func_225608_bj_() && player.func_184586_b(Hand.MAIN_HAND).func_77973_b() == ModItems.BLANK_UPGRADE.get() && world.func_175625_s(pos) instanceof TravelersBackpackTileEntity && (tileEntity = (TravelersBackpackTileEntity)world.func_175625_s(pos)).getTier() != Tiers.LEATHER) {
            int fluidAmountRight;
            int fluidAmountLeft;
            int storageSlots = tileEntity.getTier().getAllSlots() + 9;
            NonNullList list = NonNullList.func_191196_a();
            for (int i2 = 0; i2 < storageSlots; ++i2) {
                ItemStack stackInSlot = tileEntity.getCombinedInventory().getStackInSlot(i2);
                if (stackInSlot.func_190926_b()) continue;
                list.add((Object)stackInSlot);
                tileEntity.getCombinedInventory().setStackInSlot(i2, ItemStack.field_190927_a);
            }
            list.addAll(TierUpgradeItem.getUpgradesForTier(tileEntity.getTier()));
            if (!tileEntity.getSlotManager().getUnsortableSlots().isEmpty()) {
                tileEntity.getSlotManager().getUnsortableSlots().removeIf(i -> i > Tiers.LEATHER.getStorageSlots() - 7);
            }
            if (!tileEntity.getSlotManager().getMemorySlots().isEmpty()) {
                tileEntity.getSlotManager().getMemorySlots().removeIf(p -> (Integer)p.getFirst() > Tiers.LEATHER.getStorageSlots() - 7);
            }
            int n = fluidAmountLeft = tileEntity.getLeftTank().isEmpty() ? 0 : tileEntity.getLeftTank().getFluidAmount();
            if (fluidAmountLeft > Tiers.LEATHER.getTankCapacity()) {
                tileEntity.getLeftTank().drain(fluidAmountLeft - Tiers.LEATHER.getTankCapacity(), IFluidHandler.FluidAction.EXECUTE);
            }
            int n2 = fluidAmountRight = tileEntity.getRightTank().isEmpty() ? 0 : tileEntity.getRightTank().getFluidAmount();
            if (fluidAmountRight > Tiers.LEATHER.getTankCapacity()) {
                tileEntity.getRightTank().drain(fluidAmountRight - Tiers.LEATHER.getTankCapacity(), IFluidHandler.FluidAction.EXECUTE);
            }
            if (!world.field_72995_K) {
                InventoryHelper.func_219961_a((World)world, (BlockPos)pos.func_177984_a(), (NonNullList)list);
            }
            tileEntity.resetTier();
            player.func_226292_a_(Hand.MAIN_HAND, true);
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (TravelersBackpackConfig.enableBackpackBlockWearable && event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof TravelersBackpackBlock && player.func_225608_bj_() && !CapabilityUtils.isWearingBackpack(player)) {
            TravelersBackpackTileEntity tile = (TravelersBackpackTileEntity)world.func_175625_s(pos);
            ItemStack backpack = new ItemStack((IItemProvider)event.getWorld().func_180495_p(event.getPos()).func_177230_c(), 1);
            if (!TravelersBackpack.enableCurios()) {
                Direction bagDirection = (Direction)world.func_180495_p(pos).func_177229_b((Property)TravelersBackpackBlock.FACING);
                if (world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P())) {
                    tile.transferToItemStack(backpack);
                    CapabilityUtils.equipBackpack(event.getPlayer(), backpack);
                    player.func_226292_a_(Hand.MAIN_HAND, true);
                    if (tile.isSleepingBagDeployed()) {
                        world.func_175656_a(pos.func_177972_a(bagDirection), Blocks.field_150350_a.func_176223_P());
                        world.func_175656_a(pos.func_177972_a(bagDirection).func_177972_a(bagDirection), Blocks.field_150350_a.func_176223_P());
                    }
                    event.setCancellationResult(ActionResultType.SUCCESS);
                    event.setCanceled(true);
                    return;
                }
            } else {
                tile.transferToItemStack(backpack);
                CuriosApi.getCuriosHelper().getCurio(backpack).ifPresent(curio -> CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
                    Map curios = handler.getCurios();
                    for (Map.Entry entry : curios.entrySet()) {
                        IDynamicStackHandler stackHandler = ((ICurioStacksHandler)entry.getValue()).getStacks();
                        for (int i = 0; i < stackHandler.getSlots(); ++i) {
                            ItemStack present = stackHandler.getStackInSlot(i);
                            Set tags = CuriosApi.getCuriosHelper().getCurioTags(backpack.func_77973_b());
                            String id = (String)entry.getKey();
                            if (!present.func_190926_b() || !tags.contains(id) && !tags.contains(SlotTypePreset.CURIO.getIdentifier()) && (tags.isEmpty() || !id.equals(SlotTypePreset.CURIO.getIdentifier())) || !curio.canEquip(id, (LivingEntity)player)) continue;
                            Direction bagDirection = (Direction)world.func_180495_p(pos).func_177229_b((Property)TravelersBackpackBlock.FACING);
                            if (!world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P())) continue;
                            stackHandler.setStackInSlot(i, backpack.func_77946_l());
                            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.0f, (1.0f + (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                            player.func_226292_a_(Hand.MAIN_HAND, true);
                            if (tile.isSleepingBagDeployed()) {
                                world.func_175656_a(pos.func_177972_a(bagDirection), Blocks.field_150350_a.func_176223_P());
                                world.func_175656_a(pos.func_177972_a(bagDirection).func_177972_a(bagDirection), Blocks.field_150350_a.func_176223_P());
                            }
                            event.setCancellationResult(ActionResultType.SUCCESS);
                            event.setCanceled(true);
                            return;
                        }
                    }
                }));
            }
        }
        if (event.getWorld().field_72995_K || event.getPlayer().func_213453_ef()) {
            return;
        }
        if (stack.func_77973_b() == ModItems.STANDARD_TRAVELERS_BACKPACK.get()) {
            BlockState blockState = event.getWorld().func_180495_p(event.getPos());
            if (BackpackDyeRecipe.hasColor(stack) && blockState.func_177230_c() instanceof CauldronBlock && (Integer)blockState.func_177229_b((Property)CauldronBlock.field_176591_a) > 0) {
                stack.func_77978_p().func_82580_o("Color");
                ((CauldronBlock)blockState.func_177230_c()).func_176590_a(event.getWorld(), event.getPos(), blockState, (Integer)blockState.func_177229_b((Property)CauldronBlock.field_176591_a) - 1);
                event.getWorld().func_184148_a(null, (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177956_o(), SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                event.setCancellationResult(ActionResultType.SUCCESS);
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void blockBlazeProjectile(ProjectileImpactEvent.Fireball event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.blazeAbility(event);
        }
    }

    @SubscribeEvent
    public static void livingChangeTarget(LivingSetAttackTargetEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.ghastAbility(event);
            BackpackAbilities.pumpkinAbility(event);
        }
    }

    @SubscribeEvent
    public static void onHit(AttackEntityEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.beeAbility(event);
        }
    }

    @SubscribeEvent
    public static void onExpPickup(PlayerXpEvent.PickupXp event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.ABILITIES.lapisAbility(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        IEntityTravelersBackpack travelersBackpack;
        LazyOptional<IEntityTravelersBackpack> cap;
        if (event.getEntity() instanceof LivingEntity && TravelersBackpackConfig.spawnEntitiesWithBackpack && (cap = CapabilityUtils.getEntityCapability((LivingEntity)event.getEntity())).isPresent() && Reference.ALLOWED_TYPE_ENTRIES.contains(event.getEntity().func_200600_R()) && !(travelersBackpack = (IEntityTravelersBackpack)cap.resolve().get()).hasWearable() && TimeUtils.randomInBetweenInclusive(event.getWorld().func_201674_k(), 0, TravelersBackpackConfig.spawnChance) == 0) {
            boolean isNether = event.getEntity().func_200600_R() == EntityType.field_233591_ai_ || event.getEntity().func_200600_R() == EntityType.field_200722_aA;
            Random rand = event.getWorld().func_201674_k();
            ItemStack backpack = isNether ? ModItems.COMPATIBLE_NETHER_BACKPACK_ENTRIES.get(TimeUtils.randomInBetweenInclusive(rand, 0, ModItems.COMPATIBLE_NETHER_BACKPACK_ENTRIES.size() - 1)).func_190903_i() : ModItems.COMPATIBLE_OVERWORLD_BACKPACK_ENTRIES.get(TimeUtils.randomInBetweenInclusive(rand, 0, ModItems.COMPATIBLE_OVERWORLD_BACKPACK_ENTRIES.size() - 1)).func_190903_i();
            backpack.func_196082_o().func_74768_a("SleepingBagColor", DyeColor.values()[TimeUtils.randomInBetweenInclusive(rand, 0, DyeColor.values().length - 1)].func_196059_a());
            travelersBackpack.setWearable(backpack);
            travelersBackpack.synchronise();
        }
        if (!(event.getEntity() instanceof ItemEntity) || !TravelersBackpackConfig.invulnerableBackpack) {
            return;
        }
        if (((ItemEntity)event.getEntity()).func_92059_d().func_77973_b() instanceof TravelersBackpackItem) {
            ((ItemEntity)event.getEntity()).func_174873_u();
            event.getEntity().func_184224_h(true);
        }
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object travelersBackpack;
        if (event.getObject() instanceof PlayerEntity) {
            travelersBackpack = new TravelersBackpackWearable((PlayerEntity)event.getObject());
            event.addCapability(TravelersBackpackCapability.ID, TravelersBackpackCapability.createProvider((ITravelersBackpack)travelersBackpack));
        }
        if (event.getObject() instanceof LivingEntity && Reference.ALLOWED_TYPE_ENTRIES.contains(((LivingEntity)event.getObject()).func_200600_R())) {
            travelersBackpack = new TravelersBackpackEntityWearable((LivingEntity)event.getObject());
            event.addCapability(TravelersBackpackEntityCapability.ID, TravelersBackpackEntityCapability.createProvider((IEntityTravelersBackpack)travelersBackpack));
        }
    }

    @SubscribeEvent
    public static void playerDeath(LivingDeathEvent event) {
        PlayerEntity player;
        if (event.getEntity() instanceof PlayerEntity && CapabilityUtils.isWearingBackpack(player = (PlayerEntity)event.getEntity())) {
            if (TravelersBackpackConfig.enableBackpackAbilities && BackpackAbilities.creeperAbility(event)) {
                return;
            }
            if (TravelersBackpack.isAnyGraveModInstalled()) {
                return;
            }
            if (!player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c)) {
                BackpackUtils.onPlayerDeath(player.field_70170_p, player, CapabilityUtils.getWearingBackpack(player));
            }
            CapabilityUtils.synchronise((PlayerEntity)event.getEntity());
        }
        if (Reference.ALLOWED_TYPE_ENTRIES.contains(event.getEntityLiving().func_200600_R()) && CapabilityUtils.isWearingBackpack(event.getEntityLiving())) {
            event.getEntity().func_199701_a_(CapabilityUtils.getWearingBackpack(event.getEntityLiving()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerDrops(LivingDropsEvent event) {
        if (TravelersBackpack.isAnyGraveModInstalled() && event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            if (player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c)) {
                return;
            }
            if (CapabilityUtils.isWearingBackpack(player) && !player.field_70170_p.field_72995_K) {
                ItemStack stack = CapabilityUtils.getWearingBackpack(player);
                ItemEntity itemEntity = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), stack);
                event.getDrops().add(itemEntity);
                CapabilityUtils.getCapability(player).ifPresent(ITravelersBackpack::removeWearable);
                CapabilityUtils.synchronise(player);
            }
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        CapabilityUtils.getCapability(event.getOriginal()).ifPresent(oldTravelersBackpack -> CapabilityUtils.getCapability(event.getPlayer()).ifPresent(newTravelersBackpack -> {
            newTravelersBackpack.setWearable(oldTravelersBackpack.getWearable());
            newTravelersBackpack.setContents(oldTravelersBackpack.getWearable());
        }));
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        CapabilityUtils.synchronise(event.getPlayer());
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        CapabilityUtils.synchronise(event.getPlayer());
    }

    @SubscribeEvent
    public static void entityJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            CapabilityUtils.synchronise((PlayerEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void playerTracking(PlayerEvent.StartTracking event) {
        ServerPlayerEntity target;
        if (event.getTarget() instanceof PlayerEntity && !event.getTarget().field_70170_p.field_72995_K) {
            target = (ServerPlayerEntity)event.getTarget();
            CapabilityUtils.getCapability((PlayerEntity)target).ifPresent(c -> TravelersBackpack.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new CSyncCapabilityPacket(target.func_145782_y(), true, CapabilityUtils.getWearingBackpack((PlayerEntity)target).func_77955_b(new CompoundNBT()))));
        }
        if (Reference.ALLOWED_TYPE_ENTRIES.contains(event.getTarget().func_200600_R()) && !event.getTarget().field_70170_p.field_72995_K) {
            target = (LivingEntity)event.getTarget();
            CapabilityUtils.getEntityCapability((LivingEntity)target).ifPresent(arg_0 -> ForgeEventHandler.lambda$playerTracking$12(event, (LivingEntity)target, arg_0));
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities && event.phase == TickEvent.Phase.END && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, CapabilityUtils.getWearingBackpack(event.player))) {
            TravelersBackpackInventory.abilityTick(event.player);
            if (!checkAbilitiesForRemoval && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_REMOVAL_LIST, CapabilityUtils.getWearingBackpack(event.player))) {
                checkAbilitiesForRemoval = true;
            }
        }
        if (!(!checkAbilitiesForRemoval || event.phase != TickEvent.Phase.END || event.player.field_70170_p.field_72995_K || CapabilityUtils.isWearingBackpack(event.player) && TravelersBackpackConfig.enableBackpackAbilities)) {
            BackpackAbilities.ABILITIES.armorAbilityRemovals(event.player);
            checkAbilitiesForRemoval = false;
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !TravelersBackpackConfig.tooManyBackpacksSlowness || nextBackpackCountCheck > event.world.func_82737_E()) {
            return;
        }
        nextBackpackCountCheck = event.world.func_82737_E() + 100L;
        event.world.func_217369_A().forEach(player -> {
            AtomicInteger numberOfBackpacks = ForgeEventHandler.checkBackpacksForSlowness(player);
            if (numberOfBackpacks.get() == 0) {
                return;
            }
            int maxNumberOfBackpacks = TravelersBackpackConfig.maxNumberOfBackpacks;
            if (numberOfBackpacks.get() > maxNumberOfBackpacks) {
                int numberOfSlownessLevels = Math.min(10, (int)Math.ceil((double)(numberOfBackpacks.get() - maxNumberOfBackpacks) * TravelersBackpackConfig.slownessPerExcessedBackpack));
                player.func_195064_c(new EffectInstance(Effects.field_76421_d, 200, numberOfSlownessLevels - 1, false, false));
            }
        });
    }

    public static AtomicInteger checkBackpacksForSlowness(PlayerEntity player) {
        AtomicInteger atomic = new AtomicInteger(0);
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            if (!(((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77973_b() instanceof TravelersBackpackItem)) continue;
            atomic.incrementAndGet();
        }
        if (((ItemStack)player.field_71071_by.field_184439_c.get(0)).func_77973_b() instanceof TravelersBackpackItem) {
            atomic.incrementAndGet();
        }
        return atomic;
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        new AccessBackpackCommand((CommandDispatcher<CommandSource>)event.getDispatcher());
        new RestoreBackpackCommand((CommandDispatcher<CommandSource>)event.getDispatcher());
        new ClearBackpackCommand((CommandDispatcher<CommandSource>)event.getDispatcher());
        new UnpackBackpackCommand((CommandDispatcher<CommandSource>)event.getDispatcher());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    @SubscribeEvent
    public static void explosionDetonate(ExplosionEvent.Detonate event) {
        for (int i = 0; i < event.getAffectedEntities().size(); ++i) {
            Entity entity = (Entity)event.getAffectedEntities().get(i);
            if (!(entity instanceof ItemEntity) || !(((ItemEntity)entity).func_92059_d().func_77973_b() instanceof TravelersBackpackItem)) continue;
            event.getAffectedEntities().remove(i);
        }
    }

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent event) {
        if (TravelersBackpackConfig.enableLoot) {
            if (event.getName().equals((Object)LootTables.field_186424_f)) {
                event.getTable().addPool(LootPool.func_216096_a().name("abandoned_mineshaft_bat").func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)ResourceUtils.create("chests/bat"))).func_216044_b());
                event.getTable().addPool(LootPool.func_216096_a().name("abandoned_mineshaft_inject").func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)ResourceUtils.create("chests/abandoned_mineshaft_inject"))).func_216044_b());
            }
            if (event.getName().equals((Object)LootTables.field_215816_g)) {
                event.getTable().addPool(LootPool.func_216096_a().name("village_armorer_iron_golem").func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)ResourceUtils.create("chests/iron_golem"))).func_216044_b());
            }
            if (event.getName().equals((Object)LootTables.field_186422_d)) {
                event.getTable().addPool(LootPool.func_216096_a().name("simple_dungeon_inject").func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)ResourceUtils.create("chests/simple_dungeon_inject"))).func_216044_b());
            }
            if (event.getName().equals((Object)LootTables.field_186429_k)) {
                event.getTable().addPool(LootPool.func_216096_a().name("desert_pyramid_inject").func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)ResourceUtils.create("chests/desert_pyramid_inject"))).func_216044_b());
            }
            if (event.getName().equals((Object)LootTables.field_204773_u)) {
                event.getTable().addPool(LootPool.func_216096_a().name("shipwreck_treasure_inject").func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)ResourceUtils.create("chests/shipwreck_treasure_inject"))).func_216044_b());
            }
            if (event.getName().equals((Object)LootTables.field_191192_o)) {
                event.getTable().addPool(LootPool.func_216096_a().name("woodland_mansion_inject").func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)ResourceUtils.create("chests/woodland_mansion_inject"))).func_216044_b());
            }
            if (event.getName().equals((Object)LootTables.field_186425_g)) {
                event.getTable().addPool(LootPool.func_216096_a().name("nether_bridge_inject").func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)ResourceUtils.create("chests/nether_bridge_inject"))).func_216044_b());
            }
            if (event.getName().equals((Object)LootTables.field_237380_L_)) {
                event.getTable().addPool(LootPool.func_216096_a().name("bastion_treasure_inject").func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)ResourceUtils.create("chests/bastion_treasure_inject"))).func_216044_b());
            }
            if (event.getName().equals((Object)LootTables.field_186421_c)) {
                event.getTable().addPool(LootPool.func_216096_a().name("end_city_treasure_inject").func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)ResourceUtils.create("chests/end_city_treasure_inject"))).func_216044_b());
            }
        }
    }

    @SubscribeEvent
    public static void addVillagerTrade(VillagerTradesEvent event) {
        if (TravelersBackpackConfig.enableVillagerTrade && event.getType() == VillagerProfession.field_221160_j) {
            ((List)event.getTrades().get(3)).add((trader, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, random.nextInt(64) + 48), new ItemStack((IItemProvider)((Item)ModItems.VILLAGER_TRAVELERS_BACKPACK.get()).func_199767_j(), 1), 1, 50, 0.5f));
        }
    }

    private static /* synthetic */ void lambda$playerTracking$12(PlayerEvent.StartTracking event, LivingEntity target, IEntityTravelersBackpack c) {
        TravelersBackpack.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getEntity()), (Object)new CSyncCapabilityPacket(target.func_145782_y(), false, CapabilityUtils.getWearingBackpack(target).func_77955_b(new CompoundNBT())));
    }

    private static /* synthetic */ boolean lambda$playerRightClickBlock$0(ItemStack backpackStack, ItemStack p) {
        return ItemStack.func_77989_b((ItemStack)p, (ItemStack)backpackStack);
    }
}

