/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.fluids;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class PotionAttributes
extends FluidAttributes {
    private static final int EMPTY_COLOR = 0xF800F8;

    protected PotionAttributes(FluidAttributes.Builder builder, Fluid fluid) {
        super(builder, fluid);
    }

    public String getTranslationKey() {
        return "item.minecraft.potion.effect.empty";
    }

    public String getTranslationKey(FluidStack stack) {
        return PotionUtils.func_185187_c((CompoundNBT)stack.getTag()).func_185174_b("item.minecraft.potion.effect.");
    }

    public TextComponent getDisplayName(FluidStack stack) {
        return new TranslationTextComponent(this.getTranslationKey(stack));
    }

    public int getColor() {
        return -524040;
    }

    public int getColor(FluidStack stack) {
        return PotionAttributes.getColor(stack.getTag()) | 0xFF000000;
    }

    private static int getColor(@Nullable CompoundNBT compoundNBT) {
        if (compoundNBT != null && compoundNBT.func_150297_b("CustomPotionColor", 99)) {
            return compoundNBT.func_74762_e("CustomPotionColor");
        }
        if (PotionUtils.func_185187_c((CompoundNBT)compoundNBT) == Potions.field_185229_a) {
            return 0xF800F8;
        }
        return PotionUtils.func_185181_a((Collection)PotionUtils.func_185185_a((CompoundNBT)compoundNBT));
    }

    public static class PotionBuilder
    extends FluidAttributes.Builder {
        public PotionBuilder(ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(stillTexture, flowingTexture, PotionAttributes::new);
        }
    }
}

