/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.curios;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.compat.curios.TravelersBackpackCurio;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class TravelersBackpackCurios {
    public static ICurio createBackpackProvider() {
        return new TravelersBackpackCurio();
    }

    public static Optional<ImmutableTriple<String, Integer, ItemStack>> getCurioTravelersBackpack(LivingEntity livingEntity) {
        Predicate<ItemStack> backpack = stack -> stack.func_77973_b() instanceof TravelersBackpackItem;
        return CuriosApi.getCuriosHelper().findEquippedCurio(backpack, livingEntity);
    }

    public static ItemStack getCurioTravelersBackpackStack(PlayerEntity player) {
        if (TravelersBackpackCurios.getCurioTravelersBackpack((LivingEntity)player).isPresent()) {
            return (ItemStack)TravelersBackpackCurios.getCurioTravelersBackpack((LivingEntity)player).get().getRight();
        }
        return ItemStack.field_190927_a;
    }

    public static TravelersBackpackInventory getCurioTravelersBackpackInventory(PlayerEntity player) {
        TravelersBackpackInventory curioInventory = CapabilityUtils.getCapability(player).map(ITravelersBackpack::getInventory).orElse(null);
        if (curioInventory.getItemStack() != TravelersBackpackCurios.getCurioTravelersBackpackStack(player)) {
            curioInventory.setStack(TravelersBackpackCurios.getCurioTravelersBackpackStack(player));
            curioInventory.loadAllData(TravelersBackpackCurios.getCurioTravelersBackpackStack(player).func_196082_o());
        }
        return curioInventory;
    }
}

