/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.SmithingRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BackpackUpgradeRecipe
extends SmithingRecipe {
    final Ingredient field_234837_a_;
    final Ingredient field_234838_b_;
    final ItemStack field_234839_c_;

    public BackpackUpgradeRecipe(ResourceLocation id, Ingredient base, Ingredient addition, ItemStack result) {
        super(id, base, addition, result);
        this.field_234837_a_ = base;
        this.field_234838_b_ = addition;
        this.field_234839_c_ = result;
    }

    public ItemStack func_77572_b(IInventory inventory) {
        ItemStack itemstack = this.field_234839_c_.func_77946_l();
        CompoundNBT compoundtag = inventory.func_70301_a(0).func_77978_p();
        if (compoundtag != null) {
            if ((compoundtag = compoundtag.func_74737_b()).func_74764_b("Tier")) {
                Tiers.Tier tier = Tiers.of(compoundtag.func_74762_e("Tier"));
                if (this.field_234838_b_.test(Tiers.of(compoundtag.func_74762_e("Tier")).getTierUpgradeIngredient().func_190903_i())) {
                    compoundtag.func_74768_a("Tier", tier.getNextTier().getOrdinal());
                    itemstack.func_77982_d(compoundtag.func_74737_b());
                    return itemstack;
                }
            } else if (this.field_234838_b_.test(Tiers.LEATHER.getTierUpgradeIngredient().func_190903_i())) {
                compoundtag.func_74768_a("Tier", Tiers.LEATHER.getNextTier().getOrdinal());
                itemstack.func_77982_d(compoundtag.func_74737_b());
                return itemstack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_77569_a(IInventory pInv, World pLevel) {
        return TravelersBackpackConfig.enableTierUpgrades && super.func_77569_a(pInv, pLevel);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeSerializers.BACKPACK_UPGRADE.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<BackpackUpgradeRecipe> {
        public BackpackUpgradeRecipe fromJson(ResourceLocation id, JsonObject jsonObject) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)jsonObject, (String)"base"));
            Ingredient ingredient1 = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)jsonObject, (String)"addition"));
            ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)jsonObject, (String)"result"));
            return new BackpackUpgradeRecipe(id, ingredient, ingredient1, itemstack);
        }

        public BackpackUpgradeRecipe fromNetwork(ResourceLocation id, PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient ingredient1 = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack itemstack = buffer.func_150791_c();
            return new BackpackUpgradeRecipe(id, ingredient, ingredient1, itemstack);
        }

        public void toNetwork(PacketBuffer buffer, BackpackUpgradeRecipe recipe) {
            recipe.field_234837_a_.func_199564_a(buffer);
            recipe.field_234838_b_.func_199564_a(buffer);
            buffer.func_150788_a(recipe.field_234839_c_);
        }
    }
}

