/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackItemContainer;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackTileContainer;
import com.tiviacz.travelersbackpack.inventory.sorter.InventorySorter;
import com.tiviacz.travelersbackpack.items.HoseItem;
import com.tiviacz.travelersbackpack.tileentity.TravelersBackpackTileEntity;
import com.tiviacz.travelersbackpack.util.FluidUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;

public class ServerActions {
    public static void swapTool(PlayerEntity player, double scrollDelta) {
        if (CapabilityUtils.isWearingBackpack(player)) {
            TravelersBackpackInventory inventory = CapabilityUtils.getBackpackInv(player);
            ItemStackHandler inv = inventory.getInventory();
            ItemStack heldItem = player.func_184614_ca();
            int toolSlots = inventory.getTier().getToolSlots();
            int firstSlot = inventory.getTier().getSlotIndex(Tiers.SlotType.TOOL_FIRST);
            int lastSlot = firstSlot + (toolSlots - 1);
            int j = 0;
            for (int i = firstSlot; i <= lastSlot; ++i) {
                if (inv.getStackInSlot(i).func_190926_b()) continue;
                ++j;
            }
            ItemStack[] tools = new ItemStack[j];
            if (scrollDelta < 0.0) {
                int i;
                int slot = 0;
                for (int i2 = firstSlot; i2 <= firstSlot + j - 1; ++i2) {
                    tools[slot] = inv.getStackInSlot(i2).func_77946_l();
                    ++slot;
                }
                ItemStack tempStack = tools[tools.length - 1];
                for (i = tools.length - 1; i >= 0; --i) {
                    if (i - 1 < 0) {
                        tools[0] = heldItem;
                        player.func_184611_a(Hand.MAIN_HAND, tempStack);
                        continue;
                    }
                    tools[i] = tools[i - 1];
                }
                slot = 0;
                for (i = firstSlot; i <= firstSlot + j - 1; ++i) {
                    inv.setStackInSlot(i, tools[slot]);
                    ++slot;
                }
            } else if (scrollDelta > 0.0) {
                int i;
                int slot = 0;
                for (int i3 = firstSlot; i3 <= firstSlot + j - 1; ++i3) {
                    tools[slot] = inv.getStackInSlot(i3).func_77946_l();
                    ++slot;
                }
                ItemStack tempStack = tools[0];
                for (i = 0; i <= tools.length - 1; ++i) {
                    if (i + 1 > tools.length - 1) {
                        tools[tools.length - 1] = heldItem;
                        player.func_184611_a(Hand.MAIN_HAND, tempStack);
                        continue;
                    }
                    tools[i] = tools[i + 1];
                }
                slot = 0;
                for (i = firstSlot; i <= firstSlot + j - 1; ++i) {
                    inv.setStackInSlot(i, tools[slot]);
                    ++slot;
                }
            }
            inventory.setDataChanged(0);
        }
    }

    public static void equipBackpack(PlayerEntity player) {
        LazyOptional<ITravelersBackpack> cap = CapabilityUtils.getCapability(player);
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            if (!cap.map(ITravelersBackpack::hasWearable).orElse(false).booleanValue()) {
                if (player.field_71070_bA instanceof TravelersBackpackItemContainer) {
                    player.field_71070_bA.func_75134_a(player);
                }
                ItemStack stack = player.func_184614_ca().func_77946_l();
                cap.ifPresent(inv -> inv.setWearable(stack));
                cap.ifPresent(inv -> inv.setContents(stack));
                player.func_184614_ca().func_190918_g(1);
                world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                CapabilityUtils.synchronise(player);
                CapabilityUtils.synchroniseToOthers(player);
            }
            player.func_71053_j();
        }
    }

    public static void unequipBackpack(PlayerEntity player) {
        LazyOptional<ITravelersBackpack> cap = CapabilityUtils.getCapability(player);
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            ItemStack wearable;
            if (player.field_71070_bA instanceof TravelersBackpackItemContainer) {
                player.field_71070_bA.func_75134_a(player);
            }
            if (!player.field_71071_by.func_70441_a(wearable = cap.map(ITravelersBackpack::getWearable).orElse(ItemStack.field_190927_a).func_77946_l())) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("action.travelersbackpack.unequip_nospace"), player.func_110124_au());
                player.func_71053_j();
                return;
            }
            if (cap.map(ITravelersBackpack::hasWearable).orElse(false).booleanValue()) {
                cap.ifPresent(ITravelersBackpack::removeWearable);
                world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.05f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                CapabilityUtils.synchronise(player);
                CapabilityUtils.synchroniseToOthers(player);
            }
            player.func_71053_j();
        }
    }

    public static void switchAbilitySlider(PlayerEntity player, boolean sliderValue) {
        TravelersBackpackInventory inv = CapabilityUtils.getBackpackInv(player);
        inv.setAbility(sliderValue);
        inv.setDataChanged(6, 3);
        if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_REMOVAL_LIST, inv.getItemStack()) && !sliderValue) {
            BackpackAbilities.ABILITIES.abilityRemoval(inv.getItemStack(), player);
        }
        if (inv.getItemStack().func_77973_b() == ModItems.CHICKEN_TRAVELERS_BACKPACK.get() && inv.getLastTime() <= 0) {
            BackpackAbilities.ABILITIES.chickenAbility(player, true);
        }
    }

    public static void switchAbilitySliderTileEntity(PlayerEntity player, BlockPos pos, boolean sliderValue) {
        if (player.field_70170_p.func_175625_s(pos) instanceof TravelersBackpackTileEntity) {
            TravelersBackpackTileEntity blockEntity = (TravelersBackpackTileEntity)player.field_70170_p.func_175625_s(pos);
            blockEntity.setAbility(sliderValue);
            blockEntity.setDataChanged();
            blockEntity.func_145831_w().func_195593_d(pos, blockEntity.func_195044_w().func_177230_c());
            if (blockEntity.func_195044_w().func_177230_c() == ModBlocks.SPONGE_TRAVELERS_BACKPACK.get()) {
                ((TravelersBackpackBlock)blockEntity.func_195044_w().func_177230_c()).tryAbsorbWater(blockEntity.func_145831_w(), pos);
            }
        }
    }

    public static void sortBackpack(PlayerEntity player, byte screenID, byte button, boolean shiftPressed) {
        if (screenID == 3 && player.field_71070_bA instanceof TravelersBackpackTileContainer) {
            if (player.field_70170_p.func_175625_s(((TravelersBackpackTileContainer)player.field_71070_bA).inventory.getPosition()) instanceof TravelersBackpackTileEntity) {
                InventorySorter.selectSort(((TravelersBackpackTileContainer)player.field_71070_bA).inventory, player, button, shiftPressed);
            }
        } else if (screenID == 1) {
            if (player.field_71070_bA instanceof TravelersBackpackItemContainer) {
                InventorySorter.selectSort(((TravelersBackpackItemContainer)player.field_71070_bA).inventory, player, button, shiftPressed);
            }
        } else if (screenID == 2) {
            InventorySorter.selectSort(CapabilityUtils.getBackpackInv(player), player, button, shiftPressed);
        }
    }

    public static void toggleSleepingBag(PlayerEntity player, BlockPos pos) {
        World world = player.field_70170_p;
        if (world.func_175625_s(pos) instanceof TravelersBackpackTileEntity) {
            TravelersBackpackTileEntity te = (TravelersBackpackTileEntity)world.func_175625_s(pos);
            if (!te.isSleepingBagDeployed()) {
                if (te.deploySleepingBag(world, pos)) {
                    player.func_71053_j();
                } else {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("action.travelersbackpack.deploy_sleeping_bag"), player.func_110124_au());
                }
            } else {
                te.removeSleepingBag(world);
            }
            player.func_71053_j();
        }
    }

    public static void emptyTank(double tankType, PlayerEntity player, World world, byte screenID) {
        FluidTank tank;
        ITravelersBackpackInventory inv = null;
        if (screenID == 2) {
            inv = CapabilityUtils.getBackpackInv(player);
        }
        if (screenID == 1) {
            inv = ((TravelersBackpackItemContainer)player.field_71070_bA).inventory;
        }
        if (screenID == 3) {
            inv = ((TravelersBackpackTileContainer)player.field_71070_bA).inventory;
        }
        if (inv == null) {
            return;
        }
        FluidTank fluidTank = tank = tankType == 1.0 ? inv.getLeftTank() : inv.getRightTank();
        if (!world.field_72995_K) {
            world.func_184133_a(null, player.func_233580_cy_(), FluidUtils.getFluidEmptySound(tank.getFluid().getFluid()), SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        tank.drain(inv.getTier().getTankCapacity(), IFluidHandler.FluidAction.EXECUTE);
        inv.setDataChanged(3);
    }

    public static boolean setFluidEffect(World world, PlayerEntity player, FluidTank tank) {
        FluidStack fluidStack = tank.getFluid();
        boolean done = false;
        if (EffectFluidRegistry.hasExecutableEffects(fluidStack, world, (Entity)player)) {
            done = EffectFluidRegistry.executeEffects(fluidStack, (Entity)player, world);
        }
        return done;
    }

    public static void switchHoseMode(PlayerEntity player, double scrollDelta) {
        ItemStack hose = player.func_184614_ca();
        if (hose.func_77973_b() instanceof HoseItem && hose.func_77978_p() != null) {
            int mode = HoseItem.getHoseMode(hose);
            if (scrollDelta > 0.0) {
                if (++mode == 4) {
                    mode = 1;
                }
            } else if (scrollDelta < 0.0 && --mode == 0) {
                mode = 3;
            }
            hose.func_77978_p().func_74768_a("Mode", mode);
        }
    }

    public static void toggleHoseTank(PlayerEntity player) {
        ItemStack hose = player.func_184614_ca();
        if (hose.func_77973_b() instanceof HoseItem && hose.func_77978_p() != null) {
            int tank = HoseItem.getHoseTank(hose);
            tank = tank == 1 ? 2 : 1;
            hose.func_77978_p().func_74768_a("Tank", tank);
        }
    }
}

