/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.util.LogHelper;
import java.io.File;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;

public class BackpackManager {
    public static FolderName BACKPACKS = new FolderName("backpacks");

    public static void addBackpack(ServerPlayerEntity player, ItemStack stack) {
        try {
            UUID randomBackpackUUID = UUID.randomUUID();
            File backpackFile = BackpackManager.getBackpackFile(player, randomBackpackUUID);
            backpackFile.getParentFile().mkdirs();
            CompressedStreamTools.func_74795_b((CompoundNBT)stack.func_77955_b(new CompoundNBT()), (File)backpackFile);
            LogHelper.info("Created new backpack backup file for " + player.func_145748_c_().getString() + " with unique ID " + randomBackpackUUID, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static ItemStack getBackpack(ServerPlayerEntity player, UUID id) {
        return BackpackManager.getBackpack(player.func_71121_q(), player.func_110124_au(), id);
    }

    @Nullable
    public static ItemStack getBackpack(ServerWorld world, UUID playerUUID, UUID id) {
        try {
            CompoundNBT data = CompressedStreamTools.func_74797_a((File)BackpackManager.getBackpackFile(world, playerUUID, id));
            if (data == null) {
                return null;
            }
            return ItemStack.func_199557_a((CompoundNBT)data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static ItemStack getBackpack(File file) {
        try {
            CompoundNBT data = CompressedStreamTools.func_74797_a((File)file);
            if (data == null) {
                return null;
            }
            return ItemStack.func_199557_a((CompoundNBT)data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static ItemStack getBackpack(ServerWorld world, UUID id) {
        File deathFolder = BackpackManager.getBackpackFolder(world);
        File[] players = deathFolder.listFiles((dir, name) -> name.matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$"));
        if (players == null) {
            return null;
        }
        for (File f : players) {
            File[] files;
            if (!f.isDirectory() || (files = f.listFiles((dir, name) -> name.equals(id.toString() + ".dat"))) == null || files.length <= 0) continue;
            return BackpackManager.getBackpack(world, UUID.fromString(f.getName()), id);
        }
        return null;
    }

    public static File getBackpackFile(ServerWorld world, UUID playerUUID, UUID id) {
        return new File(BackpackManager.getPlayerBackpackFolder(world, playerUUID), id.toString() + ".dat");
    }

    public static File getBackpackFile(ServerPlayerEntity player, UUID id) {
        return new File(BackpackManager.getPlayerBackpackFolder(player), id.toString() + ".dat");
    }

    public static File getPlayerBackpackFolder(ServerPlayerEntity player) {
        return BackpackManager.getPlayerBackpackFolder(player.func_71121_q(), player.func_110124_au());
    }

    public static File getPlayerBackpackFolder(ServerWorld world, UUID uuid) {
        return new File(BackpackManager.getBackpackFolder(world), uuid.toString());
    }

    public static File getBackpackFolder(ServerWorld world) {
        return BackpackManager.getWorldFolder(world, BACKPACKS);
    }

    public static File getWorldFolder(ServerWorld serverWorld, FolderName folderName) {
        return serverWorld.func_73046_m().func_240776_a_(folderName).toFile();
    }
}

