/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import com.tiviacz.travelersbackpack.tileentity.TravelersBackpackTileEntity;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import com.tiviacz.travelersbackpack.util.TimeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class BackpackAbilities {
    public static final BackpackAbilities ABILITIES = new BackpackAbilities();
    public final AttributeModifier NETHERITE_ARMOR_MODIFIER = new AttributeModifier(UUID.fromString("49d951a4-ca9c-48b5-b549-61ef67ee53aa"), "NetheriteBackpackBonusArmor", 4.0, AttributeModifier.Operation.ADDITION);
    public final AttributeModifier DIAMOND_ARMOR_MODIFIER = new AttributeModifier(UUID.fromString("294425c4-8dc6-4640-a336-d9fd72950e20"), "DiamondBackpackBonusArmor", 3.0, AttributeModifier.Operation.ADDITION);
    public final AttributeModifier IRON_ARMOR_MODIFIER = new AttributeModifier(UUID.fromString("fcf6706b-dfd9-40d6-aa25-62c4fb7a83fa"), "IronBackpackBonusArmor", 2.0, AttributeModifier.Operation.ADDITION);
    public final AttributeModifier GOLD_ARMOR_MODIFIER = new AttributeModifier(UUID.fromString("21060f97-da7a-4460-a4e4-c94fae72ab00"), "GoldBackpackBonusArmor", 2.0, AttributeModifier.Operation.ADDITION);
    public final AttributeModifier ENDERMAN_REACH_DISTANCE_MODIFIER = new AttributeModifier(UUID.fromString("a3d7a647-1ed9-4317-94c2-ca889cd33657"), "EndermanReachDistanceBonus", 1.0, AttributeModifier.Operation.ADDITION);
    private static final EntityPredicate OCELOT_ABILITY_PREDICATE = new EntityPredicate().func_221013_a(6.0);
    public static final List<Item> ALLOWED_ABILITIES = new ArrayList<Item>();
    public static final Item[] ALL_ABILITIES_LIST = new Item[]{(Item)ModItems.NETHERITE_TRAVELERS_BACKPACK.get(), (Item)ModItems.DIAMOND_TRAVELERS_BACKPACK.get(), (Item)ModItems.GOLD_TRAVELERS_BACKPACK.get(), (Item)ModItems.EMERALD_TRAVELERS_BACKPACK.get(), (Item)ModItems.IRON_TRAVELERS_BACKPACK.get(), (Item)ModItems.LAPIS_TRAVELERS_BACKPACK.get(), (Item)ModItems.REDSTONE_TRAVELERS_BACKPACK.get(), (Item)ModItems.BOOKSHELF_TRAVELERS_BACKPACK.get(), (Item)ModItems.SPONGE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CAKE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CACTUS_TRAVELERS_BACKPACK.get(), (Item)ModItems.MELON_TRAVELERS_BACKPACK.get(), (Item)ModItems.PUMPKIN_TRAVELERS_BACKPACK.get(), (Item)ModItems.CREEPER_TRAVELERS_BACKPACK.get(), (Item)ModItems.DRAGON_TRAVELERS_BACKPACK.get(), (Item)ModItems.ENDERMAN_TRAVELERS_BACKPACK.get(), (Item)ModItems.BLAZE_TRAVELERS_BACKPACK.get(), (Item)ModItems.GHAST_TRAVELERS_BACKPACK.get(), (Item)ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK.get(), (Item)ModItems.SPIDER_TRAVELERS_BACKPACK.get(), (Item)ModItems.WITHER_TRAVELERS_BACKPACK.get(), (Item)ModItems.BAT_TRAVELERS_BACKPACK.get(), (Item)ModItems.BEE_TRAVELERS_BACKPACK.get(), (Item)ModItems.OCELOT_TRAVELERS_BACKPACK.get(), (Item)ModItems.COW_TRAVELERS_BACKPACK.get(), (Item)ModItems.CHICKEN_TRAVELERS_BACKPACK.get(), (Item)ModItems.SQUID_TRAVELERS_BACKPACK.get()};
    public static final Item[] ITEM_ABILITIES_LIST = new Item[]{(Item)ModItems.NETHERITE_TRAVELERS_BACKPACK.get(), (Item)ModItems.DIAMOND_TRAVELERS_BACKPACK.get(), (Item)ModItems.GOLD_TRAVELERS_BACKPACK.get(), (Item)ModItems.EMERALD_TRAVELERS_BACKPACK.get(), (Item)ModItems.IRON_TRAVELERS_BACKPACK.get(), (Item)ModItems.LAPIS_TRAVELERS_BACKPACK.get(), (Item)ModItems.CAKE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CACTUS_TRAVELERS_BACKPACK.get(), (Item)ModItems.PUMPKIN_TRAVELERS_BACKPACK.get(), (Item)ModItems.CREEPER_TRAVELERS_BACKPACK.get(), (Item)ModItems.DRAGON_TRAVELERS_BACKPACK.get(), (Item)ModItems.ENDERMAN_TRAVELERS_BACKPACK.get(), (Item)ModItems.BLAZE_TRAVELERS_BACKPACK.get(), (Item)ModItems.GHAST_TRAVELERS_BACKPACK.get(), (Item)ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK.get(), (Item)ModItems.SPIDER_TRAVELERS_BACKPACK.get(), (Item)ModItems.WITHER_TRAVELERS_BACKPACK.get(), (Item)ModItems.BAT_TRAVELERS_BACKPACK.get(), (Item)ModItems.BEE_TRAVELERS_BACKPACK.get(), (Item)ModItems.OCELOT_TRAVELERS_BACKPACK.get(), (Item)ModItems.COW_TRAVELERS_BACKPACK.get(), (Item)ModItems.CHICKEN_TRAVELERS_BACKPACK.get(), (Item)ModItems.SQUID_TRAVELERS_BACKPACK.get()};
    public static final Item[] ITEM_ABILITIES_REMOVAL_LIST = new Item[]{(Item)ModItems.NETHERITE_TRAVELERS_BACKPACK.get(), (Item)ModItems.DIAMOND_TRAVELERS_BACKPACK.get(), (Item)ModItems.GOLD_TRAVELERS_BACKPACK.get(), (Item)ModItems.IRON_TRAVELERS_BACKPACK.get(), (Item)ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()};
    public static final Item[] ITEM_TIMER_ABILITIES_LIST = new Item[]{(Item)ModItems.CAKE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CREEPER_TRAVELERS_BACKPACK.get(), (Item)ModItems.COW_TRAVELERS_BACKPACK.get(), (Item)ModItems.CHICKEN_TRAVELERS_BACKPACK.get()};
    public static final Item[] BLOCK_TIMER_ABILITIES_LIST = new Item[]{(Item)ModItems.MELON_TRAVELERS_BACKPACK.get()};
    public static final Item[] BLOCK_ABILITIES_LIST = new Item[]{(Item)ModItems.EMERALD_TRAVELERS_BACKPACK.get(), (Item)ModItems.REDSTONE_TRAVELERS_BACKPACK.get(), (Item)ModItems.BOOKSHELF_TRAVELERS_BACKPACK.get(), (Item)ModItems.SPONGE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CACTUS_TRAVELERS_BACKPACK.get(), (Item)ModItems.MELON_TRAVELERS_BACKPACK.get()};

    public void abilityTick(@Nullable ItemStack stack, @Nullable PlayerEntity player, @Nullable TravelersBackpackTileEntity tile) {
        if (tile == null) {
            if (stack.func_77973_b() == ModItems.NETHERITE_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, Attributes.field_233826_i_, this.NETHERITE_ARMOR_MODIFIER);
            }
            if (stack.func_77973_b() == ModItems.DIAMOND_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, Attributes.field_233826_i_, this.DIAMOND_ARMOR_MODIFIER);
            }
            if (stack.func_77973_b() == ModItems.GOLD_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, Attributes.field_233826_i_, this.GOLD_ARMOR_MODIFIER);
            }
            if (stack.func_77973_b() == ModItems.EMERALD_TRAVELERS_BACKPACK.get()) {
                this.emeraldAbility(player, null);
            }
            if (stack.func_77973_b() == ModItems.IRON_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, Attributes.field_233826_i_, this.IRON_ARMOR_MODIFIER);
            }
            if (stack.func_77973_b() == ModItems.CAKE_TRAVELERS_BACKPACK.get()) {
                this.cakeAbility(player);
            }
            if (stack.func_77973_b() == ModItems.CACTUS_TRAVELERS_BACKPACK.get()) {
                this.cactusAbility(player, null);
            }
            if (stack.func_77973_b() == ModItems.DRAGON_TRAVELERS_BACKPACK.get()) {
                this.dragonAbility(player);
            }
            if (stack.func_77973_b() == ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, (Attribute)ForgeMod.REACH_DISTANCE.get(), this.ENDERMAN_REACH_DISTANCE_MODIFIER);
            }
            if (stack.func_77973_b() == ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, (Attribute)ForgeMod.REACH_DISTANCE.get(), this.ENDERMAN_REACH_DISTANCE_MODIFIER);
            }
            if (stack.func_77973_b() == ModItems.BLAZE_TRAVELERS_BACKPACK.get()) {
                this.blazeAbility(player);
            }
            if (stack.func_77973_b() == ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK.get()) {
                this.magmaCubeAbility(player);
            }
            if (stack.func_77973_b() == ModItems.SPIDER_TRAVELERS_BACKPACK.get()) {
                this.spiderAbility(player);
            }
            if (stack.func_77973_b() == ModItems.WITHER_TRAVELERS_BACKPACK.get()) {
                this.witherAbility(player);
            }
            if (stack.func_77973_b() == ModItems.BAT_TRAVELERS_BACKPACK.get()) {
                this.batAbility(player);
            }
            if (stack.func_77973_b() == ModItems.OCELOT_TRAVELERS_BACKPACK.get()) {
                this.ocelotAbility(player);
            }
            if (stack.func_77973_b() == ModItems.COW_TRAVELERS_BACKPACK.get()) {
                this.cowAbility(player);
            }
            if (stack.func_77973_b() == ModItems.CHICKEN_TRAVELERS_BACKPACK.get()) {
                this.chickenAbility(player, false);
            }
            if (stack.func_77973_b() == ModItems.SQUID_TRAVELERS_BACKPACK.get()) {
                this.squidAbility(player);
            }
        } else {
            Item item = tile.getItemStack().func_77973_b();
            if (item == ModItems.CACTUS_TRAVELERS_BACKPACK.get()) {
                this.cactusAbility(null, tile);
            }
        }
    }

    public void abilityRemoval(@Nullable ItemStack stack, @Nullable PlayerEntity player) {
        if (stack.func_77973_b() == ModItems.NETHERITE_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, Attributes.field_233826_i_, this.NETHERITE_ARMOR_MODIFIER);
        }
        if (stack.func_77973_b() == ModItems.DIAMOND_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, Attributes.field_233826_i_, this.DIAMOND_ARMOR_MODIFIER);
        }
        if (stack.func_77973_b() == ModItems.IRON_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, Attributes.field_233826_i_, this.IRON_ARMOR_MODIFIER);
        }
        if (stack.func_77973_b() == ModItems.GOLD_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, Attributes.field_233826_i_, this.GOLD_ARMOR_MODIFIER);
        }
        if (stack.func_77973_b() == ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, (Attribute)ForgeMod.REACH_DISTANCE.get(), this.ENDERMAN_REACH_DISTANCE_MODIFIER);
        }
    }

    public void animateTick(TravelersBackpackTileEntity tile, BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (tile != null && tile.getAbilityValue()) {
            Block block = stateIn.func_177230_c();
            if (block == ModBlocks.EMERALD_TRAVELERS_BACKPACK.get()) {
                this.emeraldAbility(null, tile);
            }
            if (block == ModBlocks.BOOKSHELF_TRAVELERS_BACKPACK.get()) {
                this.bookshelfAbility(null, tile);
            }
            if (block == ModBlocks.SPONGE_TRAVELERS_BACKPACK.get()) {
                this.spongeAbility(tile);
            }
        }
    }

    public void emeraldAbility(@Nullable PlayerEntity player, @Nullable TravelersBackpackTileEntity tile) {
        World world;
        World world2 = world = player == null ? tile.func_145831_w() : player.field_70170_p;
        if (player == null || world.field_73012_v.nextInt(10) == 1) {
            float f = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            float f1 = world.field_73012_v.nextFloat() * 0.5f + 0.5f;
            float f2 = MathHelper.func_76126_a((float)f) * 0.5f * f1;
            float f3 = MathHelper.func_76134_b((float)f) * 0.5f * f1;
            world.func_195594_a((IParticleData)ParticleTypes.field_197632_y, player == null ? (double)((float)tile.func_174877_v().func_177958_n() + f2 + 0.5f) : player.func_213303_ch().field_72450_a + (double)f2, player == null ? (double)((float)tile.func_174877_v().func_177956_o() + world.field_73012_v.nextFloat()) : player.func_174813_aQ().field_72338_b + (double)world.field_73012_v.nextFloat() + 0.5, player == null ? (double)((float)tile.func_174877_v().func_177952_p() + f3 + 0.5f) : player.func_213303_ch().field_72449_c + (double)f3, (double)((float)Math.pow(2.0, (double)(world.field_73012_v.nextInt(169) - 12) / 12.0)) / 24.0, -1.0, 0.0);
        }
    }

    public void attributeAbility(PlayerEntity player, boolean isRemoval, Attribute attribute, AttributeModifier modifier) {
        ModifiableAttributeInstance armor = player.func_110148_a(attribute);
        if (isRemoval && armor != null && armor.func_180374_a(modifier)) {
            armor.func_233770_c_(modifier.func_111167_a());
        }
        if (!isRemoval && armor != null && !armor.func_180374_a(modifier)) {
            armor.func_233769_c_(modifier);
        }
    }

    public void armorAbilityRemovals(PlayerEntity player) {
        this.attributeAbility(player, true, Attributes.field_233826_i_, this.NETHERITE_ARMOR_MODIFIER);
        this.attributeAbility(player, true, Attributes.field_233826_i_, this.DIAMOND_ARMOR_MODIFIER);
        this.attributeAbility(player, true, Attributes.field_233826_i_, this.IRON_ARMOR_MODIFIER);
        this.attributeAbility(player, true, Attributes.field_233826_i_, this.GOLD_ARMOR_MODIFIER);
        this.attributeAbility(player, true, (Attribute)ForgeMod.REACH_DISTANCE.get(), this.ENDERMAN_REACH_DISTANCE_MODIFIER);
    }

    public void lapisAbility(PlayerEntity player) {
        if (ABILITIES.checkBackpack(player, (Item)ModItems.LAPIS_TRAVELERS_BACKPACK.get())) {
            int number = player.func_70681_au().nextInt(2);
            player.func_195068_e(number);
            BackpackAbilities.sendParticlesPacket((IParticleData)ParticleTypes.field_197632_y, player, number);
        }
    }

    public void bookshelfAbility(@Nullable PlayerEntity player, @Nullable TravelersBackpackTileEntity tile) {
        BlockPos enchanting = BackpackUtils.findBlock3D(tile.func_145831_w(), tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p(), Blocks.field_150381_bn, 2, 2);
        if (enchanting != null) {
            if (!tile.func_145831_w().func_175623_d(new BlockPos((enchanting.func_177958_n() - tile.func_174877_v().func_177958_n()) / 2 + tile.func_174877_v().func_177958_n(), enchanting.func_177956_o(), (enchanting.func_177952_p() - tile.func_174877_v().func_177952_p()) / 2 + tile.func_174877_v().func_177952_p()))) {
                return;
            }
            for (int o = 0; o < 4; ++o) {
                tile.func_145831_w().func_195594_a((IParticleData)ParticleTypes.field_197623_p, (double)enchanting.func_177958_n() + 0.5, (double)enchanting.func_177956_o() + 2.0, (double)enchanting.func_177952_p() + 0.5, (double)((float)(tile.func_174877_v().func_177958_n() - enchanting.func_177958_n()) + tile.func_145831_w().field_73012_v.nextFloat()) - 0.5, (double)((float)(tile.func_174877_v().func_177956_o() - enchanting.func_177956_o()) - tile.func_145831_w().field_73012_v.nextFloat() - 1.0f), (double)((float)(tile.func_174877_v().func_177952_p() - enchanting.func_177952_p()) + tile.func_145831_w().field_73012_v.nextFloat()) - 0.5);
            }
        }
    }

    public void spongeAbility(TravelersBackpackTileEntity tile) {
        if (!tile.getLeftTank().isEmpty() && !tile.getRightTank().isEmpty() && tile.getLeftTank().getFluid().getFluid().func_207187_a((Fluid)Fluids.field_204546_a) && tile.getRightTank().getFluid().getFluid().func_207187_a((Fluid)Fluids.field_204546_a) && tile.getLeftTank().getFluidAmount() == tile.getLeftTank().getCapacity() && tile.getRightTank().getFluidAmount() == tile.getRightTank().getCapacity()) {
            float f = tile.func_145831_w().field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            float f1 = tile.func_145831_w().field_73012_v.nextFloat() * 0.5f + 0.5f;
            float f2 = MathHelper.func_76126_a((float)f) * 0.5f * f1;
            float f3 = MathHelper.func_76134_b((float)f) * 0.5f * f1;
            tile.func_145831_w().func_195594_a((IParticleData)ParticleTypes.field_218422_X, (double)((float)tile.func_174877_v().func_177958_n() + f2 + 0.5f), (double)((float)tile.func_174877_v().func_177956_o() + tile.func_145831_w().field_73012_v.nextFloat()), (double)((float)tile.func_174877_v().func_177952_p() + f3 + 0.5f), (double)((float)Math.pow(2.0, (double)(tile.func_145831_w().field_73012_v.nextInt(169) - 12) / 12.0)) / 24.0, -1.0, 0.0);
        }
    }

    public void cakeAbility(PlayerEntity player) {
        TravelersBackpackInventory inventory = CapabilityUtils.getBackpackInv(player);
        if (inventory.getLastTime() <= 0) {
            player.func_71024_bL().func_75122_a(2, 0.1f);
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_226138_eS_, SoundCategory.AMBIENT, 1.0f, (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.3f + 1.0f);
            if (!player.field_70170_p.field_72995_K) {
                if (player.field_70170_p instanceof ServerWorld) {
                    for (int i = 0; i < 3; ++i) {
                        float f = player.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
                        float f1 = player.field_70170_p.field_73012_v.nextFloat() * 0.5f + 0.5f;
                        float f2 = MathHelper.func_76126_a((float)f) * 0.5f * f1;
                        float f3 = MathHelper.func_76134_b((float)f) * 0.5f * f1;
                        ((ServerWorld)player.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197633_z, player.func_213303_ch().field_72450_a + (double)f2, player.func_174813_aQ().field_72338_b + (double)player.field_70170_p.field_73012_v.nextFloat() + 0.5, player.func_213303_ch().field_72449_c + (double)f3, 3, (double)((float)Math.pow(2.0, (double)(player.field_70170_p.field_73012_v.nextInt(169) - 12) / 12.0)) / 24.0, -1.0, 0.0, 0.0);
                    }
                }
                inventory.setLastTime(TimeUtils.randomTime(player.field_70170_p.field_73012_v, 360, 360 + player.func_71024_bL().func_75116_a() * 12));
                inventory.setDataChanged(7);
            }
        }
    }

    public void chickenAbility(PlayerEntity player, boolean firstSwitch) {
        TravelersBackpackInventory inv = CapabilityUtils.getBackpackInv(player);
        if (firstSwitch && inv.getLastTime() <= 0 && !inv.getLevel().field_72995_K) {
            inv.setLastTime(TimeUtils.randomTime(player.field_70170_p.field_73012_v, 360, 600));
            inv.setDataChanged(7);
            return;
        }
        if (inv.getLastTime() <= 0) {
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187665_Y, SoundCategory.AMBIENT, 1.0f, (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.3f + 1.0f);
            player.func_199703_a((IItemProvider)Items.field_151110_aK);
            if (!inv.getLevel().field_72995_K) {
                inv.setLastTime(TimeUtils.randomTime(player.field_70170_p.field_73012_v, 360, 600));
                inv.setDataChanged(7);
            }
        }
    }

    public void cactusAbility(@Nullable PlayerEntity player, @Nullable TravelersBackpackTileEntity tile) {
        if (player == null && tile != null) {
            FluidTank leftTank = tile.getLeftTank();
            FluidTank rightTank = tile.getRightTank();
            int drops = 0;
            if (this.isUnderRain(tile.func_174877_v(), tile.func_145831_w())) {
                ++drops;
            }
            FluidStack water = new FluidStack((Fluid)Fluids.field_204546_a, drops);
            if (!tile.func_145831_w().field_72995_K && tile.getLastTime() <= 0 && drops > 0) {
                tile.setLastTime(5);
                if (leftTank.isEmpty() || leftTank.getFluid().isFluidEqual(water)) {
                    leftTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                }
                if (rightTank.isEmpty() || rightTank.getFluid().isFluidEqual(water)) {
                    rightTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                }
                tile.setDataChanged(3);
            }
        } else if (player != null && tile == null) {
            TravelersBackpackInventory inv = CapabilityUtils.getBackpackInv(player);
            FluidTank leftTank = inv.getLeftTank();
            FluidTank rightTank = inv.getRightTank();
            int drops = 0;
            if (player.func_70090_H()) {
                drops += 2;
            }
            if (this.isUnderRain(player.func_233580_cy_(), player.field_70170_p)) {
                ++drops;
            }
            FluidStack water = new FluidStack((Fluid)Fluids.field_204546_a, drops);
            if (!inv.getLevel().field_72995_K && inv.getLastTime() <= 0 && drops > 0) {
                inv.setLastTime(5);
                if (leftTank.isEmpty() || leftTank.getFluid().isFluidEqual(water)) {
                    leftTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                }
                if (rightTank.isEmpty() || rightTank.getFluid().isFluidEqual(water)) {
                    rightTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                }
                inv.setDataChanged(3);
            }
        }
    }

    public static void melonAbility(TravelersBackpackTileEntity tile) {
        if (tile.getAbilityValue() && tile.getLastTime() <= 0) {
            Block.func_180635_a((World)tile.func_145831_w(), (BlockPos)tile.func_174877_v(), (ItemStack)new ItemStack((IItemProvider)Items.field_151127_ba, tile.func_145831_w().field_73012_v.nextInt(3)));
            tile.setLastTime(TimeUtils.randomTime(tile.func_145831_w().field_73012_v, 120, 480));
            tile.setDataChanged();
        }
    }

    public static void pumpkinAbility(LivingSetAttackTargetEvent event) {
        EndermanEntity enderman;
        if (event.getTarget() instanceof PlayerEntity && ABILITIES.checkBackpack((PlayerEntity)event.getTarget(), (Item)ModItems.PUMPKIN_TRAVELERS_BACKPACK.get()) && event.getEntity() instanceof EndermanEntity && (enderman = (EndermanEntity)event.getEntity()).func_70643_av() != event.getTarget()) {
            enderman.func_70624_b(null);
        }
    }

    public static boolean creeperAbility(LivingDeathEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            TravelersBackpackInventory inv = CapabilityUtils.getBackpackInv(player);
            if (player.func_233643_dh_() && inv != null && inv.getItemStack().func_77973_b() == ModItems.CREEPER_TRAVELERS_BACKPACK.get() && inv.getAbilityValue() && inv.getLastTime() <= 0) {
                player.func_70606_j(1.0f);
                player.func_195061_cb();
                player.func_195064_c(new EffectInstance(Effects.field_76428_l, 450, 1));
                player.func_195064_c(new EffectInstance(Effects.field_76444_x, 100, 1));
                player.func_195064_c(new EffectInstance(Effects.field_76426_n, 400, 0));
                player.field_70170_p.func_230546_a_((Entity)player, DamageSource.func_76365_a((PlayerEntity)player), null, player.func_226282_d_(0.5), player.func_226278_cu_(), player.func_226287_g_(0.5), 3.0f, false, Explosion.Mode.NONE);
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187572_ar, SoundCategory.AMBIENT, 1.2f, 0.5f);
                if (!inv.getLevel().field_72995_K) {
                    inv.setLastTime(TimeUtils.randomTime(player.field_70170_p.field_73012_v, 600, 900));
                    inv.setDataChanged(7);
                }
                event.setCanceled(true);
                return true;
            }
        }
        return false;
    }

    public void dragonAbility(PlayerEntity player) {
        this.magmaCubeAbility(player);
        this.squidAbility(player);
        this.addTimedEffect(player, Effects.field_76428_l, 0, 210, 0, false, false, true);
        this.addTimedEffect(player, Effects.field_76420_g, 210, 240, 0, false, false, true);
    }

    public void blazeAbility(PlayerEntity player) {
        if (player.field_70143_R >= 3.0f) {
            for (int i = 0; i < 4; ++i) {
                player.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, player.func_226282_d_(0.5), player.func_226279_cv_(), player.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
            player.field_70143_R = 0.0f;
        }
    }

    public static void blazeAbility(ProjectileImpactEvent.Fireball event) {
        EntityRayTraceResult result;
        if (event.getFireball() instanceof SmallFireballEntity && event.getRayTraceResult().func_216346_c() == RayTraceResult.Type.ENTITY && (result = (EntityRayTraceResult)event.getRayTraceResult()).func_216348_a() instanceof PlayerEntity && ABILITIES.checkBackpack((PlayerEntity)result.func_216348_a(), (Item)ModItems.BLAZE_TRAVELERS_BACKPACK.get())) {
            result.func_216348_a().field_70170_p.func_184133_a(null, result.func_216348_a().func_233580_cy_(), SoundEvents.field_187767_eL, SoundCategory.PLAYERS, 1.0f, 0.8f + result.func_216348_a().field_70170_p.field_73012_v.nextFloat() * 0.4f);
            BackpackAbilities.sendParticlesPacket((IParticleData)ParticleTypes.field_197631_x, (PlayerEntity)result.func_216348_a(), 3);
            event.getFireball().func_70106_y();
            event.setCanceled(true);
        }
    }

    public static void ghastAbility(LivingSetAttackTargetEvent event) {
        if (event.getEntity() instanceof GhastEntity && event.getTarget() instanceof PlayerEntity && ABILITIES.checkBackpack((PlayerEntity)event.getTarget(), (Item)ModItems.GHAST_TRAVELERS_BACKPACK.get()) && ((GhastEntity)event.getEntity()).func_70643_av() != event.getTarget()) {
            ((GhastEntity)event.getEntity()).func_70624_b(null);
        }
    }

    public void magmaCubeAbility(PlayerEntity player) {
        this.addTimedEffect(player, Effects.field_76426_n, 210, 240, 0, false, false, true);
    }

    public void spiderAbility(PlayerEntity player) {
        if (player.field_70123_F && !(player.func_213339_cH().func_177230_c() instanceof FlowingFluidBlock)) {
            if (!player.func_233570_aj_() && player.func_213453_ef()) {
                player.func_213293_j(player.func_213322_ci().field_72450_a, 0.0, player.func_213322_ci().field_72449_c);
            } else {
                player.func_213293_j(player.func_213322_ci().field_72450_a, 0.2, player.func_213322_ci().field_72449_c);
                World world = player.field_70170_p;
                BlockState state = world.func_180495_p(player.func_233580_cy_().func_177972_a(player.func_174811_aO()));
                world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state).setPos(player.func_233580_cy_()), player.func_226277_ct_() + (world.field_73012_v.nextDouble() - 0.5) * (double)player.func_213305_a((Pose)Pose.STANDING).field_220315_a, player.func_226278_cu_() + 0.1, player.func_226281_cx_() + (world.field_73012_v.nextDouble() - 0.5) * (double)player.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 1.5, 0.0);
            }
        }
    }

    public void witherAbility(PlayerEntity player) {
        if (player.func_70660_b(Effects.field_82731_v) != null) {
            player.func_195063_d(Effects.field_82731_v);
        }
    }

    public void batAbility(PlayerEntity player) {
        this.addTimedEffect(player, Effects.field_76439_r, 210, 240, 0, false, false, true);
    }

    public static void beeAbility(AttackEntityEvent event) {
        boolean flag;
        if (ABILITIES.checkBackpack(event.getPlayer(), (Item)ModItems.BEE_TRAVELERS_BACKPACK.get()) && (flag = event.getTarget().func_70097_a(DamageSource.func_226252_a_((LivingEntity)event.getPlayer()), 1.0f))) {
            event.getEntity().func_174815_a((LivingEntity)event.getPlayer(), event.getTarget());
            if (event.getTarget() instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)event.getTarget();
                living.func_226300_q_(living.func_226297_df_() + 1);
                living.func_195064_c(new EffectInstance(Effects.field_76436_u, 80, 0));
            }
        }
    }

    public void ocelotAbility(PlayerEntity player) {
        if (player.field_70170_p.func_217360_a(MobEntity.class, OCELOT_ABILITY_PREDICATE, (LivingEntity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.func_174813_aQ().func_72314_b(6.0, 2.0, 6.0)) != null) {
            this.addTimedEffect(player, Effects.field_76424_c, 20, 30, 0, false, false, true);
        }
    }

    public void cowAbility(PlayerEntity player) {
        if (!player.func_70651_bq().isEmpty() && CapabilityUtils.getBackpackInv(player).getLastTime() <= 0) {
            player.curePotionEffects(new ItemStack((IItemProvider)Items.field_151117_aB));
            if (!player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_217379_c(2007, player.func_233580_cy_(), 0xFFFFFF);
            }
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_226138_eS_, SoundCategory.PLAYERS, 1.0f, player.func_70681_au().nextFloat() * 0.1f + 0.9f);
            CapabilityUtils.getBackpackInv(player).setLastTime(TimeUtils.randomTime(player.field_70170_p.field_73012_v, 450, 600));
            CapabilityUtils.getBackpackInv(player).setDataChanged(7);
        }
    }

    public void squidAbility(PlayerEntity player) {
        if (player.func_70090_H()) {
            this.addTimedEffect(player, Effects.field_76427_o, 210, 240, 0, false, false, true);
            this.batAbility(player);
        }
    }

    private boolean isUnderRain(BlockPos pos, World world) {
        return world.func_226660_f_(pos) && world.func_72896_J();
    }

    public boolean checkBackpack(PlayerEntity player, Item item) {
        return CapabilityUtils.isWearingBackpack(player) && CapabilityUtils.getBackpackInv(player).getItemStack().func_77973_b() == item && CapabilityUtils.getBackpackInv(player).getAbilityValue();
    }

    public void addTimedEffect(PlayerEntity player, Effect effect, int minDuration, int maxDuration, int amplifier, boolean ambient, boolean showParticle, boolean showIcon) {
        if (!player.func_70644_a(effect)) {
            player.func_195064_c(new EffectInstance(effect, maxDuration, amplifier, ambient, showParticle, showIcon));
        } else if (player.func_70644_a(effect) && player.func_70660_b(effect).func_76459_b() <= minDuration) {
            player.func_195064_c(new EffectInstance(effect, maxDuration, amplifier, ambient, showParticle, showIcon));
        }
    }

    public static void sendParticlesPacket(IParticleData data, PlayerEntity player, int count) {
        for (int i = 0; i < count; ++i) {
            double d0 = player.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            double d1 = player.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            double d2 = player.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            if (!(player.field_70170_p instanceof ServerWorld)) continue;
            ((ServerWorld)player.field_70170_p).func_195598_a(data, player.func_226282_d_(1.0), player.func_226279_cv_() + 0.5, player.func_226287_g_(1.0), 1, d0, d1, d2, 0.0);
        }
    }

    public static boolean isOnList(Item[] list, ItemStack stackToCheck) {
        return Arrays.stream(list).anyMatch(s -> s == stackToCheck.func_77973_b());
    }
}

