/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.tileentity.TravelersBackpackTileEntity;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class UnpackBackpackCommand {
    public UnpackBackpackCommand(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder tbCommand = (LiteralArgumentBuilder)Commands.func_197057_a((String)"tb").requires(player -> player.func_197034_c(2));
        tbCommand.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"unpack").then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(source -> this.unpackTargetBlockEntity((CommandSource)source.getSource(), BlockPosArgument.func_197274_b((CommandContext)source, (String)"pos"))))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197094_d()).executes(source -> this.unpackTargetInventory((CommandSource)source.getSource(), EntityArgument.func_197089_d((CommandContext)source, (String)"target")))));
        dispatcher.register(tbCommand);
    }

    public int unpackTargetBlockEntity(CommandSource source, BlockPos blockPos) throws CommandSyntaxException {
        if (source.func_197023_e().func_175625_s(blockPos) instanceof TravelersBackpackTileEntity) {
            ItemStack stack;
            int i;
            TravelersBackpackTileEntity inv = (TravelersBackpackTileEntity)source.func_197023_e().func_175625_s(blockPos);
            NonNullList stacks = NonNullList.func_191196_a();
            for (i = 0; i < inv.getInventory().getSlots(); ++i) {
                stack = inv.getInventory().getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                stacks.add((Object)stack);
                inv.getInventory().setStackInSlot(i, ItemStack.field_190927_a);
            }
            for (i = 0; i < inv.getCraftingGridInventory().getSlots(); ++i) {
                stack = inv.getCraftingGridInventory().getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                stacks.add((Object)stack);
                inv.getCraftingGridInventory().setStackInSlot(i, ItemStack.field_190927_a);
            }
            if (stacks.size() > 0) {
                if (!source.func_197023_e().field_72995_K) {
                    InventoryHelper.func_219961_a((World)source.func_197023_e(), (BlockPos)blockPos, (NonNullList)stacks);
                }
                source.func_197030_a((ITextComponent)new StringTextComponent("Dropping contents of backpack placed at " + blockPos.func_229422_x_()), true);
                return 1;
            }
            source.func_197021_a((ITextComponent)new StringTextComponent("There's no contents in backpack at coordinates " + blockPos.func_229422_x_()));
            return -1;
        }
        source.func_197021_a((ITextComponent)new StringTextComponent("There's no backpack at coordinates " + blockPos.func_229422_x_()));
        return -1;
    }

    public int unpackTargetInventory(CommandSource source, ServerPlayerEntity serverPlayer) throws CommandSyntaxException {
        boolean hasBackpack = CapabilityUtils.isWearingBackpack((PlayerEntity)serverPlayer);
        if (hasBackpack) {
            AtomicBoolean flag = new AtomicBoolean(false);
            CapabilityUtils.getCapability((PlayerEntity)serverPlayer).ifPresent(cap -> {
                ItemStack stack;
                int i;
                NonNullList stacks = NonNullList.func_191196_a();
                for (i = 0; i < cap.getInventory().getInventory().getSlots(); ++i) {
                    stack = cap.getInventory().getInventory().getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    stacks.add((Object)stack);
                    cap.getInventory().getInventory().setStackInSlot(i, ItemStack.field_190927_a);
                }
                for (i = 0; i < cap.getInventory().getCraftingGridInventory().getSlots(); ++i) {
                    stack = cap.getInventory().getCraftingGridInventory().getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    stacks.add((Object)stack);
                    cap.getInventory().getCraftingGridInventory().setStackInSlot(i, ItemStack.field_190927_a);
                }
                if (stacks.size() > 0 && !source.func_197023_e().field_72995_K) {
                    InventoryHelper.func_219961_a((World)source.func_197023_e(), (BlockPos)serverPlayer.func_233580_cy_(), (NonNullList)stacks);
                    flag.set(true);
                }
            });
            if (flag.get()) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Dropping contents of " + serverPlayer.func_145748_c_().getString() + " backpack at " + serverPlayer.func_233580_cy_().func_229422_x_()), true);
                return 1;
            }
            source.func_197021_a((ITextComponent)new StringTextComponent("There's no contents in " + serverPlayer.func_145748_c_().getString() + " backpack"));
            return -1;
        }
        source.func_197021_a((ITextComponent)new StringTextComponent("Player " + serverPlayer.func_145748_c_().getString() + " is not wearing backpack"));
        return -1;
    }
}

