/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ClearBackpackCommand {
    public ClearBackpackCommand(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder tbCommand = (LiteralArgumentBuilder)Commands.func_197057_a((String)"tb").requires(player -> player.func_197034_c(2));
        tbCommand.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"remove").executes(source -> ClearBackpackCommand.removeBackpack((CommandSource)source.getSource(), ((CommandSource)source.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(source -> ClearBackpackCommand.removeBackpack((CommandSource)source.getSource(), EntityArgument.func_197089_d((CommandContext)source, (String)"player")))));
        tbCommand.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"clear").executes(source -> ClearBackpackCommand.clearBackpack((CommandSource)source.getSource(), ((CommandSource)source.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(source -> ClearBackpackCommand.clearBackpack((CommandSource)source.getSource(), EntityArgument.func_197089_d((CommandContext)source, (String)"player")))));
        dispatcher.register(tbCommand);
    }

    private static int removeBackpack(CommandSource source, ServerPlayerEntity player) throws CommandSyntaxException {
        if (CapabilityUtils.isWearingBackpack((PlayerEntity)player)) {
            CapabilityUtils.getCapability((PlayerEntity)player).ifPresent(cap -> {
                cap.setWearable(ItemStack.field_190927_a);
                cap.setContents(ItemStack.field_190927_a);
                cap.synchronise();
                cap.synchroniseToOthers((PlayerEntity)player);
            });
            source.func_197030_a((ITextComponent)new StringTextComponent("Removed Traveler's Backpack from " + player.func_145748_c_().getString()), true);
            return 1;
        }
        source.func_197021_a((ITextComponent)new StringTextComponent("Player " + player.func_145748_c_().getString() + " is not wearing backpack"));
        return -1;
    }

    private static int clearBackpack(CommandSource source, ServerPlayerEntity player) throws CommandSyntaxException {
        if (CapabilityUtils.isWearingBackpack((PlayerEntity)player)) {
            CapabilityUtils.getCapability((PlayerEntity)player).ifPresent(cap -> {
                ItemStack stack = cap.getWearable();
                stack.func_77982_d(new CompoundNBT());
                cap.setWearable(stack);
                cap.setContents(stack);
                cap.synchronise();
                cap.synchroniseToOthers((PlayerEntity)player);
            });
            source.func_197030_a((ITextComponent)new StringTextComponent("Cleared contents of Traveler's Backpack from " + player.func_145748_c_().getString()), true);
            return 1;
        }
        source.func_197021_a((ITextComponent)new StringTextComponent("Player " + player.func_145748_c_().getString() + " is not wearing backpack"));
        return -1;
    }
}

