/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.tileentity.TravelersBackpackTileEntity;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkHooks;

public class AccessBackpackCommand {
    public AccessBackpackCommand(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder tbCommand = (LiteralArgumentBuilder)Commands.func_197057_a((String)"tb").requires(player -> player.func_197034_c(2));
        tbCommand.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"access").then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(source -> this.openTargetBlockEntity((CommandSource)source.getSource(), BlockPosArgument.func_197274_b((CommandContext)source, (String)"pos"))))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197094_d()).executes(source -> this.openTargetInventory((CommandSource)source.getSource(), EntityArgument.func_197089_d((CommandContext)source, (String)"target")))));
        dispatcher.register(tbCommand);
    }

    public int openTargetBlockEntity(CommandSource source, BlockPos blockPos) throws CommandSyntaxException {
        if (source.func_197023_e().func_175625_s(blockPos) instanceof TravelersBackpackTileEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)source.func_197035_h(), (INamedContainerProvider)((TravelersBackpackTileEntity)source.func_197023_e().func_175625_s(blockPos)), (BlockPos)blockPos);
            source.func_197030_a((ITextComponent)new StringTextComponent("Accessing backpack of " + blockPos.func_229422_x_()), true);
            return 1;
        }
        source.func_197021_a((ITextComponent)new StringTextComponent("There's no backpack at coordinates " + blockPos.func_229422_x_()));
        return -1;
    }

    public int openTargetInventory(CommandSource source, ServerPlayerEntity serverPlayer) throws CommandSyntaxException {
        ServerPlayerEntity self = source.func_197035_h();
        boolean hasBackpack = CapabilityUtils.isWearingBackpack((PlayerEntity)serverPlayer);
        if (hasBackpack) {
            NetworkHooks.openGui((ServerPlayerEntity)self, (INamedContainerProvider)CapabilityUtils.getBackpackInv((PlayerEntity)serverPlayer), packetBuffer -> packetBuffer.writeByte(2).writeInt(serverPlayer.getEntity().func_145782_y()));
            source.func_197030_a((ITextComponent)new StringTextComponent("Accessing backpack of " + serverPlayer.func_145748_c_().getString()), true);
            return 1;
        }
        source.func_197021_a((ITextComponent)new StringTextComponent("Can't access backpack"));
        return -1;
    }
}

