/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.screen.ScreenImageButton;
import com.tiviacz.travelersbackpack.client.screen.TankScreen;
import com.tiviacz.travelersbackpack.client.screen.widget.ControlTab;
import com.tiviacz.travelersbackpack.client.screen.widget.CraftingWidget;
import com.tiviacz.travelersbackpack.client.screen.widget.MemoryWidget;
import com.tiviacz.travelersbackpack.client.screen.widget.SettingsWidget;
import com.tiviacz.travelersbackpack.client.screen.widget.SortWidget;
import com.tiviacz.travelersbackpack.client.screen.widget.TankSlotWidget;
import com.tiviacz.travelersbackpack.client.screen.widget.ToolSlotsWidget;
import com.tiviacz.travelersbackpack.client.screen.widget.WidgetBase;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackBaseContainer;
import com.tiviacz.travelersbackpack.inventory.container.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.network.SAbilitySliderPacket;
import com.tiviacz.travelersbackpack.network.SEquipBackpackPacket;
import com.tiviacz.travelersbackpack.network.SSleepingBagPacket;
import com.tiviacz.travelersbackpack.network.SSpecialActionPacket;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import java.util.ArrayList;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TravelersBackpackScreen
extends ContainerScreen<TravelersBackpackBaseContainer> {
    public static final ResourceLocation LEATHER_SCREEN_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/leather_travelers_backpack.png");
    public static final ResourceLocation IRON_SCREEN_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/iron_travelers_backpack.png");
    public static final ResourceLocation GOLD_SCREEN_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/gold_travelers_backpack.png");
    public static final ResourceLocation DIAMOND_SCREEN_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/diamond_travelers_backpack.png");
    public static final ResourceLocation NETHERITE_SCREEN_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/netherite_travelers_backpack.png");
    public static final ResourceLocation SETTINGS_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/travelers_backpack_settings.png");
    public static final ResourceLocation EXTRAS_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/travelers_backpack_extras.png");
    private final ScreenImageButton BED_BUTTON_BORDER;
    private final ScreenImageButton BED_BUTTON;
    private final ScreenImageButton EQUIP_BUTTON;
    private final ScreenImageButton UNEQUIP_BUTTON;
    private final ScreenImageButton ABILITY_SLIDER;
    public ControlTab controlTab;
    public ToolSlotsWidget toolSlotsWidget;
    public SettingsWidget settingsWidget;
    public SortWidget sortWidget;
    public MemoryWidget memoryWidget;
    public TankSlotWidget leftTankSlotWidget;
    public TankSlotWidget rightTankSlotWidget;
    public CraftingWidget craftingWidget;
    public final ITravelersBackpackInventory inv;
    private final byte screenID;
    private final TankScreen tankLeft;
    private final TankScreen tankRight;

    public TravelersBackpackScreen(TravelersBackpackBaseContainer screenContainer, PlayerInventory inventory, ITextComponent titleIn) {
        super((Container)screenContainer, inventory, titleIn);
        this.inv = screenContainer.inventory;
        this.screenID = screenContainer.inventory.getScreenID();
        this.field_147003_i = 0;
        this.field_147009_r = 0;
        this.field_146999_f = 248;
        this.field_147000_g = screenContainer.inventory.getTier().getImageHeight();
        this.BED_BUTTON_BORDER = new ScreenImageButton(5, 42 + screenContainer.inventory.getTier().getMenuSlotPlacementFactor(), 18, 18);
        this.BED_BUTTON = new ScreenImageButton(6, 43 + screenContainer.inventory.getTier().getMenuSlotPlacementFactor(), 16, 16);
        this.EQUIP_BUTTON = new ScreenImageButton(5, 42 + screenContainer.inventory.getTier().getMenuSlotPlacementFactor(), 18, 18);
        this.UNEQUIP_BUTTON = new ScreenImageButton(5, 42 + screenContainer.inventory.getTier().getMenuSlotPlacementFactor(), 18, 18);
        this.ABILITY_SLIDER = new ScreenImageButton(5, screenContainer.inventory.getTier().getAbilitySliderRenderPos(), 18, 11);
        this.tankLeft = new TankScreen(this.inv.getLeftTank(), 25, 7, this.inv.getTier().getTankRenderPos(), 16);
        this.tankRight = new TankScreen(this.inv.getRightTank(), 207, 7, this.inv.getTier().getTankRenderPos(), 16);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.initControlTab();
        this.initToolSlotsWidget();
        this.initSettingsTab();
        this.initTankSlotWidgets();
        this.initCraftingWidget();
    }

    public void initTankSlotWidgets() {
        if (this.inv.getTier().getOrdinal() <= 1) {
            this.leftTankSlotWidget = new TankSlotWidget(this, this.field_147003_i, this.field_147009_r, 28, 60);
            this.func_230481_d_(this.leftTankSlotWidget);
            this.rightTankSlotWidget = new TankSlotWidget(this, this.field_147003_i + 220, this.field_147009_r, 28, 60);
            this.func_230481_d_(this.rightTankSlotWidget);
        }
    }

    public void initControlTab() {
        this.controlTab = new ControlTab(this, this.field_147003_i + 61, this.field_147009_r - 10, 50, 13);
        this.func_230481_d_(this.controlTab);
    }

    public void initToolSlotsWidget() {
        this.toolSlotsWidget = new ToolSlotsWidget(this, this.field_147003_i + 5, this.field_147009_r - 15, 18, 15);
        this.func_230481_d_(this.toolSlotsWidget);
    }

    public void initSettingsTab() {
        this.settingsWidget = new SettingsWidget(this, this.field_147003_i + this.field_146999_f, this.field_147009_r + 10, 15, 18);
        this.func_230481_d_(this.settingsWidget);
        this.sortWidget = new SortWidget(this, this.field_147003_i + this.field_146999_f, this.field_147009_r + 29, 15, 18);
        this.func_230481_d_(this.sortWidget);
        this.memoryWidget = new MemoryWidget(this, this.field_147003_i + this.field_146999_f, this.field_147009_r + 48, 15, 18);
        this.func_230481_d_(this.memoryWidget);
    }

    public void initCraftingWidget() {
        this.craftingWidget = new CraftingWidget(this, this.field_147003_i + this.field_146999_f, this.field_147009_r + 29, 15, 18);
        this.func_230481_d_(this.craftingWidget);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.field_230706_i_.func_110434_K().func_110577_a(SETTINGS_TRAVELERS_BACKPACK);
        this.craftingWidget.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (!this.inv.getLeftTank().isEmpty()) {
            this.tankLeft.drawScreenFluidBar(this, matrixStack);
        }
        if (!this.inv.getRightTank().isEmpty()) {
            this.tankRight.drawScreenFluidBar(this, matrixStack);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(EXTRAS_TRAVELERS_BACKPACK);
        if (this.inv.hasTileEntity()) {
            if (this.BED_BUTTON_BORDER.inButton(this, mouseX, mouseY)) {
                this.BED_BUTTON_BORDER.draw(matrixStack, this, 19, 0);
                this.BED_BUTTON.draw(matrixStack, this, this.getBedIconX(this.inv.getSleepingBagColor()), this.getBedIconY(this.inv.getSleepingBagColor()));
            } else {
                this.BED_BUTTON_BORDER.draw(matrixStack, this, 0, 0);
                this.BED_BUTTON.draw(matrixStack, this, this.getBedIconX(this.inv.getSleepingBagColor()), this.getBedIconY(this.inv.getSleepingBagColor()));
            }
            if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.inv.getItemStack()) && !this.inv.getSettingsManager().showToolSlots()) {
                if (this.ABILITY_SLIDER.inButton(this, mouseX, mouseY)) {
                    if (this.inv.getAbilityValue()) {
                        this.ABILITY_SLIDER.draw(matrixStack, this, 114, 0);
                    } else {
                        this.ABILITY_SLIDER.draw(matrixStack, this, 114, 12);
                    }
                } else if (this.inv.getAbilityValue()) {
                    this.ABILITY_SLIDER.draw(matrixStack, this, 95, 0);
                } else {
                    this.ABILITY_SLIDER.draw(matrixStack, this, 95, 12);
                }
            }
        } else {
            if (!CapabilityUtils.isWearingBackpack(this.field_213127_e.field_70458_d) && this.screenID == 1) {
                if (this.EQUIP_BUTTON.inButton(this, mouseX, mouseY)) {
                    this.EQUIP_BUTTON.draw(matrixStack, this, 57, 0);
                } else {
                    this.EQUIP_BUTTON.draw(matrixStack, this, 38, 0);
                }
            }
            if (CapabilityUtils.isWearingBackpack(this.field_213127_e.field_70458_d) && this.screenID == 2) {
                if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.inv.getItemStack()) && !this.inv.getSettingsManager().showToolSlots()) {
                    if (this.ABILITY_SLIDER.inButton(this, mouseX, mouseY)) {
                        if (this.inv.getAbilityValue()) {
                            this.ABILITY_SLIDER.draw(matrixStack, this, 114, 0);
                        } else {
                            this.ABILITY_SLIDER.draw(matrixStack, this, 114, 12);
                        }
                    } else if (this.inv.getAbilityValue()) {
                        this.ABILITY_SLIDER.draw(matrixStack, this, 95, 0);
                    } else {
                        this.ABILITY_SLIDER.draw(matrixStack, this, 95, 12);
                    }
                }
                if (this.UNEQUIP_BUTTON.inButton(this, mouseX, mouseY)) {
                    this.UNEQUIP_BUTTON.draw(matrixStack, this, 57, 19);
                } else {
                    this.UNEQUIP_BUTTON.draw(matrixStack, this, 38, 19);
                }
            }
        }
        this.controlTab.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.toolSlotsWidget.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.inv.getTier().getOrdinal() <= 1) {
            this.leftTankSlotWidget.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.rightTankSlotWidget.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        this.settingsWidget.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_231039_at__().stream().filter(w -> w instanceof WidgetBase).filter(w -> ((WidgetBase)((Object)w)).isSettingsChild() && ((WidgetBase)((Object)w)).isVisible()).forEach(w -> ((WidgetBase)((Object)w)).func_230430_a_(matrixStack, mouseX, mouseY, partialTicks));
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230459_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230459_a_(matrixStack, mouseX, mouseY);
        if (this.tankLeft.inTank(this, mouseX, mouseY)) {
            this.func_243308_b(matrixStack, this.tankLeft.getTankTooltip(), mouseX, mouseY);
        }
        if (this.tankRight.inTank(this, mouseX, mouseY)) {
            this.func_243308_b(matrixStack, this.tankRight.getTankTooltip(), mouseX, mouseY);
        }
        if (!(this.screenID != 3 && this.screenID != 2 || !BackpackAbilities.isOnList(this.screenID == 2 ? BackpackAbilities.ITEM_ABILITIES_LIST : BackpackAbilities.BLOCK_ABILITIES_LIST, this.inv.getItemStack()) || !this.ABILITY_SLIDER.inButton(this, mouseX, mouseY) || this.isWidgetVisible(Tiers.LEATHER, this.leftTankSlotWidget) || this.isWidgetVisible(Tiers.IRON, this.leftTankSlotWidget) || this.inv.getSettingsManager().showToolSlots())) {
            if (this.inv.getAbilityValue()) {
                ArrayList<IReorderingProcessor> list = new ArrayList<IReorderingProcessor>();
                list.add(new TranslationTextComponent("screen.travelersbackpack.ability_enabled").func_241878_f());
                if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_TIMER_ABILITIES_LIST, this.inv.getItemStack()) || BackpackAbilities.isOnList(BackpackAbilities.BLOCK_TIMER_ABILITIES_LIST, this.inv.getItemStack())) {
                    list.add(this.inv.getLastTime() == 0 ? new TranslationTextComponent("screen.travelersbackpack.ability_ready").func_241878_f() : new StringTextComponent(BackpackUtils.getConvertedTime(this.inv.getLastTime())).func_241878_f());
                }
                this.func_238654_b_(matrixStack, list, mouseX, mouseY);
            } else if (!TravelersBackpackConfig.enableBackpackAbilities || !BackpackAbilities.ALLOWED_ABILITIES.contains(this.inv.getItemStack().func_77973_b())) {
                this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("screen.travelersbackpack.ability_disabled_config"), mouseX, mouseY);
            } else {
                this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("screen.travelersbackpack.ability_disabled"), mouseX, mouseY);
            }
        }
        if (TravelersBackpack.enableCurios() && !this.isWidgetVisible(Tiers.LEATHER, this.leftTankSlotWidget)) {
            if (CapabilityUtils.isWearingBackpack(((TravelersBackpackBaseContainer)this.func_212873_a_()).playerInventory.field_70458_d) && this.screenID == 2 && this.UNEQUIP_BUTTON.inButton(this, mouseX, mouseY)) {
                this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("screen.travelersbackpack.unequip_integration"), mouseX, mouseY);
            }
            if (!CapabilityUtils.isWearingBackpack(((TravelersBackpackBaseContainer)this.func_212873_a_()).playerInventory.field_70458_d) && this.screenID == 1 && this.EQUIP_BUTTON.inButton(this, mouseX, mouseY)) {
                this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("screen.travelersbackpack.equip_integration"), mouseX, mouseY);
            }
        }
        this.craftingWidget.renderTooltip(matrixStack, mouseX, mouseY);
    }

    public boolean isWidgetVisible(Tiers.Tier tier, TankSlotWidget widget) {
        return this.inv.getTier().getOrdinal() == tier.getOrdinal() && widget.isVisible();
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        int i2;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.getScreenTexture(this.inv.getTier()));
        int x = (this.field_230708_k_ - this.field_146999_f) / 2;
        int y = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(EXTRAS_TRAVELERS_BACKPACK);
        if (!this.inv.getSettingsManager().renderOverlay() || TravelersBackpackConfig.disableCrafting) {
            for (i2 = 0; i2 < 3; ++i2) {
                for (int j = 0; j < 3; ++j) {
                    this.func_238474_b_(matrixStack, this.getGuiLeft() + 151 + j * 18, this.getGuiTop() + (6 + this.inv.getTier().getMenuSlotPlacementFactor()) + i2 * 18, 213, 0, 18, 18);
                }
            }
        }
        if (TravelersBackpackConfig.disableCrafting) {
            this.func_238474_b_(matrixStack, this.getGuiLeft() + 205, this.getGuiTop() + this.inv.getTier().getMenuSlotPlacementFactor() + 42, 213, 19, 38, 18);
        }
        if (this.inv.getSettingsManager().showToolSlots()) {
            for (i2 = 0; i2 < this.inv.getTier().getToolSlots(); ++i2) {
                boolean disabled = false;
                if (((TravelersBackpackBaseContainer)this.field_147002_h).func_75139_a(this.inv.getTier().getStorageSlotsWithCrafting() + i2 + 1) instanceof ToolSlotItemHandler) {
                    ToolSlotItemHandler toolSlot = (ToolSlotItemHandler)((TravelersBackpackBaseContainer)this.field_147002_h).func_75139_a(this.inv.getTier().getStorageSlotsWithCrafting() + i2 + 1);
                    disabled = !toolSlot.canAccessPlace() || !toolSlot.canAccessPickup();
                }
                this.func_238474_b_(matrixStack, this.getGuiLeft() + 5, this.getGuiTop() + 6 + 18 * i2, 232, disabled ? 38 : 0, 18, 18);
            }
        }
        if (!this.inv.getSlotManager().getUnsortableSlots().isEmpty() && !this.inv.getSlotManager().isSelectorActive((byte)1)) {
            this.inv.getSlotManager().getUnsortableSlots().forEach(i -> this.func_238474_b_(matrixStack, this.getGuiLeft() + this.getX((int)i), this.getGuiTop() + this.getY((int)i), 77, 20, 16, 16));
        }
        if (!this.inv.getSlotManager().getMemorySlots().isEmpty()) {
            this.func_230926_e_(100);
            this.field_230707_j_.field_77023_b = 100.0f;
            this.inv.getSlotManager().getMemorySlots().forEach(pair -> {
                if (this.inv.getSlotManager().isSelectorActive((byte)1)) {
                    this.func_238474_b_(matrixStack, this.getGuiLeft() + this.getX((Integer)pair.getFirst()), this.getGuiTop() + this.getY((Integer)pair.getFirst()), 115, 24, 16, 16);
                    if (!((TravelersBackpackBaseContainer)this.field_147002_h).func_75139_a((Integer)pair.getFirst() + 1).func_75211_c().func_190926_b()) {
                        this.drawMemoryOverlay(matrixStack, this.getGuiLeft() + this.getX((Integer)pair.getFirst()), this.getGuiTop() + this.getY((Integer)pair.getFirst()));
                    }
                }
                if (!((TravelersBackpackBaseContainer)this.field_147002_h).func_75139_a((Integer)pair.getFirst() + 1).func_75211_c().func_190926_b()) {
                    return;
                }
                ItemStack itemstack = (ItemStack)pair.getSecond();
                RenderSystem.enableDepthTest();
                this.field_230707_j_.func_184391_a((LivingEntity)this.field_230706_i_.field_71439_g, itemstack, this.getGuiLeft() + this.getX((Integer)pair.getFirst()), this.getGuiTop() + this.getY((Integer)pair.getFirst()));
                this.drawMemoryOverlay(matrixStack, this.getGuiLeft() + this.getX((Integer)pair.getFirst()), this.getGuiTop() + this.getY((Integer)pair.getFirst()));
            });
            this.field_230707_j_.field_77023_b = 0.0f;
            this.func_230926_e_(0);
        }
    }

    public void drawMemoryOverlay(MatrixStack matrixStack, int x, int y) {
        matrixStack.func_227860_a_();
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(EXTRAS_TRAVELERS_BACKPACK);
        this.func_238474_b_(matrixStack, x, y, 96, 24, 16, 16);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        matrixStack.func_227865_b_();
    }

    public boolean func_231048_c_(double pMouseX, double pMouseY, int pButton) {
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        boolean flag = this.func_195361_a(pMouseX, pMouseY, i, j, pButton);
        if (flag && !((TravelersBackpackBaseContainer)this.field_147002_h).playerInventory.func_70445_o().func_190926_b()) {
            for (IGuiEventListener widget : this.func_231039_at__()) {
                if (!(widget instanceof WidgetBase) || !widget.func_231047_b_(pMouseX, pMouseY)) continue;
                return false;
            }
        }
        return super.func_231048_c_(pMouseX, pMouseY, pButton);
    }

    protected void func_184098_a(Slot slot, int slotId, int button, ClickType type) {
        super.func_184098_a(slot, slotId, button, type);
        if (slotId >= 1 && slotId <= this.inv.getTier().getStorageSlotsWithCrafting() && this.inv.getSlotManager().isSelectorActive((byte)0)) {
            this.inv.getSlotManager().setUnsortableSlot(slotId - 1);
        }
        if (slotId >= 1 && slotId <= this.inv.getTier().getStorageSlotsWithCrafting() && this.inv.getSlotManager().isSelectorActive((byte)1) && (!slot.func_75211_c().func_190926_b() || slot.func_75211_c().func_190926_b() && this.inv.getSlotManager().isSlot((byte)1, slotId - 1))) {
            this.inv.getSlotManager().setMemorySlot(slotId - 1, slot.func_75211_c());
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.inv.getSlotManager().isSelectorActive((byte)0) && !this.sortWidget.func_231047_b_(mouseX, mouseY) || this.inv.getSlotManager().isSelectorActive((byte)1) && !this.memoryWidget.func_231047_b_(mouseX, mouseY)) {
            return super.func_231044_a_(mouseX, mouseY, button);
        }
        if (!this.inv.getLeftTank().isEmpty() && this.tankLeft.inTank(this, (int)mouseX, (int)mouseY) && BackpackUtils.isShiftPressed()) {
            TravelersBackpack.NETWORK.sendToServer((Object)new SSpecialActionPacket(this.inv.getScreenID(), 3, 1.0));
            if (this.inv.getScreenID() == 1) {
                ServerActions.emptyTank(1.0, this.field_213127_e.field_70458_d, this.inv.getLevel(), this.inv.getScreenID());
            }
        }
        if (!this.inv.getRightTank().isEmpty() && this.tankRight.inTank(this, (int)mouseX, (int)mouseY) && BackpackUtils.isShiftPressed()) {
            TravelersBackpack.NETWORK.sendToServer((Object)new SSpecialActionPacket(this.inv.getScreenID(), 3, 2.0));
            if (this.inv.getScreenID() == 1) {
                ServerActions.emptyTank(2.0, this.field_213127_e.field_70458_d, this.inv.getLevel(), this.inv.getScreenID());
            }
        }
        if (this.inv.hasTileEntity()) {
            if (this.BED_BUTTON_BORDER.inButton(this, (int)mouseX, (int)mouseY) && !this.isWidgetVisible(Tiers.LEATHER, this.leftTankSlotWidget)) {
                TravelersBackpack.NETWORK.sendToServer((Object)new SSleepingBagPacket(this.inv.getPosition()));
                return true;
            }
            if (!this.inv.getSettingsManager().showToolSlots() && BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.inv.getItemStack()) && this.ABILITY_SLIDER.inButton(this, (int)mouseX, (int)mouseY) && !this.isWidgetVisible(Tiers.LEATHER, this.leftTankSlotWidget) && !this.isWidgetVisible(Tiers.IRON, this.leftTankSlotWidget)) {
                TravelersBackpack.NETWORK.sendToServer((Object)new SAbilitySliderPacket(this.inv.getScreenID(), !this.inv.getAbilityValue()));
                this.playUIClickSound();
                return true;
            }
        }
        if (!this.inv.hasTileEntity()) {
            if (!TravelersBackpack.enableCurios()) {
                if (!CapabilityUtils.isWearingBackpack(this.field_213127_e.field_70458_d) && this.screenID == 1 && !this.isWidgetVisible(Tiers.LEATHER, this.leftTankSlotWidget) && this.EQUIP_BUTTON.inButton(this, (int)mouseX, (int)mouseY)) {
                    TravelersBackpack.NETWORK.sendToServer((Object)new SEquipBackpackPacket(true));
                    return true;
                }
                if (CapabilityUtils.isWearingBackpack(this.field_213127_e.field_70458_d) && this.screenID == 2 && !this.isWidgetVisible(Tiers.LEATHER, this.leftTankSlotWidget) && this.UNEQUIP_BUTTON.inButton(this, (int)mouseX, (int)mouseY)) {
                    TravelersBackpack.NETWORK.sendToServer((Object)new SEquipBackpackPacket(false));
                    return true;
                }
            }
            if (!this.inv.getSettingsManager().showToolSlots() && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.inv.getItemStack()) && this.ABILITY_SLIDER.inButton(this, (int)mouseX, (int)mouseY) && !this.isWidgetVisible(Tiers.LEATHER, this.leftTankSlotWidget) && !this.isWidgetVisible(Tiers.IRON, this.leftTankSlotWidget)) {
                TravelersBackpack.NETWORK.sendToServer((Object)new SAbilitySliderPacket(this.inv.getScreenID(), !this.inv.getAbilityValue()));
                this.playUIClickSound();
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public void playUIClickSound() {
        this.field_213127_e.field_70458_d.field_70170_p.func_184133_a(this.field_213127_e.field_70458_d, this.field_213127_e.field_70458_d.func_233580_cy_(), SoundEvents.field_187909_gi, SoundCategory.MASTER, 0.25f, 1.0f);
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (ModClientEventHandler.OPEN_INVENTORY.isActiveAndMatches(InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
            ClientPlayerEntity playerEntity = this.getMinecraft().field_71439_g;
            if (playerEntity != null) {
                this.func_231175_as__();
            }
            return true;
        }
        return super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public ResourceLocation getScreenTexture(Tiers.Tier tier) {
        if (tier == Tiers.LEATHER) {
            return LEATHER_SCREEN_TRAVELERS_BACKPACK;
        }
        if (tier == Tiers.IRON) {
            return IRON_SCREEN_TRAVELERS_BACKPACK;
        }
        if (tier == Tiers.GOLD) {
            return GOLD_SCREEN_TRAVELERS_BACKPACK;
        }
        if (tier == Tiers.DIAMOND) {
            return DIAMOND_SCREEN_TRAVELERS_BACKPACK;
        }
        if (tier == Tiers.NETHERITE) {
            return NETHERITE_SCREEN_TRAVELERS_BACKPACK;
        }
        return LEATHER_SCREEN_TRAVELERS_BACKPACK;
    }

    public int getY(int slot) {
        if (this.inv.getTier() == Tiers.LEATHER) {
            if (slot <= 8) {
                return 7;
            }
            if (slot <= 17) {
                return 25;
            }
            if (slot <= 26) {
                return 43;
            }
        }
        if (this.inv.getTier() == Tiers.IRON) {
            if (slot <= 8) {
                return 7;
            }
            if (slot <= 17) {
                return 25;
            }
            if (slot <= 26) {
                return 43;
            }
            if (slot <= 35) {
                return 61;
            }
        }
        if (this.inv.getTier() == Tiers.GOLD) {
            if (slot <= 8) {
                return 7;
            }
            if (slot <= 17) {
                return 25;
            }
            if (slot <= 26) {
                return 43;
            }
            if (slot <= 35) {
                return 61;
            }
            if (slot <= 44) {
                return 79;
            }
        }
        if (this.inv.getTier() == Tiers.DIAMOND) {
            if (slot <= 8) {
                return 7;
            }
            if (slot <= 17) {
                return 25;
            }
            if (slot <= 26) {
                return 43;
            }
            if (slot <= 35) {
                return 61;
            }
            if (slot <= 44) {
                return 79;
            }
            if (slot <= 53) {
                return 97;
            }
        }
        if (this.inv.getTier() == Tiers.NETHERITE) {
            if (slot <= 8) {
                return 7;
            }
            if (slot <= 17) {
                return 25;
            }
            if (slot <= 26) {
                return 43;
            }
            if (slot <= 35) {
                return 61;
            }
            if (slot <= 44) {
                return 79;
            }
            if (slot <= 53) {
                return 97;
            }
            if (slot <= 62) {
                return 115;
            }
        }
        return 0;
    }

    public int getX(int slot) {
        if (this.inv.getTier() == Tiers.LEATHER) {
            if (slot >= 0 && slot <= 8) {
                return 44 + 18 * slot;
            }
            if (slot >= 9 && slot <= 17) {
                return 44 + 18 * (slot - 9);
            }
            if (slot >= 18 && slot <= 26) {
                return 44 + 18 * (slot - 18);
            }
        }
        if (this.inv.getTier() == Tiers.IRON) {
            if (slot >= 0 && slot <= 8) {
                return 44 + 18 * slot;
            }
            if (slot >= 9 && slot <= 17) {
                return 44 + 18 * (slot - 9);
            }
            if (slot >= 18 && slot <= 26) {
                return 44 + 18 * (slot - 18);
            }
            if (slot >= 27 && slot <= 35) {
                return 44 + 18 * (slot - 27);
            }
        }
        if (this.inv.getTier() == Tiers.GOLD) {
            if (slot >= 0 && slot <= 8) {
                return 44 + 18 * slot;
            }
            if (slot >= 9 && slot <= 17) {
                return 44 + 18 * (slot - 9);
            }
            if (slot >= 18 && slot <= 26) {
                return 44 + 18 * (slot - 18);
            }
            if (slot >= 27 && slot <= 35) {
                return 44 + 18 * (slot - 27);
            }
            if (slot >= 36 && slot <= 44) {
                return 44 + 18 * (slot - 36);
            }
        }
        if (this.inv.getTier() == Tiers.DIAMOND) {
            if (slot >= 0 && slot <= 8) {
                return 44 + 18 * slot;
            }
            if (slot >= 9 && slot <= 17) {
                return 44 + 18 * (slot - 9);
            }
            if (slot >= 18 && slot <= 26) {
                return 44 + 18 * (slot - 18);
            }
            if (slot >= 27 && slot <= 35) {
                return 44 + 18 * (slot - 27);
            }
            if (slot >= 36 && slot <= 44) {
                return 44 + 18 * (slot - 36);
            }
            if (slot >= 45 && slot <= 53) {
                return 44 + 18 * (slot - 45);
            }
        }
        if (this.inv.getTier() == Tiers.NETHERITE) {
            if (slot >= 0 && slot <= 8) {
                return 44 + 18 * slot;
            }
            if (slot >= 9 && slot <= 17) {
                return 44 + 18 * (slot - 9);
            }
            if (slot >= 18 && slot <= 26) {
                return 44 + 18 * (slot - 18);
            }
            if (slot >= 27 && slot <= 35) {
                return 44 + 18 * (slot - 27);
            }
            if (slot >= 36 && slot <= 44) {
                return 44 + 18 * (slot - 36);
            }
            if (slot >= 45 && slot <= 53) {
                return 44 + 18 * (slot - 45);
            }
            if (slot >= 54 && slot <= 62) {
                return 44 + 18 * (slot - 54);
            }
        }
        return 0;
    }

    public int getBedIconX(int colorId) {
        return 1 + (colorId <= 7 ? 0 : 19);
    }

    public int getBedIconY(int colorId) {
        return 19 + colorId % 8 * 17;
    }
}

