/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.entity.IEntityTravelersBackpack;
import com.tiviacz.travelersbackpack.client.model.TravelersBackpackWearableModel;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.util.ResourceUtils;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TravelersBackpackEntityLayer
extends LayerRenderer<LivingEntity, BipedModel<LivingEntity>> {
    public TravelersBackpackWearableModel model;

    public TravelersBackpackEntityLayer(IEntityRenderer<LivingEntity, BipedModel<LivingEntity>> renderer) {
        super(renderer);
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (TravelersBackpackConfig.disableBackpackRender) {
            return;
        }
        if (CapabilityUtils.isWearingBackpack(livingEntity) && !livingEntity.func_82150_aj()) {
            this.renderLayer(matrixStackIn, bufferIn, packedLightIn, livingEntity);
        }
    }

    private void renderLayer(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, LivingEntity livingEntity) {
        ItemStack stack = ((IEntityTravelersBackpack)CapabilityUtils.getEntityCapability(livingEntity).resolve().get()).getWearable();
        this.model = new TravelersBackpackWearableModel(livingEntity, bufferIn);
        boolean flag = stack.func_77973_b() == ModItems.QUARTZ_TRAVELERS_BACKPACK.get() || stack.func_77973_b() == ModItems.SNOW_TRAVELERS_BACKPACK.get();
        boolean isCustomSleepingBag = false;
        ResourceLocation loc = ResourceUtils.getBackpackTexture(stack.func_77973_b());
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("SleepingBagColor")) {
            isCustomSleepingBag = true;
        }
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(flag ? RenderType.func_228642_d_((ResourceLocation)loc) : RenderType.func_228634_a_((ResourceLocation)loc));
        matrixStackIn.func_227860_a_();
        if (livingEntity.func_213453_ef()) {
            matrixStackIn.func_227861_a_(0.0, -0.155, 0.025);
        }
        if (livingEntity.func_70631_g_()) {
            matrixStackIn.func_227861_a_(0.0, 0.65, 0.0);
            matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
        }
        ((BipedModel)this.func_215332_c()).func_217148_a((BipedModel)this.model);
        this.model.setupAngles((BipedModel)this.func_215332_c());
        matrixStackIn.func_227861_a_(0.0, 0.175, 0.325);
        matrixStackIn.func_227862_a_(0.85f, 0.85f, 0.85f);
        this.model.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        loc = isCustomSleepingBag ? ResourceUtils.getSleepingBagTexture(stack.func_196082_o().func_74762_e("SleepingBagColor")) : ResourceUtils.getDefaultSleepingBagTexture();
        ivertexbuilder = bufferIn.getBuffer(RenderType.func_228638_b_((ResourceLocation)loc));
        this.model.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 0.25f);
        matrixStackIn.func_227865_b_();
    }
}

