/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.tiviacz.travelersbackpack.inventory.Tiers;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class RenderData {
    private final ItemStack stack;
    private final PlayerEntity player;
    private final FluidTank leftTank = this.createFluidHandler();
    private final FluidTank rightTank = this.createFluidHandler();
    private final String LEFT_TANK = "LeftTank";
    private final String RIGHT_TANK = "RightTank";
    private final String COLOR = "Color";
    private final String SLEEPING_BAG_COLOR = "SleepingBagColor";

    public RenderData(PlayerEntity player, ItemStack stack, boolean loadData) {
        this.player = player;
        this.stack = stack;
        if (loadData) {
            this.loadDataFromStack(stack);
        }
    }

    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    public FluidTank getRightTank() {
        return this.rightTank;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public int getSleepingBagColor() {
        if (this.stack.func_196082_o().func_74764_b("SleepingBagColor")) {
            return this.stack.func_196082_o().func_74762_e("SleepingBagColor");
        }
        return DyeColor.RED.func_196059_a();
    }

    public void loadDataFromStack(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77942_o()) {
            this.loadTanks(stack.func_196082_o());
        }
    }

    public void loadTanks(CompoundNBT compound) {
        this.leftTank.readFromNBT(compound.func_74775_l("LeftTank"));
        this.rightTank.readFromNBT(compound.func_74775_l("RightTank"));
    }

    private FluidTank createFluidHandler() {
        return new FluidTank(Tiers.LEATHER.getTankCapacity()){

            public FluidTank readFromNBT(CompoundNBT nbt) {
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt);
                this.setCapacity(Tiers.of(RenderData.this.stack.func_196082_o().func_74762_e("Tier")).getTankCapacity());
                this.setFluid(fluid);
                return this;
            }
        };
    }
}

