/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.capability;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import com.tiviacz.travelersbackpack.network.CSyncCapabilityPacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.network.PacketDistributor;

public class TravelersBackpackWearable
implements ITravelersBackpack {
    private ItemStack wearable = new ItemStack((IItemProvider)Items.field_190931_a, 0);
    private final PlayerEntity playerEntity;
    private final TravelersBackpackInventory inventory;

    public TravelersBackpackWearable(PlayerEntity playerEntity) {
        this.playerEntity = playerEntity;
        this.inventory = new TravelersBackpackInventory(this.wearable, playerEntity, 2);
    }

    @Override
    public boolean hasWearable() {
        return !this.wearable.func_190926_b();
    }

    @Override
    public ItemStack getWearable() {
        return this.wearable;
    }

    @Override
    public void setWearable(ItemStack stack) {
        this.wearable = stack;
    }

    @Override
    public void removeWearable() {
        this.wearable = new ItemStack((IItemProvider)Items.field_190931_a, 0);
        this.inventory.setStack(new ItemStack((IItemProvider)Items.field_190931_a, 0));
    }

    @Override
    public TravelersBackpackInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void setContents(ItemStack stack) {
        this.inventory.setStack(stack);
        if (!stack.func_190926_b()) {
            this.inventory.loadAllData(stack.func_196082_o());
        }
    }

    @Override
    public void synchronise() {
        if (this.playerEntity != null && !this.playerEntity.field_70170_p.field_72995_K) {
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)this.playerEntity;
            CapabilityUtils.getCapability((PlayerEntity)serverPlayerEntity).ifPresent(cap -> TravelersBackpack.NETWORK.send(PacketDistributor.PLAYER.with(() -> serverPlayerEntity), (Object)new CSyncCapabilityPacket(serverPlayerEntity.func_145782_y(), true, this.wearable.func_77955_b(new CompoundNBT()))));
        }
    }

    @Override
    public void synchroniseToOthers(PlayerEntity player) {
        if (player != null && !player.field_70170_p.field_72995_K) {
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)player;
            CapabilityUtils.getCapability((PlayerEntity)serverPlayerEntity).ifPresent(cap -> TravelersBackpack.NETWORK.send(PacketDistributor.TRACKING_ENTITY.with(() -> serverPlayerEntity), (Object)new CSyncCapabilityPacket(serverPlayerEntity.func_145782_y(), true, this.wearable.func_77955_b(new CompoundNBT()))));
        }
    }
}

