/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.blocks;

import com.mojang.datafixers.util.Either;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.tileentity.TravelersBackpackTileEntity;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Unit;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class SleepingBagBlock
extends BedBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.field_208139_an;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.field_208192_s;
    public static final BooleanProperty CAN_DROP = BlockStateProperties.field_208176_c;
    protected static final VoxelShape SLEEPING_BAG = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape SLEEPING_BAG_NORTH = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.func_208617_a((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)2.5, (double)8.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SLEEPING_BAG_EAST = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.func_208617_a((double)8.0, (double)2.0, (double)0.0, (double)16.0, (double)2.5, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SLEEPING_BAG_SOUTH = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.func_208617_a((double)0.0, (double)2.0, (double)8.0, (double)16.0, (double)2.5, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SLEEPING_BAG_WEST = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.func_208617_a((double)0.0, (double)2.0, (double)0.0, (double)8.0, (double)2.5, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private final DyeColor color;

    public SleepingBagBlock(DyeColor color, AbstractBlock.Properties properties) {
        super(color, properties);
        this.color = color;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(PART, (Comparable)BedPart.FOOT)).func_206870_a((Property)OCCUPIED, (Comparable)Boolean.FALSE)).func_206870_a((Property)CAN_DROP, (Comparable)Boolean.TRUE));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((BedPart)state.func_177229_b(PART)) {
            case FOOT: {
                return SLEEPING_BAG;
            }
            case HEAD: {
                switch ((Direction)state.func_177229_b((Property)field_185512_D)) {
                    case EAST: {
                        return SLEEPING_BAG_EAST;
                    }
                    case SOUTH: {
                        return SLEEPING_BAG_SOUTH;
                    }
                    case WEST: {
                        return SLEEPING_BAG_WEST;
                    }
                }
                return SLEEPING_BAG_NORTH;
            }
        }
        return SLEEPING_BAG;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        if (state.func_177229_b(PART) != BedPart.HEAD && !(state = world.func_180495_p(pos = pos.func_177972_a((Direction)state.func_177229_b((Property)field_185512_D)))).func_203425_a((Block)this)) {
            return ActionResultType.CONSUME;
        }
        if (!SleepingBagBlock.func_235330_a_((World)world)) {
            world.func_217377_a(pos, false);
            BlockPos blockpos = pos.func_177972_a(((Direction)state.func_177229_b((Property)field_185512_D)).func_176734_d());
            if (world.func_180495_p(blockpos).func_203425_a((Block)this)) {
                world.func_217377_a(blockpos, false);
            }
            return ActionResultType.SUCCESS;
        }
        if (((Boolean)state.func_177229_b((Property)OCCUPIED)).booleanValue()) {
            if (!this.kickVillagerOutOfBed(world, pos)) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("block.minecraft.bed.occupied"), true);
            }
            return ActionResultType.SUCCESS;
        }
        if (player instanceof ServerPlayerEntity) {
            this.startSleepInBed((ServerPlayerEntity)player, pos).ifLeft(sleepFailureReason -> {
                if (sleepFailureReason != null) {
                    player.func_146105_b(sleepFailureReason.func_221259_a(), true);
                }
            });
        }
        return ActionResultType.SUCCESS;
    }

    public Either<PlayerEntity.SleepResult, Unit> startSleepInBed(ServerPlayerEntity player, BlockPos pos) {
        Optional<BlockPos> optAt = Optional.of(pos);
        PlayerEntity.SleepResult ret = ForgeEventFactory.onPlayerSleepInBed((PlayerEntity)player, optAt);
        if (ret != null) {
            if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                player.func_242111_a(player.field_70170_p.func_234923_W_(), pos, player.field_70177_z, true, true);
            }
            return Either.left((Object)ret);
        }
        Direction direction = (Direction)player.field_70170_p.func_180495_p(pos).func_177229_b((Property)HorizontalBlock.field_185512_D);
        if (!player.func_70608_bn() && player.func_70089_S()) {
            if (!player.field_70170_p.func_230315_m_().func_236043_f_()) {
                if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                    player.func_242111_a(player.field_70170_p.func_234923_W_(), pos, player.field_70177_z, true, true);
                }
                return Either.left((Object)PlayerEntity.SleepResult.NOT_POSSIBLE_HERE);
            }
            if (!this.bedInRange((PlayerEntity)player, pos, direction)) {
                if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                    player.func_242111_a(player.field_70170_p.func_234923_W_(), pos, player.field_70177_z, true, true);
                }
                return Either.left((Object)PlayerEntity.SleepResult.TOO_FAR_AWAY);
            }
            if (this.bedBlocked((PlayerEntity)player, pos, direction)) {
                if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                    player.func_242111_a(player.field_70170_p.func_234923_W_(), pos, player.field_70177_z, true, true);
                }
                return Either.left((Object)PlayerEntity.SleepResult.OBSTRUCTED);
            }
            if (!ForgeEventFactory.fireSleepingTimeCheck((PlayerEntity)player, optAt)) {
                if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                    player.func_242111_a(player.field_70170_p.func_234923_W_(), pos, player.field_70177_z, true, true);
                }
                return Either.left((Object)PlayerEntity.SleepResult.NOT_POSSIBLE_NOW);
            }
            if (!player.func_184812_l_()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)pos);
                List list = player.field_70170_p.func_175647_a(MonsterEntity.class, new AxisAlignedBB(vector3d.func_82615_a() - 8.0, vector3d.func_82617_b() - 5.0, vector3d.func_82616_c() - 8.0, vector3d.func_82615_a() + 8.0, vector3d.func_82617_b() + 5.0, vector3d.func_82616_c() + 8.0), p_241146_1_ -> p_241146_1_.func_230292_f_((PlayerEntity)player));
                if (!list.isEmpty()) {
                    if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                        player.func_242111_a(player.field_70170_p.func_234923_W_(), pos, player.field_70177_z, true, true);
                    }
                    return Either.left((Object)PlayerEntity.SleepResult.NOT_SAFE);
                }
            }
            if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                Either either = player.func_213819_a(pos).ifRight(p_241144_1_ -> {
                    player.func_195066_a(Stats.field_188064_ad);
                    CriteriaTriggers.field_192136_p.func_192215_a(player);
                });
                ((ServerWorld)player.field_70170_p).func_72854_c();
                if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                    player.func_242111_a(player.field_70170_p.func_234923_W_(), pos, player.field_70177_z, true, true);
                }
                return either;
            }
            player.func_213342_e(pos);
            player.field_71076_b = 0;
            player.func_195066_a(Stats.field_188064_ad);
            CriteriaTriggers.field_192136_p.func_192215_a(player);
            ((ServerWorld)player.field_70170_p).func_72854_c();
            if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                player.func_242111_a(player.field_70170_p.func_234923_W_(), pos, player.field_70177_z, true, true);
            }
            return Either.right((Object)Unit.INSTANCE);
        }
        if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
            player.func_242111_a(player.field_70170_p.func_234923_W_(), pos, player.field_70177_z, true, true);
        }
        return Either.left((Object)PlayerEntity.SleepResult.OTHER_PROBLEM);
    }

    private boolean bedInRange(PlayerEntity player, BlockPos pos, Direction direction) {
        if (direction == null) {
            return false;
        }
        return this.isReachableBedBlock(player, pos) || this.isReachableBedBlock(player, pos.func_177972_a(direction.func_176734_d()));
    }

    private boolean isReachableBedBlock(PlayerEntity player, BlockPos p_241158_1_) {
        Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)p_241158_1_);
        return Math.abs(player.func_226277_ct_() - vector3d.func_82615_a()) <= 3.0 && Math.abs(player.func_226278_cu_() - vector3d.func_82617_b()) <= 2.0 && Math.abs(player.func_226281_cx_() - vector3d.func_82616_c()) <= 3.0;
    }

    private boolean bedBlocked(PlayerEntity player, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.func_177984_a();
        return !this.freeAt(player, blockpos) || !this.freeAt(player, blockpos.func_177972_a(direction.func_176734_d()));
    }

    protected boolean freeAt(PlayerEntity player, BlockPos pos) {
        return !player.field_70170_p.func_180495_p(pos).func_229980_m_((IBlockReader)player.field_70170_p, pos);
    }

    private boolean kickVillagerOutOfBed(World world, BlockPos pos) {
        List list = world.func_175647_a(VillagerEntity.class, new AxisAlignedBB(pos), LivingEntity::func_70608_bn);
        if (list.isEmpty()) {
            return false;
        }
        ((VillagerEntity)list.get(0)).func_213366_dy();
        return true;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance * 0.75f);
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        if (entityIn.func_226272_bl_()) {
            super.func_176216_a(worldIn, entityIn);
        } else {
            this.bounceUp(entityIn);
        }
    }

    private void bounceUp(Entity entity) {
        Vector3d vec3d = entity.func_213322_ci();
        if (vec3d.field_72448_b < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.func_213293_j(vec3d.field_72450_a, -vec3d.field_72448_b * (double)0.33f * d0, vec3d.field_72449_c);
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == SleepingBagBlock.getNeighbourDirection((BedPart)stateIn.func_177229_b(PART), (Direction)stateIn.func_177229_b((Property)field_185512_D))) {
            return facingState.func_203425_a((Block)this) && facingState.func_177229_b(PART) != stateIn.func_177229_b(PART) ? (BlockState)stateIn.func_206870_a((Property)OCCUPIED, facingState.func_177229_b((Property)OCCUPIED)) : Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private static Direction getNeighbourDirection(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.func_176734_d();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos backpackPos;
        boolean isFoot = state.func_177229_b(PART) == BedPart.FOOT;
        BlockPos blockPos = backpackPos = isFoot ? pos.func_177972_a(((Direction)state.func_177229_b((Property)field_185512_D)).func_176734_d()) : pos.func_177967_a(((Direction)state.func_177229_b((Property)field_185512_D)).func_176734_d(), 2);
        if (worldIn.func_180495_p(backpackPos).func_177230_c() instanceof TravelersBackpackBlock && worldIn.func_175625_s(backpackPos) instanceof TravelersBackpackTileEntity) {
            ((TravelersBackpackTileEntity)worldIn.func_175625_s(backpackPos)).setSleepingBagDeployed(false);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_195992_f();
        BlockPos blockpos = context.func_195995_a();
        BlockPos blockpos1 = blockpos.func_177972_a(direction);
        return context.func_195991_k().func_180495_p(blockpos1).func_196953_a(context) ? (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)direction) : null;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, PART, OCCUPIED, CAN_DROP});
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            BlockPos blockpos = pos.func_177972_a((Direction)state.func_177229_b((Property)field_185512_D));
            worldIn.func_180501_a(blockpos, (BlockState)state.func_206870_a(PART, (Comparable)BedPart.HEAD), 3);
            worldIn.func_230547_a_(pos, Blocks.field_150350_a);
            state.func_235734_a_((IWorld)worldIn, pos, 3);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        BlockPos blockpos = pos.func_177967_a((Direction)state.func_177229_b((Property)field_185512_D), state.func_177229_b(PART) == BedPart.HEAD ? 0 : 1);
        return MathHelper.func_180187_c((int)blockpos.func_177958_n(), (int)pos.func_177956_o(), (int)blockpos.func_177952_p());
    }

    public List<ItemStack> func_220076_a(BlockState pState, LootContext.Builder context) {
        if (!((Boolean)pState.func_177229_b((Property)CAN_DROP)).booleanValue()) {
            return Collections.emptyList();
        }
        return super.func_220076_a(pState, context);
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return null;
    }

    public DyeColor func_196350_d() {
        return this.color;
    }
}

