/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.api.fluids;

import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class EffectFluid {
    public String uniqueId;
    public Fluid fluid;
    public int effectID;
    public int amountRequired;

    public EffectFluid(String uniqueId, FluidStack fluidStack, int amountRequired) {
        this(uniqueId, fluidStack.getFluid(), amountRequired);
    }

    public EffectFluid(String uniqueId, Fluid fluid, int amountRequired) {
        this.uniqueId = uniqueId;
        this.fluid = fluid;
        this.effectID = 0;
        this.amountRequired = amountRequired;
        if (fluid != null) {
            EffectFluidRegistry.registerFluidEffect(this);
        }
    }

    public EffectFluid(String uniqueId, String modid, String fluidName, int amountRequired) {
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(modid, fluidName));
        this.uniqueId = uniqueId;
        this.fluid = fluid;
        this.effectID = 0;
        this.amountRequired = amountRequired;
        if (fluid != null) {
            EffectFluidRegistry.registerFluidEffect(this);
        }
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setEffectID(int id) {
        this.effectID = id;
    }

    public int getEffectID() {
        return this.effectID;
    }

    public abstract void affectDrinker(FluidStack var1, World var2, Entity var3);

    public abstract boolean canExecuteEffect(FluidStack var1, World var2, Entity var3);
}

