/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.stack;

import java.util.Collections;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IStackableContentsUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedbackpacks.api.UpgradeType;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;

public class StackUpgradeItem
extends UpgradeItemBase<Wrapper> {
    public static final UpgradeType<Wrapper> TYPE = new UpgradeType<Wrapper>(Wrapper::new);
    private final int stackSizeMultiplier;

    public StackUpgradeItem(int stackSizeMultiplier) {
        this.stackSizeMultiplier = stackSizeMultiplier;
    }

    public static int getInventorySlotLimit(IBackpackWrapper backpackWrapper) {
        int multiplier = 1;
        for (Wrapper stackWrapper : backpackWrapper.getUpgradeHandler().getTypeWrappers(TYPE)) {
            if (Integer.MAX_VALUE / stackWrapper.getStackSizeMultiplier() < multiplier) {
                return Integer.MAX_VALUE;
            }
            multiplier *= stackWrapper.getStackSizeMultiplier();
        }
        return 0x1FFFFFF < multiplier ? Integer.MAX_VALUE : multiplier * 64;
    }

    @Override
    public UpgradeType<Wrapper> getType() {
        return TYPE;
    }

    int getStackSizeMultiplier() {
        return this.stackSizeMultiplier;
    }

    @Override
    public UpgradeSlotChangeResult canRemoveUpgradeFrom(IBackpackWrapper backpackWrapper) {
        int currentInventoryMultiplier = StackUpgradeItem.getInventorySlotLimit(backpackWrapper) / 64;
        int multiplierWhenRemoved = currentInventoryMultiplier / this.stackSizeMultiplier;
        return this.isMultiplierHighEnough(backpackWrapper, multiplierWhenRemoved);
    }

    @Override
    public UpgradeSlotChangeResult canSwapUpgradeFor(ItemStack upgradeStackToPut, IBackpackWrapper backpackWrapper) {
        if (!(upgradeStackToPut.func_77973_b() instanceof StackUpgradeItem)) {
            return this.canRemoveUpgradeFrom(backpackWrapper);
        }
        StackUpgradeItem otherStackUpgradeItem = (StackUpgradeItem)upgradeStackToPut.func_77973_b();
        if (otherStackUpgradeItem.stackSizeMultiplier >= this.stackSizeMultiplier) {
            return new UpgradeSlotChangeResult.Success();
        }
        int currentInventoryMultiplier = StackUpgradeItem.getInventorySlotLimit(backpackWrapper) / 64;
        int multiplierWhenRemoved = currentInventoryMultiplier / this.stackSizeMultiplier;
        return this.isMultiplierHighEnough(backpackWrapper, multiplierWhenRemoved * otherStackUpgradeItem.stackSizeMultiplier);
    }

    private UpgradeSlotChangeResult isMultiplierHighEnough(IBackpackWrapper backpackWrapper, int multiplier) {
        HashSet<Integer> slotsOverMultiplier = new HashSet<Integer>();
        InventoryHelper.iterate((IItemHandler)backpackWrapper.getInventoryHandler(), (slot, stack) -> {
            int stackMultiplierNeeded = stack.func_190916_E() / stack.func_77976_d() + (stack.func_190916_E() % stack.func_77976_d() != 0 ? 1 : 0);
            if (stackMultiplierNeeded > multiplier) {
                slotsOverMultiplier.add((Integer)slot);
            }
        });
        HashSet<Integer> errorInventoryParts = new HashSet<Integer>();
        backpackWrapper.getUpgradeHandler().getSlotWrappers().forEach((slot, wrapper) -> {
            if (wrapper instanceof IStackableContentsUpgrade && ((IStackableContentsUpgrade)((Object)wrapper)).getMinimumMultiplierRequired() > multiplier) {
                errorInventoryParts.add((Integer)slot);
            }
        });
        if (!slotsOverMultiplier.isEmpty() || !errorInventoryParts.isEmpty()) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.translError("remove.stack_low_multiplier", multiplier), Collections.emptySet(), slotsOverMultiplier, errorInventoryParts);
        }
        return new UpgradeSlotChangeResult.Success();
    }

    public static class Wrapper
    extends UpgradeWrapperBase<Wrapper, StackUpgradeItem> {
        protected Wrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(backpackWrapper, upgrade, upgradeSaveHandler);
        }

        public int getStackSizeMultiplier() {
            return ((StackUpgradeItem)this.upgradeItem).getStackSizeMultiplier();
        }

        @Override
        public boolean hideSettingsTab() {
            return true;
        }

        @Override
        public boolean canBeDisabled() {
            return false;
        }
    }
}

