/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.pump;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IServerUpdater;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.pump.FluidFilterLogic;

public class FluidFilterContainer {
    private final PlayerEntity player;
    private final IServerUpdater serverUpdater;
    private final Supplier<FluidFilterLogic> fluidFilterLogic;
    private static final String DATA_FLUID = "setFluid";

    public FluidFilterContainer(PlayerEntity player, IServerUpdater serverUpdater, Supplier<FluidFilterLogic> fluidFilterLogic) {
        this.player = player;
        this.serverUpdater = serverUpdater;
        this.fluidFilterLogic = fluidFilterLogic;
    }

    public Fluid getFluid(int index) {
        return this.fluidFilterLogic.get().getFluid(index);
    }

    private void setFluid(int index, Fluid fluid) {
        this.fluidFilterLogic.get().setFluid(index, fluid);
        this.serverUpdater.sendDataToServer(() -> this.serializeSetFluidData(index, fluid));
    }

    private CompoundNBT serializeSetFluidData(int index, Fluid fluid) {
        CompoundNBT ret = new CompoundNBT();
        CompoundNBT fluidNbt = new CompoundNBT();
        fluidNbt.func_74768_a("index", index);
        fluidNbt.func_74778_a("fluid", fluid.getRegistryName().toString());
        ret.func_218657_a(DATA_FLUID, (INBT)fluidNbt);
        return ret;
    }

    public boolean handleMessage(CompoundNBT data) {
        if (data.func_74764_b(DATA_FLUID)) {
            CompoundNBT fluidData = data.func_74775_l(DATA_FLUID);
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidData.func_74779_i("fluid")));
            if (fluid != null) {
                this.setFluid(fluidData.func_74762_e("index"), fluid);
            }
            return true;
        }
        return false;
    }

    public int getNumberOfFluidFilters() {
        return this.fluidFilterLogic.get().getNumberOfFluidFilters();
    }

    public void slotClick(int index) {
        ItemStack carried = this.player.field_71071_by.func_70445_o();
        if (carried.func_190926_b()) {
            this.setFluid(index, Fluids.field_204541_a);
            return;
        }
        carried.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(itemFluidHandler -> {
            FluidStack containedFluid = itemFluidHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
            if (!containedFluid.isEmpty()) {
                this.setFluid(index, containedFluid.getRawFluid());
            }
        });
    }
}

