/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;

public class BackpackInsertMessage {
    private final int slotIndex;

    public BackpackInsertMessage(int slotIndex) {
        this.slotIndex = slotIndex;
    }

    public static void encode(BackpackInsertMessage msg, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(msg.slotIndex);
    }

    public static BackpackInsertMessage decode(PacketBuffer packetBuffer) {
        return new BackpackInsertMessage(packetBuffer.readInt());
    }

    static void onMessage(BackpackInsertMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> BackpackInsertMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayerEntity player, BackpackInsertMessage msg) {
        if (player == null) {
            return;
        }
        Container containerMenu = player.field_71070_bA;
        containerMenu.func_75139_a(msg.slotIndex).func_75211_c().getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> {
            ItemStack heldItem = player.field_71071_by.func_70445_o();
            player.field_71071_by.func_70437_b(wrapper.getInventoryForUpgradeProcessing().insertItem(heldItem, false));
            player.field_71137_h = false;
            player.func_71113_k();
        });
    }
}

