/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;

public class BackpackDyeRecipe
extends SpecialRecipe {
    public static final SpecialRecipeSerializer<BackpackDyeRecipe> SERIALIZER = new SpecialRecipeSerializer(BackpackDyeRecipe::new);

    public BackpackDyeRecipe(ResourceLocation registryName) {
        super(registryName);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        boolean backpackPresent = false;
        boolean dyePresent = false;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack slotStack = inv.func_70301_a(slot);
            if (slotStack.func_190926_b()) continue;
            Item item = slotStack.func_77973_b();
            if (item instanceof BackpackItem) {
                if (backpackPresent) {
                    return false;
                }
                backpackPresent = true;
                continue;
            }
            if (item instanceof DyeItem) {
                dyePresent = true;
                continue;
            }
            return false;
        }
        return backpackPresent && dyePresent;
    }

    public ItemStack assemble(CraftingInventory inv) {
        HashMap<Integer, List<DyeColor>> columnDyes = new HashMap<Integer, List<DyeColor>>();
        Tuple columnBackpack = null;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack slotStack = inv.func_70301_a(slot);
            if (slotStack.func_190926_b()) continue;
            Item item = slotStack.func_77973_b();
            int column = slot % inv.func_174922_i();
            if (item instanceof BackpackItem) {
                if (columnBackpack != null) {
                    return ItemStack.field_190927_a;
                }
                columnBackpack = new Tuple((Object)column, (Object)slotStack);
                continue;
            }
            if (item.func_206844_a((ITag)Tags.Items.DYES)) {
                DyeColor dyeColor = DyeColor.getColor((ItemStack)slotStack);
                if (dyeColor == null) {
                    return ItemStack.field_190927_a;
                }
                columnDyes.computeIfAbsent(column, c -> new ArrayList()).add(dyeColor);
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (columnBackpack == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack coloredBackpack = ((ItemStack)columnBackpack.func_76340_b()).func_77946_l();
        int backpackColumn = (Integer)columnBackpack.func_76341_a();
        this.applyBackpackColors(columnDyes, coloredBackpack, backpackColumn);
        return coloredBackpack;
    }

    private void applyBackpackColors(Map<Integer, List<DyeColor>> columnDyes, ItemStack coloredBackpack, int backpackColumn) {
        ArrayList clothDyes = new ArrayList();
        ArrayList trimDyes = new ArrayList();
        for (Map.Entry<Integer, List<DyeColor>> entry : columnDyes.entrySet()) {
            if (entry.getKey() <= backpackColumn) {
                clothDyes.addAll(entry.getValue());
            }
            if (entry.getKey() < backpackColumn) continue;
            trimDyes.addAll(entry.getValue());
        }
        coloredBackpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(coloredWrapper -> coloredWrapper.setColors(BackpackDyeRecipe.calculateColor(coloredWrapper.getClothColor(), 13394234, clothDyes), BackpackDyeRecipe.calculateColor(coloredWrapper.getBorderColor(), 6434330, trimDyes)));
    }

    public static int calculateColor(int baseColor, int defaultColor, List<DyeColor> dyes) {
        if (dyes.isEmpty()) {
            return baseColor;
        }
        int[] rgb = new int[3];
        int sumMaxComponent = 0;
        int numberOfColors = 0;
        if (baseColor != defaultColor) {
            float baseRed = baseColor >> 16 & 0xFF;
            float baseGreen = baseColor >> 8 & 0xFF;
            float baseBlue = baseColor & 0xFF;
            sumMaxComponent = (int)((float)sumMaxComponent + Math.max(baseRed, Math.max(baseGreen, baseBlue)));
            rgb[0] = (int)((float)rgb[0] + baseRed);
            rgb[1] = (int)((float)rgb[1] + baseGreen);
            rgb[2] = (int)((float)rgb[2] + baseBlue);
            ++numberOfColors;
        }
        for (DyeColor dye : dyes) {
            float[] dyeRgb = dye.func_193349_f();
            int dyeRed = (int)(dyeRgb[0] * 255.0f);
            int dyeGreen = (int)(dyeRgb[1] * 255.0f);
            int dyeBlue = (int)(dyeRgb[2] * 255.0f);
            sumMaxComponent += Math.max(dyeRed, Math.max(dyeGreen, dyeBlue));
            rgb[0] = rgb[0] + dyeRed;
            rgb[1] = rgb[1] + dyeGreen;
            rgb[2] = rgb[2] + dyeBlue;
            ++numberOfColors;
        }
        int avgRed = rgb[0] / numberOfColors;
        int avgGreen = rgb[1] / numberOfColors;
        int avgBlue = rgb[2] / numberOfColors;
        float avgMaxComponent = (float)sumMaxComponent / (float)numberOfColors;
        float maxAvgComponent = Math.max(avgRed, Math.max(avgGreen, avgBlue));
        avgRed = (int)((float)avgRed * avgMaxComponent / maxAvgComponent);
        avgGreen = (int)((float)avgGreen * avgMaxComponent / maxAvgComponent);
        avgBlue = (int)((float)avgBlue * avgMaxComponent / maxAvgComponent);
        int finalColor = (avgRed << 8) + avgGreen;
        finalColor = (finalColor << 8) + avgBlue;
        return finalColor;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 1;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }
}

