/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.compat.jei;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.crafting.BackpackDyeRecipe;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;

public class DyeRecipesMaker {
    private DyeRecipesMaker() {
    }

    public static Collection<ICraftingRecipe> getRecipes() {
        HashSet<ICraftingRecipe> recipes = new HashSet<ICraftingRecipe>();
        DyeRecipesMaker.addSingleColorRecipes(recipes);
        DyeRecipesMaker.addMultipleColorsRecipe(recipes);
        return recipes;
    }

    private static void addMultipleColorsRecipe(Set<ICraftingRecipe> recipes) {
        NonNullList ingredients = NonNullList.func_191196_a();
        ingredients.add((Object)Ingredient.func_199805_a((ITag)DyeColor.YELLOW.getTag()));
        ingredients.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.BACKPACK.get()}));
        ingredients.add((Object)Ingredient.field_193370_a);
        ingredients.add((Object)Ingredient.func_199805_a((ITag)DyeColor.LIME.getTag()));
        ingredients.add((Object)Ingredient.func_199805_a((ITag)DyeColor.BLUE.getTag()));
        ingredients.add((Object)Ingredient.func_199805_a((ITag)DyeColor.BLACK.getTag()));
        ItemStack backpackOutput = new ItemStack((IItemProvider)ModItems.BACKPACK.get());
        int clothColor = BackpackDyeRecipe.calculateColor(13394234, 13394234, (List<DyeColor>)ImmutableList.of((Object)DyeColor.BLUE, (Object)DyeColor.YELLOW, (Object)DyeColor.LIME));
        int trimColor = BackpackDyeRecipe.calculateColor(6434330, 6434330, (List<DyeColor>)ImmutableList.of((Object)DyeColor.BLUE, (Object)DyeColor.BLACK));
        backpackOutput.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> wrapper.setColors(clothColor, trimColor));
        ResourceLocation id = new ResourceLocation("sophisticatedbackpacks", "multiple_colors");
        recipes.add((ICraftingRecipe)new ShapedRecipe(id, "", 3, 1, ingredients, backpackOutput));
    }

    private static void addSingleColorRecipes(Set<ICraftingRecipe> recipes) {
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation id = new ResourceLocation("sophisticatedbackpacks", "single_color_" + color.func_176610_l());
            ItemStack backpackOutput = new ItemStack((IItemProvider)ModItems.BACKPACK.get());
            backpackOutput.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> wrapper.setColors(color.getColorValue(), color.getColorValue()));
            NonNullList ingredients = NonNullList.func_191196_a();
            ingredients.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.BACKPACK.get()}));
            ingredients.add((Object)Ingredient.func_199805_a((ITag)color.getTag()));
            recipes.add((ICraftingRecipe)new ShapedRecipe(id, "", 1, 2, ingredients, backpackOutput));
        }
    }
}

