/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;

public class RenderHelper {
    static final ResourceLocation BACKPACK_ENTITY_TEXTURE = new ResourceLocation("sophisticatedbackpacks", "textures/entity/backpack.png");

    private RenderHelper() {
    }

    public static void renderFluid(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, Fluid fluid, float fill, float xOffset, float yOffset, int fillYOffsetMultiplier, float zOffset) {
        if (MathHelper.func_180185_a((float)fill, (float)0.0f)) {
            return;
        }
        ResourceLocation texture = fluid.getAttributes().getStillTexture(new FluidStack(fluid, 5000));
        TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(texture);
        IVertexBuilder vertexBuilder = buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)PlayerContainer.field_226615_c_));
        int atlasWidth = (int)((float)still.func_94211_a() / (still.func_94212_f() - still.func_94209_e()));
        int atlasHeight = (int)((float)still.func_94216_b() / (still.func_94210_h() - still.func_94206_g()));
        ModelRenderer fluidBox = new ModelRenderer(atlasWidth, atlasHeight, (int)((float)atlasWidth * still.func_94209_e()), (int)((float)atlasHeight * still.func_94206_g()));
        fluidBox.func_228303_a_(xOffset, yOffset + (float)fillYOffsetMultiplier * fill * 10.0f, zOffset, 3.5f, fill * 10.0f, 4.0f, 0.0f, false);
        int color = fluid.getAttributes().getColor();
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        fluidBox.func_228309_a_(matrixStack, vertexBuilder, packedLight, OverlayTexture.field_229196_a_, red, green, blue, 1.0f);
    }

    public static void renderBatteryCharge(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, float charge) {
        int pixels = (int)(charge * 4.0f);
        ModelRenderer chargeBox = new ModelRenderer(64, 64, 18, 55);
        chargeBox.func_228303_a_(-2.0f, -3.0f, -6.01f, (float)pixels, 1.0f, 1.0f, 0.0f, false);
        IVertexBuilder vertexBuilder = buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)BACKPACK_ENTITY_TEXTURE));
        chargeBox.func_228308_a_(matrixStack, vertexBuilder, packedLight, OverlayTexture.field_229196_a_);
    }
}

