/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.backpack.BackpackSettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;
import org.apache.logging.log4j.util.TriConsumer;

public class BackpackSettingsManager {
    private static final String SOPHISTICATED_BACKPACK_SETTINGS_TAG = "sophisticatedBackpackSettings";
    private static final Map<String, BackpackSetting<?>> settings = new HashMap();
    public static final BackpackSetting<Boolean> SHIFT_CLICK_INTO_OPEN_TAB_FIRST = new BackpackSetting<Boolean>("shiftClickOpenTab", NBTHelper::getBoolean, CompoundNBT::func_74757_a, true);
    public static final BackpackSetting<Boolean> KEEP_TAB_OPEN = new BackpackSetting<Boolean>("keepTabOpen", NBTHelper::getBoolean, CompoundNBT::func_74757_a, true);

    private BackpackSettingsManager() {
    }

    public static Optional<BackpackSetting<?>> getBackpackSetting(String settingName) {
        return Optional.ofNullable(settings.get(settingName));
    }

    public static <T> T getPlayerSettingOrDefault(PlayerEntity player, BackpackSetting<T> setting) {
        return BackpackSettingsManager.getPlayerSetting(player, setting).orElse(setting.getDefaultValue());
    }

    public static <T> Optional<T> getPlayerSetting(PlayerEntity player, BackpackSetting<T> setting) {
        return setting.getValue(BackpackSettingsManager.getPlayerBackpackSettingsTag(player));
    }

    public static CompoundNBT getPlayerBackpackSettingsTag(PlayerEntity player) {
        return player.getPersistentData().func_74775_l(SOPHISTICATED_BACKPACK_SETTINGS_TAG);
    }

    public static void setPlayerBackpackSettingsTag(PlayerEntity player, CompoundNBT settingsNbt) {
        player.getPersistentData().func_218657_a(SOPHISTICATED_BACKPACK_SETTINGS_TAG, (INBT)settingsNbt);
    }

    public static <T> void setPlayerSetting(PlayerEntity player, BackpackSetting<T> setting, T value) {
        if (!player.getPersistentData().func_74764_b(SOPHISTICATED_BACKPACK_SETTINGS_TAG)) {
            player.getPersistentData().func_218657_a(SOPHISTICATED_BACKPACK_SETTINGS_TAG, (INBT)new CompoundNBT());
        }
        if (value != ((BackpackSetting)setting).defaultValue) {
            setting.setValue(BackpackSettingsManager.getPlayerBackpackSettingsTag(player), value);
        } else {
            setting.removeFrom(BackpackSettingsManager.getPlayerBackpackSettingsTag(player));
        }
    }

    public static <T> void setBackpackSetting(PlayerEntity player, BackpackSettingsCategory category, BackpackSetting<T> setting, T value) {
        T playerSettingValue = BackpackSettingsManager.getPlayerSetting(player, setting).orElse(setting.getDefaultValue());
        if (playerSettingValue != value) {
            category.setSettingValue(setting, value);
        } else {
            category.removeSetting(setting);
        }
    }

    public static <T> T getBackpackSettingValue(PlayerEntity player, BackpackSettingsCategory category, BackpackSetting<T> setting) {
        return category.getSettingValue(setting).orElse(BackpackSettingsManager.getPlayerSetting(player, setting).orElse(setting.getDefaultValue()));
    }

    static {
        settings.put(SHIFT_CLICK_INTO_OPEN_TAB_FIRST.getName(), SHIFT_CLICK_INTO_OPEN_TAB_FIRST);
        settings.put(KEEP_TAB_OPEN.getName(), KEEP_TAB_OPEN);
    }

    public static class BackpackSetting<T> {
        private final String tagName;
        private final BiFunction<CompoundNBT, String, Optional<T>> getValue;
        private final TriConsumer<CompoundNBT, String, T> setValue;
        private final T defaultValue;

        public BackpackSetting(String tagName, BiFunction<CompoundNBT, String, Optional<T>> getValue, TriConsumer<CompoundNBT, String, T> setValue, T defaultValue) {
            this.tagName = tagName;
            this.getValue = getValue;
            this.setValue = setValue;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.tagName;
        }

        public void setValue(CompoundNBT tag, T value) {
            this.setValue.accept((Object)tag, (Object)this.tagName, value);
        }

        public void removeFrom(CompoundNBT tag) {
            tag.func_82580_o(this.tagName);
        }

        public Optional<T> getValue(CompoundNBT tag) {
            return this.getValue.apply(tag, this.tagName);
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }
    }
}

