/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input.click;

import javax.annotation.Nullable;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.gui.Focus;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.InputHandler;
import mezz.jei.input.LimitedAreaMouseHandler;
import mezz.jei.input.click.MouseClickState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.InputMappings;

public class ClickFocusHandler
implements IMouseHandler {
    private final InputHandler inputHandler;
    private final RecipesGui recipesGui;

    public ClickFocusHandler(InputHandler inputHandler, RecipesGui recipesGui) {
        this.inputHandler = inputHandler;
        this.recipesGui = recipesGui;
    }

    @Override
    @Nullable
    public IMouseHandler handleClick(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState clickState) {
        IClickedIngredient<?> clicked = this.inputHandler.getFocusUnderMouseForClick(mouseX, mouseY, mouseButton);
        if (clicked == null) {
            return null;
        }
        if (this.handleMouseClickedFocus(mouseButton, clicked, clickState)) {
            return LimitedAreaMouseHandler.create(this, clicked.getArea());
        }
        InputMappings.Input input = InputMappings.Type.MOUSE.func_197944_a(mouseButton);
        if (this.inputHandler.handleFocusKeybinds(clicked, input, clickState)) {
            return LimitedAreaMouseHandler.create(this, clicked.getArea());
        }
        return null;
    }

    private <V> boolean handleMouseClickedFocus(int mouseButton, IClickedIngredient<V> clicked, MouseClickState clickState) {
        if (mouseButton == 0) {
            if (!clickState.isSimulate()) {
                Focus<V> focus = new Focus<V>(IFocus.Mode.OUTPUT, clicked.getValue());
                this.recipesGui.show(focus);
            }
            return true;
        }
        if (mouseButton == 1) {
            if (!clickState.isSimulate()) {
                Focus<V> focus = new Focus<V>(IFocus.Mode.INPUT, clicked.getValue());
                this.recipesGui.show(focus);
            }
            return true;
        }
        return false;
    }
}

