/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityShoebill;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootTables;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;

public class ShoebillAIFish
extends Goal {
    private EntityShoebill bird;
    private BlockPos waterPos = null;
    private BlockPos targetPos = null;
    private int executionChance = 0;
    private Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private int idleTime = 0;
    private int navigateTime = 0;

    public ShoebillAIFish(EntityShoebill bird) {
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.bird = bird;
    }

    public void func_75251_c() {
        this.targetPos = null;
        this.waterPos = null;
        this.idleTime = 0;
        this.navigateTime = 0;
        this.bird.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        if (this.targetPos != null && this.waterPos != null) {
            double dist = this.bird.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.waterPos));
            if (dist <= 1.0) {
                float yaw;
                this.navigateTime = 0;
                double d0 = (double)this.waterPos.func_177958_n() + 0.5 - this.bird.func_226277_ct_();
                double d2 = (double)this.waterPos.func_177952_p() + 0.5 - this.bird.func_226281_cx_();
                this.bird.field_70177_z = yaw = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.bird.field_70759_as = yaw;
                this.bird.field_70761_aq = yaw;
                this.bird.func_70661_as().func_75499_g();
                ++this.idleTime;
                if (this.idleTime > 25) {
                    this.bird.setAnimation(EntityShoebill.ANIMATION_FISH);
                }
                if (this.idleTime > 45 && this.bird.getAnimation() == EntityShoebill.ANIMATION_FISH) {
                    this.bird.func_184185_a(SoundEvents.field_187547_bF, 0.7f, 0.5f + this.bird.func_70681_au().nextFloat());
                    this.bird.resetFishingCooldown();
                    this.spawnFishingLoot();
                    this.func_75251_c();
                }
            } else {
                ++this.navigateTime;
                this.bird.func_70661_as().func_75492_a((double)this.waterPos.func_177958_n(), (double)this.waterPos.func_177956_o(), (double)this.waterPos.func_177952_p(), 1.2);
            }
            if (this.navigateTime > 3600) {
                this.func_75251_c();
            }
        }
    }

    public boolean func_75253_b() {
        return this.targetPos != null && this.bird.fishingCooldown == 0 && this.bird.revengeCooldown == 0 && !this.bird.isFlying();
    }

    public void spawnFishingLoot() {
        double luck = 0.0 + (double)((float)this.bird.luckLevel * 0.5f);
        LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.bird.field_70170_p);
        lootcontext$builder.func_186469_a((float)luck);
        LootParameterSet.Builder lootparameterset$builder = new LootParameterSet.Builder();
        List result = this.bird.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_186387_al).func_216113_a(lootcontext$builder.func_216022_a(lootparameterset$builder.func_216270_a()));
        for (ItemStack itemstack : result) {
            ItemEntity item = new ItemEntity(this.bird.field_70170_p, this.bird.func_226277_ct_() + 0.5, this.bird.func_226278_cu_(), this.bird.func_226281_cx_(), itemstack);
            if (this.bird.field_70170_p.field_72995_K) continue;
            this.bird.field_70170_p.func_217376_c((Entity)item);
        }
    }

    public boolean func_75250_a() {
        if (!this.bird.isFlying() && this.bird.fishingCooldown == 0 && this.bird.func_70681_au().nextInt(30) == 0) {
            if (this.bird.func_70090_H()) {
                this.targetPos = this.waterPos = this.bird.func_233580_cy_();
                return true;
            }
            this.waterPos = this.generateTarget();
            if (this.waterPos != null) {
                this.targetPos = this.getLandPos(this.waterPos);
                return this.targetPos != null;
            }
        }
        return false;
    }

    public BlockPos generateTarget() {
        BlockPos blockpos = null;
        Random random = new Random();
        int range = 32;
        for (int i = 0; i < 15; ++i) {
            BlockPos blockpos1 = this.bird.func_233580_cy_().func_177982_a(random.nextInt(range) - range / 2, 3, random.nextInt(range) - range / 2);
            while (this.bird.field_70170_p.func_175623_d(blockpos1) && blockpos1.func_177956_o() > 1) {
                blockpos1 = blockpos1.func_177977_b();
            }
            if (!this.isConnectedToLand(blockpos1)) continue;
            blockpos = blockpos1;
        }
        return blockpos;
    }

    public boolean isConnectedToLand(BlockPos pos) {
        if (this.bird.field_70170_p.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a)) {
            for (Direction dir : this.HORIZONTALS) {
                BlockPos offsetPos = pos.func_177972_a(dir);
                if (!this.bird.field_70170_p.func_204610_c(offsetPos).func_206888_e() || !this.bird.field_70170_p.func_204610_c(offsetPos.func_177984_a()).func_206888_e()) continue;
                return true;
            }
        }
        return false;
    }

    public BlockPos getLandPos(BlockPos pos) {
        if (this.bird.field_70170_p.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a)) {
            for (Direction dir : this.HORIZONTALS) {
                BlockPos offsetPos = pos.func_177972_a(dir);
                if (!this.bird.field_70170_p.func_204610_c(offsetPos).func_206888_e() || !this.bird.field_70170_p.func_204610_c(offsetPos.func_177984_a()).func_206888_e()) continue;
                return offsetPos;
            }
        }
        return null;
    }
}

